﻿<%@ Page Language="C#" Inherits="GGCMS.GuanLi.FileEdit" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>
        <%=menuinfo.MenuName%>-<%=shezhi.JianCheng %>_GGCMS后台管理</title>
    <meta name="robots" content="nofollow">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7" />

    <script type="text/javascript" src="../js/jquery.js"></script>

    <script type="text/javascript" src="../js/jquery-ui.js"></script>

    <script type="text/javascript" src="../js/gl_list.js"></script>

    <script type="text/javascript" src="../js/JsTools.js"></script>

    <script type="text/javascript" src="../js/beautify.js"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            var fname = $("#filename").text().toLowerCase();
            if (fname.indexOf(".js") == -1 && fname.indexOf(".css") == -1) {
                $("#MyForm h2 input,#MyForm .GGPages").hide();
            } else {
                $("#btn").click(function() {
                    var packer = new Packer;
                    var c = $("#tbContent").val();
                    if (c.length <= 0 || c == "请输入内容") {
                        $("#tbContent").val("请输入内容");

                    } else {
                        var v = packer.pack(c, true, true);
                        $("#tbContent").val(v);
                    }
                });

                $("#btnDecode").click(function() {
                    var c = $("#tbContent").val();
                    if (c.length <= 0 || c == "请输入内容") {
                        $("#tbContent").val("请输入内容");

                    } else {
                        var r = eval(c.slice(4));
                        r = r.replace(/^\s+/, '');
                        if (r && r.charAt(0) === '<') {
                            r = style_html(r, 4, ' ', 80);
                        } else {
                            r = js_beautify(r, 4, ' ');
                        }
                        $("#tbContent").val(r);
                    }
                });

                $("#btnJSFormat").click(function() {
                    var r = $("#tbContent").val();
                    r = r.replace(/^\s+/, '');
                    if (r && r.charAt(0) === '<') {
                        r = style_html(r, 4, ' ', 80);
                    } else {
                        r = js_beautify(r, 4, ' ');
                    }
                    $("#tbContent").val(r);
                });

                $("#btnJSYS").click(function() {
                    var c = $("#tbContent").val();
                    if (c.length <= 0 || c == "请输入内容") {
                        $("#tbContent").val("请输入内容");

                    } else {
                        var v = jsmin("", c, 2);
                        $("#tbContent").val(v);
                        alert("原来大小" + jsmin.oldSize + " 压缩后大小：" + jsmin.newSize + "  压缩率为：" + (Math.round(jsmin.newSize / jsmin.oldSize * 1000) / 10) + '%');
                    }
                });

                $("#btnCSSFormat").click(function() {
                    CSS('format');
                });

                $("#btnCSSYS").click(function() {
                    CSS('pack');
                });
            }
        });
        var lCSSCoder = {
            format: function(s) {//格式化代码
                s = s.replace(/\s*([\{\}\:\;\,])\s*/g, "$1");
                s = s.replace(/;\s*;/g, ";"); //清除连续分号
                s = s.replace(/\,[\s\.\#\d]*{/g, "{");
                s = s.replace(/([^\s])\{([^\s])/g, "$1 {\n\t$2");
                s = s.replace(/([^\s])\}([^\n]*)/g, "$1\n}\n$2");
                s = s.replace(/([^\s]);([^\s\}])/g, "$1;\n\t$2");
                return s;
            },
            pack: function(s) {//压缩代码
                s = s.replace(/\/\*(.|\n)*?\*\//g, ""); //删除注释
                s = s.replace(/\s*([\{\}\:\;\,])\s*/g, "$1");
                s = s.replace(/\,[\s\.\#\d]*\{/g, "{"); //容错处理
                s = s.replace(/;\s*;/g, ";"); //清除连续分号
                s = s.match(/^\s*(\S+(\s+\S+)*)\s*$/); //去掉首尾空白
                return (s == null) ? "" : s[1];
            }
        };
        function CSS(s) {
            var r = $("#tbContent").val();
            r = lCSSCoder[s](r);
            $("#tbContent").val(r);
        }
    </script>

    <link href="../js/jquery-ui.css" rel="stylesheet" type="text/css" />
    <link type="text/css" rel="stylesheet" href="../style/GuanLi/Style.css" />
    <style type="text/css">
        #tbContent
        {
            width: 100%;
            height: 400px;
        }
    </style>
</head>
<body>
    <div id="Holder">
        <div id="MainPage">
            <!--#include file="head.inc"-->
            <div id="MainBody" class="layout-full-width">
                <div class="layout-sidebar">
                    <%=LeftMenuList(refminfo)%>
                </div>
                <div id="OverviewMain" class="clear-fix">
                    <div class="layout-main">
                        <div class="layout-block-header box overview-head">
                            <form id="MyForm" runat="server">
                            <div class="prompt GGPages">使用工具前，请先对原文件备份</div>
                            <h2>
                                <%=menuinfo.MenuName%>
                                <input class="ui-button" type="button" onclick="javascript:DigHtmlToJs('#html2js','#tbContent');"
                                    value="Html,JS转换工具" />
                                <input class="ui-button" id="btnJSFormat" type="button" value="JS格式化" />
                                <input class="ui-button" id="btnJSYS" type="button" value="JS普通压缩" />
                                <input class="ui-button" id="btnDecode" type="button" value="JS解密" />
                                <input class="ui-button" id="btn" type="button" value="JS加密压缩" />
                                <input class="ui-button" id="btnCSSFormat" type="button" value="CSS解压" />
                                <input class="ui-button" id="btnCSSYS" type="button" value="CSS压缩" />
                                <asp:Button ID="butJingHua" CssClass="ui-button" runat="server" Text="JS净化" OnClick="butJingHua_Click"
                                    Visible="false" />
                                <asp:Button ID="butYaSuo" CssClass="ui-button" runat="server" Text="JS压缩" OnClick="butYaSuo_Click"
                                    Visible="false" />
                            </h2>
                            <p class="hline" />
                            <div id="filename">
                                <asp:Literal ID="ltMsg" runat="server"></asp:Literal>
                            </div>
                            <div>
                                <asp:TextBox ID="tbContent" runat="server" TextMode="MultiLine"></asp:TextBox>
                                <asp:TextBox ID="tbFile" runat="server" Visible="False"></asp:TextBox>
                                <asp:TextBox ID="tbLastUrl" runat="server" Visible="False"></asp:TextBox>
                            </div>
                            <center>
                                <asp:Button ID="butSave" runat="server" Text="保存" CssClass="ui-button" OnClick="butSave_Click" />
                                &nbsp;<asp:Button ID="butCancel" runat="server" Text="取消" CssClass="ui-button" OnClick="butCancel_Click" />
                            </center>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!--#include file="foot.inc"-->
        </div>
    </div>
    <div class="hidden" id="html2js">
        <table style="width: 100%;">
            <tr>
                <td>
                    <textarea id="ta1" rows="8" cols="100"></textarea>
                </td>
            </tr>
            <tr>
                <td align="center">
                    <span class="ui-button" onclick="javascript:HtmlToJs('#ta1','#ta2',true);">HTML转JS</span> <span
                        class="ui-button" onclick="javascript:HtmlToJs('#ta1','#ta2',false);">JS转HTML</span>
                        <span class="ui-button" onclick="javascript:CodeSwitch('#ta1','#ta2');">互换</span>
                </td>
            </tr>
            <tr>
                <td>
                    <textarea id="ta2" rows="8" cols="100"></textarea>
                </td>
            </tr>
            <tr>
                <td align="center">
                    <span class="ui-button" onclick="javascript:$.copy($('#ta2').val());">复制到剪贴板</span>
                    <span class="ui-button" onclick="javascript:InstertCode('#tbContent','#ta2','#html2js');">
                        插入到光标处</span>
                </td>
            </tr>
        </table>
    </div>
</body>
</html>
