(function($) {
    get_uri_base = function(url){
        var parser = parseUri(url);
        if ( parser.port != null && parser.port != "" ){   
            return parser.protocol + "://" + parser.host + ":" + parser.port;   
        } else {   
            return parser.protocol + "://" + parser.host;
        }
    };


    nie.use(["ui.pop"], function() {
        page_alert = function(msg, func) {
            if ($("#pop_win").size() == 0) {
                alert(msg.toString());
                if (func) {
                    func();
                }
            } else {
                var pop = $.nie.pop({
                    el: '#pop_win',
                    settings: {
                        title: '𾴵վ',
                        content: msg.toString(),
                        tip: ''
                    }
                });
                $("#pop_win .pop-close").click(function() {
                    if (func) {
                        func();
                    }
                });
                pop.show();
            }
        }
    });


    send_request = function(url, method, target) {
        var parser = parseUri(url);
        var action = get_uri_base(url) + parser.path;
        if (parser.host == null || parser.host == "") {
            //relative path
            action = parser.path;
        }
     
        // parse query string
        var query = parser.query;
        var re = /(?:^|&)([^&=]*)=?([^&]*)/g
        var params = [];
        query.replace(re, function($0, $1, $2) {
            if ($1) {
                params.push([$1, $2]);
            }
        });

        var form = $("<FORM>");
        form.attr("method", method);
        form.attr("action", action);
        if(target) form.attr("target", target);
        
        for (var i in params) {
            var input = $("<INPUT>");
            input.attr("type", "hidden");
            input.attr("name", params[i][0]);
            input.attr("value", decodeURIComponent(params[i][1]));
            input.appendTo(form);
        }

        form.appendTo($("BODY"));
        form.submit();
    }


    JsonAjax = function(){
        // private var
        var _this = this;

        // public var
        _this.ajaxing = false;

        // private method
        var _reset_success = function(success) {
            return function(json) {
                if (json.error != undefined) {
                    if (_this.onJsonError) {
                        _this.onJsonError(json.error, json);
                    } else {
                        page_alert(json.error, function() {
                            if (json.url) {
                                page_redirect(json.url);
                            }
                        });
                    }
                } else if(json.info != undefined) {
                    if (_this.onJsonInfo) {
                        _this.onJsonInfo(json.info, json);
                    } else {
                        page_alert(json.info, function() {
                            if (json.url) {
                                page_redirect(json.url);
                            }
                        });
                    }
                } else if(json.url != undefined) {
                    page_redirect(json.url);
                } else if (json.data != undefined && success) {
                    success(json.data, json);
                } else if (success) {
                    success();
                }
            };
        };

        var _reset_option = function(option) {
            if (!option) option = {};

            if (option.success) {
                var success = option.success;
                option.success = _reset_success(success);
            }

            if (option.beforeSend) {
                var beforeSend = option.beforeSend;
                option.beforeSend = function(XMLHttpRequest){
                    var need_send = beforeSend(XMLHttpRequest);
                    if (need_send) {
                        _this.ajaxing = true;
                    }
                    return need_send;
                };
            }

            if (option.complete) {
                var complete = option.complete;
                option.complete= function(XMLHttpRequest, textStatus){
                    _this.ajaxing = false;
                    complete(XMLHttpRequest, textStatus);
                };
            }

            if (option.cache == undefined) option.cache = false;
            if (!option.dataType) option.dataType = "json";
            if (!option.error) option.error = function(XMLHttpRequest, textStatus, errorThrown) {
                page_alert("ܱǸϵͳʱ޷ӦԺԡ");
            };
            
            return option;
        };

        // public method
        _this.ajax = function(option) {
            option = _reset_option(option);
            $.ajax(option);
        };

        _this.ajaxForm = function(form, option) {
            option = _reset_option(option);

            switch(typeof(form)){
                case "string": {
                    $("#" + form).ajaxForm(option);
                    break;
                }
                case "object": {
                    $(form).ajaxForm(option);
                    break;
                }
            }
        };

        _this.ajaxSubmit = function(form, option) {
            option = _reset_option(option);
            
            switch(typeof(form)){
                case "string": {
                    $("#" + form).ajaxSubmit(option);
                    break;
                }
                case "object": {
                    $(form).ajaxSubmit(option);
                    break;
                }
            }
        };
    };

    page_redirect = function(url) {
        //window.location.href = url;
        send_request(url, "GET");
    }

    String.prototype.trim = function() {
        return this.replace(/(^\s*)|(\s*$)/g, "");
    }

    Date.prototype.dayOfYear = function(){
        var monthday = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
        var cYear = this.getYear();
        var cMonth = this.getMonth();
        var cDate = this.getDate();
        if((cYear%100 != 0 && cYear%4 == 0) || cYear%400 == 0) monthday[1] = 29;

        var result = 0;
        for(var i=0; i<cMonth; i++) result += monthday[i];
        return result + cDate;
    };     

    assert = function(condition, err_msg) {
        if (!condition) {
            alert(err_msg);
            throw new Error(err_msg);
        }
    }

    is_positive_int = function(input) {
        return /^[1-9]\d*$/.test(input.toString());
    }

    copy_text = function(text, show_callback) {
        if (window.clipboardData) {
            window.clipboardData.setData("Text", text);
            alert("Ƴɹ");
        } else {
            if (show_callback) {
                show_callback(text);
            } else {
                prompt("ֶӣ", text);
            }
        } 
    }

    click_show_authcode = function(input_sel, img_sel, change_sel, type) {
        if(type == undefined) type = 1;

        var refresh_authcode = function() {
            $(img_sel).attr("src", "/gs2/union/authcode/show?type="+type+"&t=" + (Math.floor(Math.random()*9999999)+1));
            return false;
        }

        var show_img = function() {
            refresh_authcode();
            $(img_sel).show();

            if(input_sel) $(input_sel).unbind("focus", show_img).css("color", "").val("");
            if(change_sel) $(change_sel).show();
        }

        $(img_sel).bind("click", refresh_authcode);
        if(input_sel) $(input_sel).css("color", "#868686").bind("focus", show_img);
        if(change_sel) $(change_sel).bind("click", refresh_authcode);
    }

    TipedInput = {
        "init": function(obj, tip, default_val, color){
            var input = obj;
            var tip_color = "#999999";

            if(typeof(obj) == "string") {
                input = $("#" + obj);
            } else {
                input = $(obj);
            }

            if(typeof(color) != "undefined") tip_color = color;

            // if tip exists, do nothing    
            if(typeof(input.attr("tip")) != "undefined") return;

            if (default_val) {
                input.val(default_val);
            } else {
                input.val(tip);
            }
            input.css("color", tip_color);
            input.attr("tip", tip);

            input.bind("focus", function(){
                if(input.val() != tip) return;

                input.val("");
                input.css("color", "");
            }).bind("blur", function(){
                if(input.val() != "") return;

                input.val(tip);
                input.css("color", tip_color);
            }); 
        },
        "val": function(obj){
            var input = obj;

            if (typeof(obj) == "string") {
                input = $("#" + obj);
            } else {
                input = $(obj);
            }

            var tip = input.attr("tip");
            if (input.val() == tip) {
                return "";
            } else {
                return input.val();
            }
        }
    };

    JsPat = function(){
        var bTag = /<({|%)/g, eTag = /(}|%)>/g;
        var bTagLen = 2, eTagLen = 2;

        var tagTypes = {
            "%": "s",
            "{": "v"
        };

        var pool = {};

        var encode = function(html) {
            return html.replace(/(\r|\n|')/g, function(w){
                return {"\r":"\\r", "\n":"\\n", "'":"\\'"}[w];
            })
        };

        this.get = function(pat, alias){
            if(alias && pool[alias]) return pool[alias];

            bTag.lastIndex = 0;
            eTag.lastIndex = 0;

            var parts = [], i = null, j = null, p = 0, e = pat.length;
            while(p<e){
                i = bTag.exec(pat)||{index:-1};
                if(i.index >= 0) j = eTag.exec(pat)||{index:-1};
                else { i.index = e; j=i; }

                if(i.index > p) parts.push({"type": "t", "src": pat.substring(p, i.index)});
                if(j.index > i.index)
                    parts.push({"type": tagTypes[i[1]], "src": pat.substring(i.index + bTagLen, j.index)})

                p = j.index + eTagLen;
            }

            var tmp = ["({render:function(data){var text='';"];
            for(var x=0; x<parts.length; x++){
                var part = parts[x];

                switch(part.type){
                    case "t": {
                        tmp.push("text+='");
                        tmp.push(encode(part.src));
                        tmp.push("';");
                        break;
                    }
                    case "s": {
                        tmp.push(part.src);
                        break;
                    }
                    case "v": {
                        tmp.push("text+=");
                        tmp.push(part.src);
                        tmp.push(";");
                    }
                }
            }
            tmp.push("return text;}});");

            var result = eval(tmp.join(""));
            if(alias) pool[alias] = result;
            return result;
        }
    };
})(jQuery);
