﻿$(function () {

    //提示对象文字Css(默认,错误,正确)
    var msgClass = {
        "css": "ico-remind",
        "error": "point ico-error R",
        "via": "point ico-via Q",
        "remind": "point ico-remind V"
    }

    //提示对象文字
    var msgStr = {
        "ok": "输入格式正确",
        "checked": "至少选择一项",
        "noNull": "不能为空",
        "email": "Email格式有误",
        "phone": "电话格式有误",
        "fax": "传真格式有误",
        "url": "格式应为http://开头",
        "number": "格式只允许(数字)",
        "english": "格式只允许(字母)",
        "engnum": "格式只允许(字母,数字,下划线)",
        "chinese": "格式只允许(中文,下划线)",
        "chinaennum": "格式只允许(中文,字母,数字,下划线)",
        "syskey": "包含非法字符",
        "word6_20": "长度为6-20",
        "name4_12": "长度在4-12",
        "format": "point ico-remind V",
        "select": "请选择",
        "select_ok": "选择通过",
        "save": "正在保存…"
    }

    //首次加载传入焦点
    if ($("form#FormControl")[0]) $("form#FormControl input[type='text']:first").focus();

    //公共处理
    $("form#FormControl input,textarea").live('blur', function () {
        if ($(this).hasClass("isNull")) if (!isNull($(this))) return isNull($(this));
        if ($(this).hasClass("isNumber")) if (!isNumber($(this))) return isNumber($(this));
        if ($(this).hasClass("isEnglish")) if (!isEnglish($(this))) return isEnglish($(this));
        if ($(this).hasClass("isChinese")) if (!isChinese($(this))) return isChinese($(this));
        if ($(this).hasClass("isEngNum")) if (!isEngNum($(this))) return isEngNum($(this));
        if ($(this).hasClass("isChinaEnNum")) if (!isChinaEnNum($(this))) return isChinaEnNum($(this));
        if ($(this).hasClass("isWord6_20")) if (!isWord6_20($(this))) return isWord6_20($(this));
        if ($(this).hasClass("isName4_12")) if (!isName4_12($(this))) return isName4_12($(this));
        if ($(this).hasClass("isEmail")) if (!isEmail($(this))) return isEmail($(this));
        if ($(this).hasClass("isPhone")) if (!isPhone($(this))) return isPhone($(this));
        if ($(this).hasClass("isFax")) if (!isFax($(this))) return isFax($(this));
        if ($(this).hasClass("isUrl")) if (!isUrl($(this))) return isUrl($(this));
        if ($(this).hasClass("isSysKey")) if (!isSysKey($(this))) return isSysKey($(this));
    });

    //select离开
    $("form#FormControl select").live('change', function () {
        if ($(this).is(".isNull")) return isNull($(this));
    });

    //================================方法=======================================
    //判断是否Url格式
    function isUrl(obj) {
        var reg = /^((http|https):\/\/.+?)$/;
        if (!reg.test(obj.val())) {
            obj.next("span").attr("class", msgClass.error).text(cutSign(obj.prev().text()) + msgStr.url);
            return false;
        } else {
            if (!obj.next("span").hasClass(msgClass.css)) obj.next("span").attr("class", msgClass.via).text(msgStr.ok);
            return true;
        }
    }

    //判断是否Email
    function isEmail(obj) {
        var reg = /.+@.+\.[a-zA-Z]{2,4}$/;
        if (!reg.test(obj.val())) {
            obj.next("span").attr("class", msgClass.error).text(cutSign(obj.prev().text()) + msgStr.email);
            return false;
        } else {
            if (!obj.next("span").hasClass(msgClass.css)) obj.next("span").attr("class", msgClass.via).text(msgStr.ok);
            return true;
        }
    }
    //判断是否为正确的电话格式（中国）
    function isPhone(obj) {
        var reg = /(^[0-9]{3,4}\-[0-9]{3,8}$)|(^[0-9]{3,8}$)|(^\([0-9]{3,4}\)[0-9]{3,8}$)|(^[0-9]{3,4}[0-9]{3,8}$)|(^0{0,1}13[0-9]{9}$)/;
        if (!reg.test(obj.val())) {
            obj.next("span").attr("class", msgClass.error).text(cutSign(obj.prev().text()) + msgStr.phone);
            return false;
        } else {
            if (!obj.next("span").hasClass(msgClass.css)) obj.next("span").attr("class", msgClass.via).text(msgStr.ok);
            return true;
        }
    }
    //判断是否为传真格式
    function isFax(obj) {
        var reg = /0086\-[0-9]{3,4}\-[0-9]{8}$/;
        if (!reg.test(obj.val())) {
            obj.next("span").attr("class", msgClass.error).text(msgStr.fax);
            return false;
        } else {
            if (!obj.next("span").hasClass(msgClass.css)) obj.next("span").attr("class", msgClass.via).text(msgStr.ok);
            return true;
        }
    }
    //判断是否为数字
    function isNumber(obj) {
        var reg = /^[\d|\.|,]+$/;
        if (!reg.test(obj.val())) {
            obj.next("span").attr("class", msgClass.error).text(cutSign(obj.prev().text()) + msgStr.number);
            return false;
        } else {
            if (!obj.next("span").hasClass(msgClass.css)) obj.next("span").attr("class", msgClass.via).text(msgStr.ok);
            return true;
        }
    }
    //判断是否为英文
    function isEnglish(obj) {
        var reg = /^[A-Za-z]{0,25}$/;
        if (!reg.test(obj.val())) {
            obj.next("span").attr("class", msgClass.error).text(cutSign(obj.prev().text()) + msgStr.english);
            return false;
        } else {
            if (!obj.next("span").hasClass(msgClass.css)) obj.next("span").attr("class", msgClass.via).text(msgStr.ok);
            return true;
        }
    }

    //判断是否系统关键词
    function isSysKey(obj) {
        var reg = /sys|manage|script|jquery|admin|administrator|script|images|css|style|ajax|upload|select|delete|upload|<|>|\*|\'|\'\'|\"/ig;
        if (reg.test(obj.val())) {
            obj.next("span").attr("class", msgClass.error).text(cutSign(obj.prev().text()) + msgStr.syskey);
            return false;
        } else {
            if (!obj.next("span").hasClass(msgClass.css)) obj.next("span").attr("class", msgClass.via).text(msgStr.ok);
            return true;
        }
    }

    //判断是否为中文,英文,数字
    function isChinaEnNum(obj) {
        var reg = /^[a-zA-Z0-9_\u4E00-\u9FA5]+$/;
        if (!reg.test(obj.val())) {
            obj.next("span").attr("class", msgClass.error).text(cutSign(obj.prev().text()) + msgStr.chinaennum);
            return false;
        } else {
            if (!obj.next("span").hasClass(msgClass.css)) obj.next("span").attr("class", msgClass.via).text(msgStr.ok);
            return true;
        }
    }

    //判断是否为数字和英文_
    function isEngNum(obj) {
        var reg = /^[a-zA-Z0-9_|   |　]+$/;
        if (!reg.test(obj.val())) {
            obj.next("span").attr("class", msgClass.error).text(cutSign(obj.prev().text()) + msgStr.engnum);
            return false;
        } else {
            if (!obj.next("span").hasClass(msgClass.css)) obj.next("span").attr("class", msgClass.via).text(msgStr.ok);
            return true;
        }
    }
    //判断是否为中文
    function isChinese(obj) {
        var reg = /[^u4E00-u9FA5]/g;
        if (!reg.test(obj.val())) {
            obj.next("span").attr("class", msgClass.error).text(cutSign(obj.prev().text()) + msgStr.chinese);
            return false;
        } else {
            if (!obj.next("span").hasClass(msgClass.css)) obj.next("span").attr("class", msgClass.via).text(msgStr.ok);
            return true;
        }
    }

    //判断长度在6-20之间，只包含字母，数字和下划线 
    function isWord6_20(obj) {
        var reg = /^\w{6,20}$/;
        if (!reg.test(obj.val())) {
            obj.next("span").attr("class", msgClass.error).text(cutSign(obj.prev().text()) + msgStr.word6_20);
            return false;
        } else {
            if (!obj.next("span").hasClass(msgClass.css)) obj.next("span").attr("class", msgClass.via).text(msgStr.ok);
            return true;
        }
    }

    //是否有效名称,长度在4-12之间的，只包含字母，数字和下划线 
    function isName4_12(obj) {
        if (obj.val().length < 4 || obj.val().length > 12) {
            obj.next("span").attr("class", msgClass.error).text(cutSign(obj.prev().text()) + msgStr.name4_12);
            return false;
        } else {
            if (!obj.next("span").hasClass(msgClass.css)) obj.next("span").attr("class", msgClass.via).text(msgStr.ok);
            return true;
        }
    }
    //判断input不能为空
    function isNull(obj) {
        if (obj.is("input:text,input:password,textarea")) {
            if (obj.val() == "") {
                obj.next("span").attr("class", msgClass.error).text(cutSign(obj.prev().text()) + msgStr.noNull);
                return false;
            } else {
                if (!obj.next("span").hasClass(msgClass.css)) obj.next("span").attr("class", msgClass.via).text(msgStr.ok);
                return true;
            };

        }
        if (obj.is("select")) {
            if (obj.val() == "0") {
                obj.next("span").attr("class", msgClass.error).text(msgStr.select + cutSign(obj.prev().text()));
                return false;
            } else {
                if (!obj.next("span").hasClass(msgClass.css)) obj.next("span").attr("class", msgClass.via).text(msgStr.select_ok);
                return true;
            }
        }

    }
    //================================end 方法=======================================

    //alt+s提交
    $(document).keydown(function (event) {
        if ($("form#FormControl")[0]) {
            //获得键盘代码
            if (event.ctrlKey == true && event.keyCode == 83) {
                $("form#FormControl").submit();
            }
        }
    });


    //去除:*
    function cutSign(obj) {
        obj = obj.replace(':', '');
        obj = obj.replace('*', '');
        return obj;
    }
})