﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="EoyooCMS.ManageCode.Resource_File" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>文件资源</title>
    <meta http-equiv="Pragma" content="no-cache" />
    <meta http-equiv="Cache-Control" content="no-cache" />
    <meta http-equiv="Expires" content="0" />
    <script type="text/javascript" src="Script/Jquery.js"></script>
    <script type="text/javascript" src="Script/Common.js"></script>
    <script src="Script/Resource.js" type="text/javascript"></script>
    <link href="Style/Iframe.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <div class="wrapper-div">
        <!-- 文章列表管理 -->
        <!-- 标 -->
        <div class="title-tab">
            <div class="title">
                <span class="title-ico titico5 F B">文件资源 - <span class="V NoB">文件列表</span></span></div>
            <ul class="menu">
                <li><a class="<%=sift=="all"?"active":"" %>" href="<%=getFormUrl %>?sift=all"><span>全部</span></a></li>
                <li><a class="<%=sift=="1"?"active":"" %>" href="<%=getFormUrl %>?sift=1"><span>普通上传类</span></a></li>
                <li><a class="<%=sift=="2"?"active":"" %>" href="<%=getFormUrl %>?sift=2"><span>编辑器Flash类</span></a></li>
                <li><a class="<%=sift=="3"?"active":"" %>" href="<%=getFormUrl %>?sift=3"><span>数据库备份类</span></a></li>
                <li><a class="<%=sift=="4"?"active":"" %>" href="<%=getFormUrl %>?sift=4"><span>模板备份类</span></a></li>
            </ul>
        </div>
        <!-- end 标 -->
        <div class="clear-8"></div>
        <div class="PageBoxleft G file-ico">资源文件检索结果： <span id="fileNumber" class="R B"><%=_pageCount%></span> 个 , 占总容量：<span class="Q B"><%=EoyooCMS.Common.Utils.FormatLength(_fileAllSize)%> </span></div>
        <p class="PageBox">
            <%=getPagesInfo%>
        </p>
        <div class="clear-8">
        </div>
        <!-- 通用table -->
        <table class="table-1">
            <thead>
                <tr>
                    <th width="50%" class="text_left">文件</th>
                    <th width="20%">大小</th>
                    <th width="8%">创建时间</th>
                    <th width="8%">修改时间</th>
                    <th width="6%">后缀</th>
                    <th width="8%">操作</th>
                </tr>
            </thead>
            <tbody id="Jquery_Tbody">
                <%if (fileDatList.Rows.Count > 0) %>
                <%{ %>
                    <%foreach (System.Data.DataRow dat in fileDatList.Rows) %>
                    <%{ %>
                    <tr>
                        <td class="text_left">
                        <%if (isIco("/" + getManagePath + "/Images/flietypeico/fu_" + dat["filesuffix"].ToString().Replace(".", "") + ".gif"))%>
                        <%{ %>
                            <img class="small-images2 m_right4" src="Images/flietypeico/fu_<%=dat["filesuffix"].ToString().Replace(".", "") %>.gif" />
                        <%}else{ %>
                            <img class="small-images2 m_right4" src="/Images/Suffix/none.gif" />
                        <%} %>
                            <span title="<%=dat["filename"].ToString() %>" class="H B"><%=cutText(dat["filename"].ToString(), 46, "...")%></span>
                        </td>
                        <td><span class="X"><%=EoyooCMS.Common.Utils.FormatLength(long.Parse(dat["filesize"].ToString()))%></span>
                        </td>
                        <td>
                            <span class="G Size9"><%=getTime2(dat["addtime"].ToString()) %></span>
                        </td>
                        <td>
                            <span class="R Size9"><%=getTime2(dat["updatetime"].ToString()) %></span>
                        </td>
                        <td><span class="F"><%=dat["filesuffix"].ToString()%></span></td>
                        <td>
                            <a href="<%=getFormUrl %>?filepath=<%=EoyooCMS.Common.Utils.UrlEncode(dat["filepath"].ToString()+dat["filename"].ToString())%>&filename=<%=dat["filename"].ToString() %>" title="<%=dat["filename"].ToString() %>"  class="Q underline">[下载]</a><br />
                            <a title="删除：<%=dat["filename"].ToString() %>" href="<%=dat["filepath"].ToString()%><%=dat["filename"].ToString()%>" rel="delfile" class="R underline">[删除]</a>
                        </td>
                    </tr>
                    <%} %>
                <%}else{ %>
                <tr>
                    <td colspan="6" class="text_left"><span class="V">暂无数据</span></td>
                </tr>
                <%} %>
            </tbody>
        </table>
        <!-- end 通用table -->
        <div class="clear-8">
        </div>
        <p class="PageBox">
            <%=getPagesInfo%>
        </p>
        <!-- end 文章列表管理 -->
    </div>
</body>
</html>
