﻿$(function () {
    //绘出主菜单项
    function ShowTopMenu() {
        $.ajax({
            type: "get",
            url: "Config/Menus.xml",
            //data: null,
            datatype: "xml",
            beforeSend: function (xml) { },
            success: function (xml) {
                var tophtml = "";
                $(xml).find("Menus > Menu").each(function (i) {
                    if (isPowerMenusShow($(this).attr("id"))) {
                        tophtml += "<li><a rel=\"" + $(this).attr("id") + "\" href=\"" + $(this).attr("id") + "\" title=\"" + $(this).attr("intro") + "\">" + $(this).attr("name") + "</a></li>";
                    }
                });
                $("#divMenusTop").html(tophtml);
                indexLoad();
            },
            error: function (xml) { alert('Error loading XML document' + xml); }
        })
    }
    //首次加载
    function indexLoad() {
        var $obj = $("#divMenusTop li a[rel=0]");
        $obj.parent().removeClass("active");
        $obj.parent().addClass("active");
        $("#divMenusNavi span").remove();
        $("#divMenusNavi").append("<span class=\"arrow\">" + $obj.text() + "</span>");
        ShowDivMenusLeft($obj.attr("rel"));
    }

    ShowTopMenu();

    //判断是否权限程序
    function isPowerMenusShow(id) {
        var retValue = false;
        var nowUserPowerID = $("#nowUserPower").val();
        for (var i = 0; i < nowUserPowerID.split(",").length; i++) {
            if (id == nowUserPowerID.split(",")[i]) {
                retValue = true;
                break;
            }
        }

        //默认首页
        if (id == "0" || id == "01" || id == "001" || id == "002" || id == "003" || id == "004" || id == "005" || id == "006" || id == "007" || id == "008" || id == "009" || id == "010") {
            retValue = true;
        }

        //超级管理员
        if ($("#nowUserPower").val() == "*") retValue = true;

        return retValue;
    }


    //点击头部菜单
    $("#divMenusTop li a").live("click", function () {
        $("#divMenusTop li a").parent().removeClass("active");
        $(this).parent().addClass("active");
        $("#divMenusNavi span").remove();
        $("#divMenusNavi").append("<span class=\"arrow\">" + $(this).text() + "</span>");
        ShowDivMenusLeft($(this).attr("rel"));
        return false;
    })

    //绘出子菜单项
    function ShowDivMenusLeft(index) {
        $.ajax({
            type: "get",
            url: "Config/Menus.xml",
            //data: null,
            datatype: "xml",
            beforeSend: function (xml) { },
            success: function (xml) {
                var ShowHtml = "";
                $(xml).find("Menus > Menu > MenuItemTitle[mid=" + index + "]").each(function (i) {

                    if (isPowerMenusShow($(this).attr("sid"))) {
                        ShowHtml += "<div class=\"right_title\" title=\"" + $(this).attr("intro") + "\">" + $(this).attr("name") + "</div>";

                        //取子项
                        ShowHtml += "<ul class=\"nav_2\">";
                        $(xml).find("Menus > Menu > MenuItemTitle > MenuItem[tid=" + $(this).attr("sid") + "]").each(function (i) {
                            if (isPowerMenusShow($(this).attr("bid"))) {
                                ShowHtml += "<li><a target=\"iframeMenus\" title=\"" + $(this).attr("intro") + "\" href=\"" + $(this).attr("url") + "\">" + $(this).attr("name") + "</a></li>";
                            }
                        })
                        ShowHtml += "</ul>";
                    }
                });
                $("#divMenusLeft").html(ShowHtml);
                $("#divMenusLeft li a:first").trigger("click");
            },
            error: function (xml) { alert('Error loading XML document' + xml); }
        })
    }

    //点击左边菜单
    $("#divMenusLeft li a").live("click", function () {
        $("#divMenusLeft li a").removeClass("active");
        $(this).addClass("active");
        showMsg("页面载入中", true);
        //添加Tab卡//写Cookie
        if ($.cookie('MenusTabs') != null) {
            var isCookieNone = false;
            for (var i = 0; i < $.cookie('MenusTabs').split("|").length - 1; i++) {
                if ($.cookie('MenusTabs').split("|")[i].split(",")[1] == $(this).attr("href")) {
                    isCookieNone = true;
                    break;
                }
            }

            //如果不存在
            if (!isCookieNone) {
                //写入新的Cookie
                $.cookie('MenusTabs', "" + $.trim($(this).text()) + "," + $(this).attr("href") + "|" + $.cookie('MenusTabs'), 7);

                //判断Cookie超过限制
                if ($.cookie('MenusTabs').split("|").length - 1 > 5) {
                    //重新写Cookie
                    var newCookie = "";
                    for (var i = 0; i < 5; i++) {
                        newCookie += $.cookie('MenusTabs').split("|")[i] + "|";
                    }
                    $.cookie('MenusTabs', null);
                    $.cookie('MenusTabs', newCookie);
                }
            }
        } else {
            $.cookie('MenusTabs', null);
            $.cookie('MenusTabs', "" + $.trim($(this).text()) + "," + $(this).attr("href") + "|", 7);
        }
        ShowCookieTabs();
        $("#divMenusNavi span").eq(0).nextAll().remove();
        $("#iframeMenus").attr("src", "" + $(this).attr("href") + "");
        return false;
    })

    //监控Iframe加载完成事件
    $("#iframeMenus").load(function () {
        showMsg("", false);
    })

    //删除选项卡
    $("#divMenusTab li a[rel='close']").live("click", function () {
        var newCookie = "";
        for (var i = 0; i < $.cookie('MenusTabs').split("|").length - 1; i++) {
            if ($.cookie('MenusTabs').split("|")[i].split(",")[0] != $(this).prev().text()) {
                newCookie += $.cookie('MenusTabs').split("|")[i] + "|";
            }
        }
        $.cookie('MenusTabs', null);
        $.cookie('MenusTabs', newCookie);
        ShowCookieTabs();
        return false;
    })

    //绘出tab选项卡从(Cookie)
    function ShowCookieTabs() {
        $(divMenusTab).html("");
        if ($.cookie('MenusTabs') != null) {
            var showHtml = "";
            for (var i = 0; i < $.cookie('MenusTabs').split("|").length - 1; i++) {
                showHtml += "<li><a target=\"iframeMenus\" href=\"" + $.cookie('MenusTabs').split("|")[i].split(",")[1] + "\" alt=\"载入" + $.cookie('MenusTabs').split("|")[i].split(",")[0] + "\">" + $.cookie('MenusTabs').split("|")[i].split(",")[0] + "</a><a href=\"" + $.cookie('MenusTabs').split("|")[i].split(",")[0] + "\" class='close' rel=\"close\" alt=\"关闭\"></a></li>";

            }
            $("#divMenusTab").html(showHtml);
        }
    }

    //刷新Ifrme
    $("#refreshIframe").click(function () {
        showMsg("页面刷新中", true);
        iframeMenus.window.location.reload();
    })

    //点击管理员信息按钮
    $("#showUserInfo").click(function () {
        //隐藏按钮,显示菜单按钮
        $(this).hide();
        //隐藏右边菜单
        $("#MensLeftHideBox").hide();

        $("#showMenuLeft").show();
        $("#UserInfo").show();
    })

    //点击左边菜单按钮
    $("#showMenuLeft").click(function () {
        //隐藏按钮,显示菜单按钮
        $(this).hide();
        //隐藏右边菜单
        $("#UserInfo").hide();

        $("#showUserInfo").show();
        $("#MensLeftHideBox").show();
    })

    //注销系统
    $("#logoutBtn").click(function () {
        if (!confirm("确定要注销当前登录帐户么？")) {
            return false;
        }
    });
    $("#iframeMenus").width($("#divMenusMain").width());
    $("#iframeMenus").height($(window).height() - 130);

    $(window).resize(function () {
        $("#iframeMenus").height($(window).height() - 130);

    });
    //控制Iframe高度

})
