﻿$(function () {

    //初始化
    if ($("#naviModule_hide").val() != "") {
        setModule($("#naviModule_hide").val(), $("#module-" + $("#naviModule_hide").val() + "").text());
    }

    //选择模型赋值
    $(".select-module li a").click(function () {
        setModule($(this).attr("href"), $(this).text())
        return false;
    })

    function setModule(id, name) {
        $(".select-module li a").removeClass("active");
        $("#module-" + id + "").addClass("active");
        $("#navimodule_msg").attr("class", "point ico-via Q B");
        $("#navimodule_msg").text("使用:" + name + "");
        $("#naviModule_hide").val(id);
    }

    //检查栏目名是否存在
    function isNaviNameExist(name) {
        var retValue = false
        $.ajax({
            type: "POST",
            url: "Ajax/Navi.ashx",
            data: { 'com': 'isnaviexist', 'naviname': name },
            datatype: "json",
            async: false,
            beforeSend: function (data, textStatus) { },
            success: function (data, textStatus) {
                if (data == "0") {
                    retValue = true;
                } else {
                    retValue = false;
                }
            },
            error: function (e) { alert("连接失败,请向Eoyoo官方技术人员反馈!"); }
        })
        return retValue;
    }

    //控件离开自动赋值拼音
    $("#naviName_txt").blur(function () {
        if ($("#naviName_txt").val() != "") getPinyin($("#naviName_txt").val());
    });

    //获取中文翻译拼音
    function getPinyin(name) {
        $.ajax({
            type: "POST",
            url: "Ajax/Pinyin.ashx",
            data: { 'cntext': name },
            datatype: "json",
            beforeSend: function (data, textStatus) { },
            success: function (data, textStatus) {
                data = data.replace(" ", "");
                data = data.replace(" ", "");
                data = data.replace(" ", "");
                data = data.replace("　", "");
                if ($("#naviRewrite_txt").val() == "") $("#naviRewrite_txt").val(data);
            },
            error: function (e) { alert("连接失败,请向Eoyoo官方技术人员反馈!"); }
        })
    }

    //提交判断
    $("form").submit(function () {
        $("input[type='text'],input[type='password'],textarea").trigger("blur");
        $("select").trigger("change");

        ///新增方法填写在此///
        if ($("#naviName_txt").val() != $("#naviName_hide").val()) {
            if (!isNaviNameExist($("#naviName_txt").val())) {
                $("#naviName_txt").next("span").attr("class", "point ico-error R");
                $("#naviName_txt").next("span").html("栏目名已经存在,请更换个试试");
                return false;
            }
        }

        //判断隐藏模型控件
        if ($("#naviModule_hide").val() == "") {
            $("#navimodule_msg").attr("class", "point ico-error R");
            $("#navimodule_msg").html("请选择模型");
            return false;
        }
        /////

        if ($("form span").hasClass("ico-error")) {
            $("input:submit").attr("disabled", false);
            $("input:submit").next("span").attr("class", "point ico-error R");
            $("input:submit").next("span").text("请按照提示正确操作，检查各项填写");
            setInterval(delSubmitBtnMsg, 3000);
            return false;
        } else {
            $("input:submit").attr("disabled", true);
            $("input:submit").next("span").attr("class", "Q");
            $("input:submit").next("span").html("<img src=\"Images/Loading.gif\" align=\"middle\" /> 正在保存…");
        }
    });


})
