﻿$(function () {
    //上传图标
    $("#uploadImgBtn").uploadify({
        swf: 'Plugin/Uploadify/uploadify.swf',
        uploader: 'Ajax/SwfUpload.ashx',
        postData: { com: 'uploadproductbrandpic', pastpic: $("#brandPicPath_hide").val(), 'id': $("#brandId_hide").val()},
        transparent: true,
        debug: false,
        buttonText: '选择图片上传',
        width: '100',
        height: '28',
        auto: true,
        cancelImage: 'Plugin/Uploadify/uploadify-cancel.png',
        fileTypeDesc: '格式支持',
        fileTypeExts: '*.gif;*.jpg;*.jgeg;*.bmp;*.png;',
        fileSizeLimit: 10 * 1024, // 10MB
        multi: false, //是否允许多文件上传
        queueID: 'fileQueue',
        queueSizeLimit: 999,
        removeCompleted: false,
        onSelect: function (file) { },
        onUploadStart: function (file) {
            $("#uploadMsg").attr("class", "point ico-remind F B");
            $("#uploadMsg").html("正在上传…");
        },
        onUploadProgress: function (file, fileBytesLoaded, fileTotalBytes, queueBytesLoaded, uploadSize) {
            $("#uploadMsg").html("正在上传…<span class=\"Q\">完成" + Math.round(fileBytesLoaded / fileTotalBytes * 100) + "% <span class=\"R NoB\">(" + Capacity(queueBytesLoaded) + ")</span></span><span class=\"X NoB\"> | (大小:" + Capacity(uploadSize) + ")</span>");
        },
        onUploadSuccess: function (event, response, status) {
            $("#uploadMsg").attr("class", "point ico-via Q B");
            $("#uploadMsg").html("图片上传成功!");
            $("#brandPicPath_txt").attr("src", "../Upload/Ico/" + response + "");
            $("#brandPicPath_hide").val(response);
        }, //上传单个文件成功触发
        onSelectError: function (file, errorCode, errorMsg) {
            $("#uploadMsg").attr("class", "point ico-error R");
            if (errorCode == -110) {
                $("#uploadMsg").html("上传失败!文件超出上传限制大小");
            } else {
                $("#uploadMsg").html("上传失败!");
            }
        }, //选择文件有误触发事件
        onUploadComplete: function (file) { }, //批量上传成功触发事件
        onUploadError: function (file, errorCode, errorMsg) {
            alert(errorMsg);
        }
    });

    //提交判断
    $("form").submit(function () {
        $("input[type='text'],input[type='password'],textarea").trigger("blur");
        $("select").trigger("change");

        ///新增方法填写在此///

        /////

        if ($("form span").hasClass("ico-error")) {
            $("input:submit").attr("disabled", false);
            $("input:submit").next("span").attr("class", "point ico-error R");
            $("input:submit").next("span").text("请按照提示正确操作，检查各项填写");
            setInterval(delSubmitBtnMsg, 3000);
            return false;
        } else {
            $("input:submit").attr("disabled", true);
            $("input:submit").next("span").attr("class", "Q");
            $("input:submit").next("span").html("<img src=\"Images/Loading.gif\" align=\"middle\" /> 正在保存…");
        }
    });
})