﻿$(function () {
    //导入模板
    $("#uploadImgBtn").uploadify({
        swf: 'Plugin/Uploadify/uploadify.swf',
        uploader: 'Ajax/SwfUpload.ashx',
        postData: { com: 'uploadtemplate' },
        transparent: true,
        debug: false,
        buttonText: '导入打包模板',
        width: '100',
        height: '28',
        auto: true,
        cancelImage: 'Plugin/Uploadify/uploadify-cancel.png',
        fileTypeDesc: '格式支持',
        fileTypeExts: '*.template;',
        fileSizeLimit: 10000000 * 1024, // 10MB
        multi: false, //是否允许多文件上传
        queueID: 'fileQueue',
        queueSizeLimit: 999,
        removeCompleted: false,
        onSelect: function (file) { },
        onUploadStart: function (file) {

            $("#uploadMsg").attr("class", "point ico-remind F B");
            $("#uploadMsg").html("正在导入…");

            //更新参数
            $("#uploadImgBtn").uploadifySettings('postData', { com: 'uploadtemplate' });

        },
        onUploadProgress: function (file, fileBytesLoaded, fileTotalBytes, queueBytesLoaded, uploadSize) {
            $("#uploadMsg").html("正在导入… [" + file.name + "] <span class=\"Q\">已完成" + Math.round(fileBytesLoaded / fileTotalBytes * 100) + "% <span class=\"R NoB\">(" + Capacity(queueBytesLoaded) + ")</span></span>");

        },
        onUploadSuccess: function (file, response, status) {

            $("#uploadMsg").attr("class", "point ico-via Q B");
            $("#uploadMsg").html("模板导入成功!");

            if (response != "0") {
                alert("模板导入成功！");
                location.reload();
            }


        }, //上传单个文件成功触发
        onSelectError: function (file, errorCode, errorMsg) { }, //选择文件有误触发事件
        onUploadComplete: function (file) { }, //批量上传成功触发事件
        onUploadError: function (file, errorCode, errorMsg) {
            alert(errorMsg);
        }
    });

    //设为默认
    $("a[rel='default']").click(function () {
        var $delObject = $(this);
        if (confirm("确定要 [ " + $delObject.attr("title") + " ] 吗？")) {
            $.ajax({
                type: "POST",
                url: "Ajax/TemplateDispose.ashx",
                data: { 'com': 'setdefaulttemplate', 'templatename': $delObject.attr("href") },
                datatype: "json",
                beforeSend: function (data, textStatus) {
                    showMsg("正在[ " + $delObject.attr("title") + " ] ", true);
                },
                success: function (data, textStatus) {
                    if (data == "1") {
                        //显示所有
                        $(".helper a").show();
                        $(".helper div").hide();

                        //当前设置
                        $delObject.parent("div").find("a").hide();
                        $delObject.parent("div").find("div").show();
                    } else {
                        alert("设置失败!");
                    }
                    showMsg("", false);
                },
                error: function (e) { alert("连接失败,请向Eoyoo官方技术人员反馈!"); }
            })
        }
        return false;
    });

    //删除已安装模板
    $("a[rel='deltemplate']").click(function () {
        var $delObject = $(this);
        if (confirm("确定要删除 [ " + $delObject.attr("title") + " ] 吗？删除之后不可恢复，建议先导出打包文件备份至本机")) {
            $.ajax({
                type: "POST",
                url: "Ajax/TemplateDispose.ashx",
                data: { 'com': 'deltemplate', 'filepath': $delObject.attr("href"), 'title': $delObject.attr("title") },
                datatype: "json",
                beforeSend: function (data, textStatus) {
                    showMsg("[ " + $delObject.attr("title") + " ] 正在删除中 ", true);
                },
                success: function (data, textStatus) {
                    if (data == "1") {
                        $("#templateNumber").text(parseInt($("#templateNumber").text()) - 1);
                        $delObject.parent().parent("li").remove();
                    } else {
                        alert("删除失败!");
                    }
                    showMsg("", false);
                },
                error: function (e) { alert("连接失败,请向Eoyoo官方技术人员反馈!"); }
            })
        }
        return false;
    });
});