﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="EoyooCMS.ManageCode.Template_Manage" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>模板管理</title>
    <meta http-equiv="Pragma" content="no-cache" />
    <meta http-equiv="Cache-Control" content="no-cache" />
    <meta http-equiv="Expires" content="0" />
    <script type="text/javascript" src="Script/Jquery.js"></script>
    <script type="text/javascript" src="Script/Common.js"></script>
    <script type="text/javascript" src="Plugin/Uploadify/jquery.uploadify.min.js" ></script>
    <script src="Script/Template_Manage.js" type="text/javascript"></script>
    <link href="Style/Iframe.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <div class="wrapper-div">
        <!-- 文章列表管理 -->
        <!-- 标 -->
        <div class="title-tab">
            <div class="title">
                <span class="title-ico titico5 F B">模板管理 - <span class="V NoB">模板列表</span></span></div>
            <ul class="menu">
                <li><a class="active" href="<%=getFormUrl %>"><span>已安装模板</span></a></li>
                <li><a href="Template_Online.aspx"><span>在线模板下载</span></a></li>
            </ul>
        </div>
        <!-- end 标 -->
        <div class="clear-0"></div>

        <table>
            <tbody>
            	<tr>
                    <td width="30%">
                        <div class="PageBoxleft G file-ico">已安装模板： <span id="templateNumber" class="R B"><%=_pageCount%></span> 个</div>
                    </td>
                    <td class="text_left">
                        <div class="tbox_form">
                        <p>
                            <span class="uploadBtn"><input type="file" name="uploadImgBtn" id="uploadImgBtn" /></span>
                            <span id="uploadMsg" class="point ico-remind V">导入模板打包文件，文件后缀（*.template）</span>
                            <div class="clear-0"></div>
                        </p>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>

        <div class="box">
            <div class="box_cut">
                <!-- 通用img列表 -->
                <ul class="images-2" id="templatelist">
                        <%foreach (System.Data.DataRow dat in templateDatList.Rows)
                          { %>
                        <li title="<%=dat["directory"].ToString().ToLower() %>">
                            <div class="pic"><img src="<%=dat["pic"].ToString() %>" /></div>
                            <div class="info">
                                名称：<span title="<%=dat["name"] %>" class="D"><%=dat["name"]%></span><br />
                                作者：<span class="R"><%=dat["author"]%></span><br />
                                版本：<span class="V"><%=dat["edition"]%></span><br />
                                时间：<span class="R"><%=dat["updatetime"]%></span>
                            </div>
                            <div class="helper">
                                <%if (EoyooCMS.CoreCalls.GetSiteConfig.siteConfigTemplate.ToLower() == dat["directory"].ToString().ToLower()) %>
                                <%{ %>
                                <a style="display:none" href="<%=getFormUrl %>?directorypath=<%=EoyooCMS.Common.Utils.UrlEncode(dat["path"].ToString()) %>&directory=<%=dat["directory"].ToString() %>&filename=<%=dat["name"] %>" title="导出模板文件夹：<%=dat["directory"].ToString() %>" class="lan">打包导出</a>
                                <a style="display:none" class="huang" rel="deltemplate" title="模板：<%=dat["name"].ToString() %> ，文件夹：<%=dat["directory"].ToString() %>" href="<%=dat["path"].ToString() %>\">删除模板</a> 
                                <a style="display:none" class="lv" rel="default" title="设置<%=dat["name"].ToString() %>为默认模板" href="<%=dat["directory"].ToString() %>">设为默认</a>
                                <div class="text_centent B Q"><img align="middle" src="Images/Ico/add.gif" /> 默认模板</div>
                                <%}else{ %>
                                <a href="<%=getFormUrl %>?directorypath=<%=EoyooCMS.Common.Utils.UrlEncode(dat["path"].ToString()) %>&directory=<%=dat["directory"].ToString() %>&filename=<%=dat["name"] %>" title="导出模板文件夹：<%=dat["directory"].ToString() %>" class="lan">打包导出</a>
                                <a class="huang" rel="deltemplate" title="模板：<%=dat["name"].ToString() %> ，文件夹：<%=dat["directory"].ToString() %>" href="<%=dat["path"].ToString() %>\">删除模板</a> 
                                <a class="lv" rel="default" title="设置<%=dat["name"].ToString() %>为默认模板" href="<%=dat["directory"].ToString() %>">设为默认</a>
                                <div style="display:none" class="text_centent B Q"><img align="middle" src="Images/Ico/add.gif" /> 默认模板</div>
                                <%} %>
                                
                            </div>
                        </li>
                        <%} %>
                    
                </ul>
                <div class="clear-0"></div>
                <!-- end 通用img列表 -->
            </div>
        </div>
        <div class="clear-8"></div>

        <p class="PageBox">
            <%=getPagesInfo %>
        </p>
        <div class="clear-16"></div>
    </div>
</body>
</html>
