﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using System.Data.SqlClient;

using Czou.Common;
using Czou.DataModel;
using Czou.Business.Column;
using Czou.Business.AdminUser;

namespace Czou2012.UI.Manager.AdminUser
{
    public partial class authorizationUpdate : System.Web.UI.Page
    {
        protected int nColumnID = 0;                  //当前获得ColumnID
        protected string nColumnCode = "";            //当前获得ColumnCode

        protected void Page_Load(object sender, EventArgs e)
        {
            //超时判断
            CommonClass.SessionEntity.ValidSession();

            //获取前置信息
            nColumnID = ComStringHelper.QueryIntParse("ColumnID");
            nColumnCode = ComStringHelper.QueryStringParse("ColumnCode");

            if (nColumnCode != "")
            {
                nColumnID = BusColumnRule.GetColumnIDByColumnCode(nColumnCode);
            }

            //判断用户是否有此权限
            CommonClass.OperatorRight.IsCodeRight(nColumnID,"m");

            string strChkAll = "";
            bool isRight= true;
            //判断用户是否有修改权限
            if (isRight)
            {
                DmAdminUser nDmAdminUser = new DmAdminUser();
                nDmAdminUser.UserID =ComStringHelper.IntParse(Request.Form["UserID"]);
                nDmAdminUser.UserName = ComStringHelper.StringParse(Request.Form["UserName"]);
                nDmAdminUser.TrueName = ComStringHelper.StringParse(Request.Form["TrueName"]);
                nDmAdminUser.Password =ComStringHelper.StringParse(Request.Form["Password"]);
                nDmAdminUser.GroupID = ComStringHelper.StringParse(Request.Form["GroupID"]);
                nDmAdminUser.OrganName = ComStringHelper.StringParse(Request.Form["OrganName"]);
                nDmAdminUser.OrganID = ComStringHelper.IntParse(Request.Form["OrganID"]);
                nDmAdminUser.Remark = ComStringHelper.StringParse(Request.Form["Remark"]);
                nDmAdminUser.Sort = ComStringHelper.IntParse(Request.Form["Sort"]);
                strChkAll = ComStringHelper.StringParse(Request.Form["chkAll"]);

                string strTmp="";
                int myDsAuthorization =BusAuthorization.IfAuthorizationUserDouble(nDmAdminUser);
                if (!Object.Equals(myDsAuthorization, null) && !Object.Equals(myDsAuthorization, 0))
                {
                    strTmp = myDsAuthorization.ToString();
                }
                else
                {
                    strTmp = "";
                }

                if (strTmp != "")
                {
                    Response.Write("1");
                    Response.End();
                }


                try
                {
                    //修改用户（角色）信息
                    int intRole =BusRoleRule.RoleModify(nDmAdminUser);
                    if (intRole != 1)
                    {
                        Response.Write("2");
                        Response.End();
                    }
                    else
                    {
                        //清除原来设置的权限                  
                        int intAuthorization = BusAuthorization.AuthorizationDelete(nDmAdminUser);
                        if (intAuthorization != 1)
                        {
                            Response.Write("3");
                            Response.End();
                        }

                        //获取所有权限的值


                        strChkAll = strChkAll.TrimStart('*');
                        strChkAll = strChkAll.TrimEnd(',');

                        string Power = strChkAll;
                        string[] PowerItems = Power.Split('*');
                        int number = PowerItems.Length;
                        int[] columns = new int[number];
                        int[] read = new int[number];
                        int[] write = new int[number];
                        int[] modify = new int[number];
                        int[] delete = new int[number];
                        int[] check = new int[number];

                        string subPower = string.Empty;
                        string[] operArr;

                        if (nDmAdminUser.GroupID == "0")  //如果为独立权限，则记录，如果为多角色权限则不记录
                        {
                            //获取权限
                            for (int i = 0; i < number; i++)
                            {
                                subPower = PowerItems[i].TrimEnd(',');

                                operArr = subPower.Split(", ".ToCharArray());
                                columns[i] = int.Parse(operArr[0]);

                                read[i] = 0;
                                write[i] = 0;
                                modify[i] = 0;
                                delete[i] = 0;
                                check[i] = 0;

                                if (operArr.Length > 1)
                                {
                                    for (int j = 1; j < operArr.Length; j++)
                                    {
                                        string action = operArr[j].Substring(0, 1).ToLower();
                                        switch (action)
                                        {
                                            case "r":
                                                read[i] = 1;
                                                break;
                                            case "w":
                                                write[i] = 1;
                                                break;
                                            case "m":
                                                modify[i] = 1;
                                                break;
                                            case "d":
                                                delete[i] = 1;
                                                break;
                                            case "c":
                                                check[i] = 1;
                                                break;
                                        }

                                    }

                                    int intAuthorizationUpdate = BusAuthorization.AuthorizationUpdate(nDmAdminUser.UserID, columns[i], read[i], write[i], modify[i], delete[i], check[i]);
                                }

                            }
                            //for循环中成功返回
                        }

                     
                        Response.Write("1");
                        Response.End();                        
                    }
                }
                catch
                {
                  
                }

            }
            else
            {
                Response.Write("5");
                Response.End();

            }
            
        }
    }
}