﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using Czou.Common;
using Czou.DataModel;
using Czou.Business.Login;
using Czou.Business.Column;


namespace Czou2012.UI.Manager.AdminUser
{
    public partial class passwordModify : System.Web.UI.Page
    {
        protected int nColumnID = 0;                  //当前获得ColumnID
        protected string nColumnCode = "";            //当前获得ColumnCode

        protected void Page_Load(object sender, EventArgs e)
        {
            //超时判断
            CommonClass.SessionEntity.ValidSession();

            //获取前置信息
            nColumnID = ComStringHelper.QueryIntParse("ColumnID");
            nColumnCode = ComStringHelper.QueryStringParse("ColumnCode");

            if (nColumnCode != "")
            {
                nColumnID = BusColumnRule.GetColumnIDByColumnCode(nColumnCode);
            }
        
            if (!IsPostBack)
            {
                //判断访问类型
                string type;
                if (Request.QueryString["type"] != null)
                    type = ComStringHelper.GetSafeString(Request.QueryString["type"].ToString());
                else
                    type = "";
                if (type == "modify")
                {
                    //判断用户是否有此权限
                    CommonClass.OperatorRight.IsCodeRight(nColumnID,"m");
                    passwordModifyFunction();
                }
                else if (type == "find")
                { return; }
            }
        }

        private void passwordModifyFunction()
        {
            string oldPassword = ComStringHelper.GetSafeString(Request.QueryString["oldPassword"]);
            string newPassword = ComStringHelper.Encrypt(Request.QueryString["newPassword"]);
            string userName = ComStringHelper.StringParse(Session["UserNameSession"]);

            if (!string.IsNullOrEmpty(oldPassword) && !string.IsNullOrEmpty(newPassword) && (!ComStringHelper.CompareString(userName,"")))
            {

                DmAdminUser TbUser = new DmAdminUser();
                TbUser.UserName = userName;
                TbUser.Password = ComStringHelper.Encrypt(oldPassword);

                BusPasswordRule nBusPasswordRule = new BusPasswordRule();
                int passwordInfo = nBusPasswordRule.passwordUpdate(TbUser,newPassword);               

                //返回登录状态信息
                if (passwordInfo != 1)
                {
                    if (passwordInfo == 4)
                    {
                        Response.Write("4");
                        Response.End();
                    }
                    else
                    {
                        Response.Write("0");
                        Response.End();
                    }
                }
                else
                {                

                    Response.Write("1");
                    Response.End();
                }
            }
            else
            {
                Response.Write("9");
                Response.End();
            }
        }
    }
}