﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Configuration;

using Czou.Common;

namespace Czou2012.UI.Manager.CommonClass
{
    public  class OperatorRight
    {

        //权限检查


        #region 获取栏目权限:GetColumnRight(int)
        /// <summary>   
        ///  获取栏目权限
        /// </summary>   
        /// <param name="intID">权限类型</param>   
        /// <returns>void</returns>   
        public static void GetColumnRight(int ColumnID)
        {
            //栏目权限初始设置
            InitColumnRight();

            //检查栏目Read属性
            if (Convert.ToBoolean(HttpContext.Current.Session[ColumnID + "r"]))
            {
                HttpContext.Current.Session["nColumnRead"] = "1";
            }
            else
            {
                HttpContext.Current.Session["nColumnRead"] = "0";
            }

            //检查栏目Write属性
            if (Convert.ToBoolean(HttpContext.Current.Session[ColumnID + "w"]))
            {
                HttpContext.Current.Session["nColumnWrite"] = "1";
            }
            else
            {
                HttpContext.Current.Session["nColumnWrite"] = "0";
            }

            //检查栏目Modify属性
            if (Convert.ToBoolean(HttpContext.Current.Session[ColumnID + "m"]))
            {
                HttpContext.Current.Session["nColumnModify"] = "1";
            }
            else
            {
                HttpContext.Current.Session["nColumnModify"] = "0";
            }

            //检查栏目Delete属性
            if (Convert.ToBoolean(HttpContext.Current.Session[ColumnID + "d"]))
            {
                HttpContext.Current.Session["nColumnDelete"] = "1";
            }
            else
            {
                HttpContext.Current.Session["nColumnDelete"] = "0";
            }


            //检查栏目Check属性
            if (Convert.ToBoolean(HttpContext.Current.Session[ColumnID + "c"]))
            {
                HttpContext.Current.Session["nColumnCheck"] = "1";
            }
            else
            {
                HttpContext.Current.Session["nColumnCheck"] = "0";
            }

            if (HttpContext.Current.Session["UserNameSession"].ToString() == ConfigurationManager.AppSettings["AdminUser"])
            {
                HttpContext.Current.Session["nColumnRead"] = "1";
                HttpContext.Current.Session["nColumnWrite"] = "1";
                HttpContext.Current.Session["nColumnModify"] = "1";
                HttpContext.Current.Session["nColumnDelete"] = "1";
                HttpContext.Current.Session["nColumnCheck"] = "1";
            }
        }

        private static void InitColumnRight()
        {
            HttpContext.Current.Session["nColumnRead"] = "0";
            HttpContext.Current.Session["nColumnWrite"] = "0";
            HttpContext.Current.Session["nColumnModify"] = "0";
            HttpContext.Current.Session["nColumnDelete"] = "0";
            HttpContext.Current.Session["nColumnCheck"] = "0";
        }
        #endregion


        #region 检查子权限:IsRight(string)
        /// <summary>   
        ///  检查是否有权限
        /// </summary>   
        /// <param name="rightType">权限类型</param>   
        /// <returns>返回布尔型</returns>   
        public static bool IsRight(string rightType)
        {
            if (rightType == "r")
            {
                if (!object.Equals(HttpContext.Current.Session["nColumnRead"], null))
                {
                    if ((HttpContext.Current.Session["nColumnRead"]).ToString() == "1")
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
                else
                {
                    return false;
                }
            }

            else if (rightType == "w")
            {

                if (!Object.Equals(HttpContext.Current.Session["nColumnWrite"], null))
                {
                    if ((HttpContext.Current.Session["nColumnWrite"]).ToString() == "1")
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
                else
                {
                    return false;
                }
            }

            else if (rightType == "m")
            {

                if (!object.Equals(HttpContext.Current.Session["nColumnModify"], null))
                {
                    if ((HttpContext.Current.Session["nColumnModify"]).ToString() == "1")
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
                else
                {
                    return false;
                }
            }

            else if (rightType == "d")
            {

                if (!Object.Equals(HttpContext.Current.Session["nColumnDelete"], null))
                {
                    if ((HttpContext.Current.Session["nColumnDelete"]).ToString() == "1")
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
                else
                {
                    return false;
                }
            }

            else if (rightType == "c")
            {

                if (!Object.Equals(HttpContext.Current.Session["nColumnCheck"], null))
                {
                    if ((HttpContext.Current.Session["nColumnCheck"]).ToString() == "1")
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
                else
                {
                    return false;
                }
            }

            else
            {
                return false;
            }


        }
        #endregion

        #region 检查CodeBehind是否有权限:IsCodeRight(string rightType)
        /// <summary>   
        ///  检查CodeBehind是否有权限
        /// </summary>   
        /// <param name="rightType">权限类型</param>   
        /// <returns>void</returns>   
        public static void IsCodeRight(int ColumnID,string rightType)
        {
            if (ComStringHelper.IntParse(HttpContext.Current.Session["nColumnID"])!= 0)
            { 
            ColumnID=ComStringHelper.IntParse(HttpContext.Current.Session["nColumnID"]);
            }

            if (ColumnID == 0)
            { 
                InitColumnRight();
            }
            else
            {
                GetColumnRight(ColumnID);
            }

            if (rightType == "r")
            {
                if(ComStringHelper.IntParse(HttpContext.Current.Session["nColumnRead"])!=1)
                {                     
                    // HttpContext.Current.Response.Redirect("../");
                    ComJavascriptHelper.InsertJs("window.top.openReloginWindow();");
                    HttpContext.Current.Response.End();
                    return;
                }
               
            }

            else if (rightType == "w")
            {
                if (ComStringHelper.IntParse(HttpContext.Current.Session["nColumnWrite"]) != 1)
                {
                    //HttpContext.Current.Response.Redirect("../");
                    ComJavascriptHelper.InsertJs("window.top.openReloginWindow();");
                    HttpContext.Current.Response.End();
                    return;
                }
            }

            else if (rightType == "m")
            {

                if (ComStringHelper.IntParse(HttpContext.Current.Session["nColumnModify"]) != 1)
                {
                    //HttpContext.Current.Response.Redirect("../");
                    ComJavascriptHelper.InsertJs("window.top.openReloginWindow();");
                    HttpContext.Current.Response.End();
                    return;
                }

            }

            else if (rightType == "d")
            {
                if (ComStringHelper.IntParse(HttpContext.Current.Session["nColumnDelete"]) != 1)
                {
                    //HttpContext.Current.Response.Redirect("../");
                    ComJavascriptHelper.InsertJs("window.top.openReloginWindow();");
                    HttpContext.Current.Response.End();
                    return;
                }
            }

            else if (rightType == "c")
            {
                if (ComStringHelper.IntParse(HttpContext.Current.Session["nColumnCheck"]) != 1)
                {
                    //HttpContext.Current.Response.Redirect("../");
                    ComJavascriptHelper.InsertJs("window.top.openReloginWindow();");
                    HttpContext.Current.Response.End();
                    return;
                }             
            }

            else
            {
                //HttpContext.Current.Response.Redirect("../");
                ComJavascriptHelper.InsertJs("window.top.openReloginWindow();");
                HttpContext.Current.Response.End();
                return;
            }


        }
        #endregion

        #region 检查按钮权限:IsRightButton(string buttonEnable,string rightType)
        /// <summary>   
        ///  检查是否有权限
        /// </summary>   
        /// <param name="buttonEnable">按钮原类型</param>   
        /// <param name="rightType">权限类型</param>   
        /// <returns>返回字符串</returns>  
        public static string IsRightButton(string buttonEnable, string rightType)      
        {
            if (rightType == "r")
            {
                if (!object.Equals(HttpContext.Current.Session["nColumnRead"], null))
                {
                    if ((HttpContext.Current.Session["nColumnRead"]).ToString() == "1")
                    {
                        return buttonEnable;
                    }
                    else
                    {
                        return "disable";
                    }
                }
                else
                {
                    return "disable";
                }
            }

            else if (rightType == "w")
            {

                if (!Object.Equals(HttpContext.Current.Session["nColumnWrite"], null))
                {
                    if ((HttpContext.Current.Session["nColumnWrite"]).ToString() == "1")
                    {
                        return buttonEnable;
                    }
                    else
                    {
                        return "disable";
                    }
                }
                else
                {
                    return "disable";
                }
            }

            else if (rightType == "m")
            {

                if (!object.Equals(HttpContext.Current.Session["nColumnModify"], null))
                {
                    if ((HttpContext.Current.Session["nColumnModify"]).ToString() == "1")
                    {
                        return buttonEnable;
                    }
                    else
                    {
                        return "disable";
                    }
                }
                else
                {
                    return "disable";
                }
            }

            else if (rightType == "d")
            {

                if (!Object.Equals(HttpContext.Current.Session["nColumnDelete"], null))
                {
                    if ((HttpContext.Current.Session["nColumnDelete"]).ToString() == "1")
                    {
                        return buttonEnable;
                    }
                    else
                    {
                        return "disable";
                    }
                }
                else
                {
                    return "disable";
                }
            }

            else if (rightType == "c")
            {

                if (!Object.Equals(HttpContext.Current.Session["nColumnCheck"], null))
                {
                    if ((HttpContext.Current.Session["nColumnCheck"]).ToString() == "1")
                    {
                        return buttonEnable;
                    }
                    else
                    {
                        return "disable";
                    }
                }
                else
                {
                    return "disable";
                }
            }

            else
            {
                return "disable";
            }


        }
        #endregion

    }
}