﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="dictionaryList.aspx.cs" Inherits="Czou2012.UI.Manager.Dictionary.dictionaryList" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>字典管理</title>
    <link type="text/css" rel="stylesheet" href="../Styles/style.css" />
    <link type="text/css" rel="stylesheet" href="../Styles/pagination.css" />
    <link type="text/css" rel="stylesheet" href="../Styles/table.css" />
    <link rel="stylesheet" type="text/css" href="../Scripts/themes/default/easyui.css" />
    <link rel="stylesheet" type="text/css" href="../Scripts/themes/icon.css" />
    <link type="text/css" rel="stylesheet" href="../Scripts/Tips/tip-yellowsimple/tip-yellowsimple.css" />
    <script type="text/javascript" src="../Scripts/jquery.min.js"></script>
    <script type="text/javascript" src="../Scripts/jquery.form.js"></script>
    <script type="text/javascript" src="../Scripts/jquery.easyui.min.js"></script>
    <script type="text/javascript" src="../Scripts/jquery.validate.field.js"></script>
    <script type="text/javascript" src="../Scripts/Tips/jquery.poshytip.js"></script>
    <script type="text/javascript" src="../Scripts/jquery.fixedtableheader.min.js"></script>
    <script type="text/javascript"> 
    //add按钮新增字典事件------------------------------------------------------------/
    function btnAdd() {
        var nDicParentID = $.trim($('#txtDicParentID').val());
        var nDicLayer = $.trim($('#txtDicLayer').val());
        var nDicName = $.trim($('#txtDicName').val());
        var nDicCode = $.trim($('#txtDicCode').val());
        var nDefaultValue = $.trim($('#txtDefaultValue').val());

        var msg = $.ValidateField.CommonValidata(nDicName, "字典名称", 1);
   
        if (msg != $.ValidateField.OK) {
            msg = "(" + msg + ")";
            $('#lblInfo').html(msg);
            $('#txtDicName').focus();
            $('#txtDicName').select();
            return;
        } else { $('#lblInfo').html(""); }

        var msg = $.ValidateField.CommonValidata(nDicCode, "字典代码", 2);
        if (msg != $.ValidateField.OK) {
            msg = "(" + msg + ")";
            $('#lblInfo').html(msg);
            $('#txtDicCode').focus();
            $('#txtDicCode').select();
            return;
        } else { $('#lblInfo').html(""); }

        $.post(encodeURI('dictionaryList.aspx?DicParentID='+nDicParentID+'&DicLayer='+nDicLayer+'&DicName='+nDicName+'&DicCode='+nDicCode+'&DefaultValue='+nDefaultValue+'&type=add'), function (msg) {

            if (msg == '2') {
                $('#lblInfo').html("字典代码("+nDicCode+")不能重复!");
                $('#txtDicName').focus();
                $('#txtDicName').select();
                return;
            }

            if (msg == '1') {          
               $.messager.alert('系统提示', nDicName+'('+nDicCode+'),新增成功','question', function() {               
               window.location.href = "<%=nCurrentRequestUrl%>";                 
                });

               $('#txtDicName').focus();
               $('#txtDicName').select();
                return;
            }

            if (msg != '1' && msg != '2') {
                $('#lblInfo').html("录入失败!");
                return;
            }
        })
    }

  //modify批量修改事件--------------------------------------------------------------/
     function btnModify() {  
        var nDicParentID = $.trim($('#txtDicParentID').val());
        var nDicLayer = $.trim($('#txtDicLayer').val());
          //检查是否有checkbox被选中
          var ifSelected="0";
                $("tbody input:checkbox").each(function(i){
                     if($("tbody input:checkbox").eq(i).attr("checked")==true){
                     ifSelected="1";
                }
                });     

        if(ifSelected=="1"){
        var options = {
        //ajaxSubmit表单提交参数
            target:'#lblInfo',
            method:'post',
            url:'dictionaryList.aspx?type=modify&DicParentID='+nDicParentID+'&RowNumPerPage=<%=nRowNumPerPage%>',
            success: function(msg) {
            if(msg=="1")
            $("#lblInfo").text("修改成功！");
            else
             $("#lblInfo").text("修改有误，请检查！");
              return false;
            },
               error:function(){$.messager.alert("操作提示", "请求异常！","warning");}
             };
         $('#formmodify').ajaxSubmit(options);
         }
         else
         {
         $.messager.alert("操作提示", "您没有选择任何字典！","warning");
         }
     }

     //delete按钮事件--------------------------------------------------------------/
     function btnDelete() {  
            var ifSelected="0";
                $("tbody input:checkbox").each(function(i){
                     if($("tbody input:checkbox").eq(i).attr("checked")==true){
                     ifSelected="1";
                }
                });     

        if(ifSelected=="1"){
        var options = {
            target:'#lblInfo',
            method:'post',
            url:'dictionaryList.aspx?type=delete&RowNumPerPage=<%=nRowNumPerPage%>',
            success: function(msg) {
            if(msg=="1")
            {
            $("#lblInfo").text("删除成功！");
               $.messager.alert('系统提示', '删除成功','question', function() {               
               window.location.href = "<%=nCurrentRequestUrl%>";                 
               });
            }
            else
             $("#lblInfo").text("删除有误，请检查！");
              return false;
            },
               error:function(){$.messager.alert("操作提示", "请求异常！","warning");}
            
            };
         $('#formmodify').ajaxSubmit(options);
         }
         else{
         $.messager.alert("操作提示", "您没有选择任何字典！","warning");
         }
    
     }

    //back返回上一层字典--------------------------------------------------------------/
    function btnBack() {
        <% if ((nDicLayer-1)>=0){%>
        window.location.href="dictionaryList.aspx?DicLayer=<%=nDicLayer-1%>&DicParentID=<%=nDicGrandParentID%>&RowNumPerPage=<%=nRowNumPerPage%>&Class=up";
        <%}
        else
        {%>
         window.location.href="dictionaryList.aspx?DicLayer=0&DicParentID=0&RowNumPerPage=<%=nRowNumPerPage%>&Class=up";
        <%}%>
    }

    //reset复原按钮---------------------------------------------------------------------/
    function btnReset() {
        $("form").each( function(){
        this.reset();//有效，其他无效
        });
        checkboxClick();
    }

    //checkbox全选事件--------------------------------------------------------------/
    function selectAll(o){
	    if(o.checked){
		    $("input:checkbox").attr("checked",true);
        
	    }else{
		    $("input:checkbox").attr("checked",false);
	    }
        checkboxClick();
    }

    //checkbox点击事件--------------------------------------------------------------/
    function checkboxClick(){

         $("tbody input:checkbox[id^='check']").each(function(i){

             if($("tbody input:checkbox[id^='check']").eq(i).attr("checked")==true){
                    $("tbody input:checkbox[id^='check']").eq(i).parent().parent().addClass("trSelected");
                }else{
                    $("tbody input:checkbox[id^='check']").eq(i).parent().parent().removeClass("trSelected");
                }
         });     
  
    } 

    //文本框改变事件--------------------------------------------------------------/
    function inputChange(obj,i)
    {
        var cc="#check"+i;
        $(obj).addClass("inputChange");
        $(cc).attr('checked',true);
        checkboxClick()
    }

    //检查是否输入数字-----------------------------------------------------------/
    function inputNumber(obj)
    {
        var nNumTemp=obj.value;
        var msg = $.ValidateField.ValidateNumber(nNumTemp);    
          if (msg != 'ok') {
          alert(msg);
          obj.value="0";
          }
    }

    //页面属性 Start--------------------------------------------------------------/
    $(document).ready(function () {  
            $("#tableContent table>tbody>tr input:text").addClass("inputText");
            $("#tableContent table>tbody>tr select").addClass("inputText");
            
            //设置不要在公共场所使用记住用户名Tips
            $('#txtDicCode').poshytip({
                className: 'tip-yellowsimple',
                showOn: 'focus',
                alignTo: 'target',
                alignX: 'center',
                alignY: 'top',
                offsetX: 0,
                offsetY: 0
            });


            //linkbutton失效实例,增加权限控制
            $('#btnAdd').linkbutton('<%=Czou2012.UI.Manager.CommonClass.OperatorRight.IsRightButton("enable","w")%>');
            $('#btnModify').linkbutton('<%=Czou2012.UI.Manager.CommonClass.OperatorRight.IsRightButton("enable","m")%>');
            $('#btnDelete').linkbutton('<%=Czou2012.UI.Manager.CommonClass.OperatorRight.IsRightButton("enable","d")%>');
            <%if (nDicLayer==0) { %>$('#btnBack').linkbutton("disable");<%} %>
            $("#infoTable").fixedtableheader({ headerrowsize: 1 });
    })

    </script>
</head>
<body>
    <div class="DivContainer">
        <div class="tableHeader">
            <span class="navImage">&nbsp;</span><span class="lblNavigator">系统管理 > 基础字典</span>
            <asp:Label ID="lblNavigator"  class="lblNavigator" runat="server"></asp:Label>
        </div>
        <form method="post" id="formmodify">
        <input type="hidden" id="txtDicLayer" runat="server" /><input type="hidden" id="txtDicParentID" runat="server" />
        <div id="tableContent">
            <table border="0" class="commonTable" id="infoTable">
                <thead>
                    <tr>
                        <th style="width: 15px; text-align: center;">
                            <input type="checkbox" id="allCheck" style="border: 0px;" onclick="selectAll(this)" />
                        </th>
                        <th style="width: 40px; text-align: center;">
                            ID号
                        </th>
                        <th style="min-width: 100px;">
                            字典名称
                        </th>
                        <th style="min-width: 60px;">
                            字典代码
                        </th>
                        <th style="width: 80px;">
                            分类
                        </th>
                        <th style="width: 40px;">
                            父ID
                        </th>
                        <th style="min-width: 60px;">
                            参数值
                        </th>
                        <th style="width: 180px;">
                            是否默认</th>
                        <th style="width: 40px;">
                            组别
                        </th>
                        <th style="width: 40px;">
                            顺序
                        </th>
                        <th style="width: 80px;text-align:center;">
                            管理选项
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <asp:Label ID="tbodyDiv" runat="server"></asp:Label>
                    <asp:Repeater runat="server" ID="DicRepeater" OnItemDataBound="DicRepeater_ItemDataBound">
                        <ItemTemplate>
                            <tr>
                                <td style="text-align: center;" id="td<%# Container.ItemIndex %>" title="系统字典，不可删除">
                                    <input type="checkbox" value="1" id="<%#"check"+Container.ItemIndex %>" name="<%#"check"+Container.ItemIndex %>"
                                        onclick="checkboxClick();">
                                </td>
                                <td><%# Czou.Common.ComStringHelper.IntParse(Eval("SysSign")) == 1 ? "<span class='fontSign'>" + Eval("DicID") + "<span>" : Eval("DicID")%>
                               <input type="hidden" value="<%# Eval("DicID")%>" name="<%#"DicID"+Container.ItemIndex %>">
                                </td>
                                <td>
                                    <input value="<%# Eval("DicName")%>" name="<%#"DicName"+Container.ItemIndex %>"
                                        onchange="inputChange(this,<%#Container.ItemIndex%>);" />
                                </td>
                                <td>
                                    <input value="<%# Eval("DicCode")%>" name="<%#"DicCode"+Container.ItemIndex %>"
                                        onchange="inputChange(this,<%#Container.ItemIndex%>);" />
                                </td>
                                <td>
                                    <select name="<%#"DicType"+Container.ItemIndex %>" id="<%#"DicType"+Container.ItemIndex %>"
                                        style="margin: 0px;" onchange="inputChange(this,<%#Container.ItemIndex%>);">
                                        <option value='1' <%# (DataBinder.Eval(Container.DataItem, "DicType").ToString() == "1") ? "selected" : ""  %>
                                            style="background: white; height: 25px; line-height: 35px">用户类</option>
                                        <option value='2' <%# (DataBinder.Eval(Container.DataItem, "DicType").ToString() == "2") ? "selected" : ""  %>
                                            style="background: yellow; height: 25px; line-height: 35px">企业类</option>
                                        <option value='0' <%# (DataBinder.Eval(Container.DataItem, "DicType").ToString() == "0") ? "selected" : ""  %>
                                            style="background: green; height: 25px;">系统类</option>
                                        <option value='9' <%# (DataBinder.Eval(Container.DataItem, "DicType").ToString() == "9") ? "selected" : ""  %>
                                            style="background: white; height: 25px;">其它类</option>
                                    </select>
                                </td>
                                <td>
                                    <input value="<%# Eval("DicParentID")%>" name="<%#"DicParentID"+Container.ItemIndex %>"
                                        onchange="inputChange(this,<%#Container.ItemIndex%>);" onblur="inputNumber(this);" />
                                </td>
                                <td>
                                    <input value="<%# Eval("DicParameter")%>" name="<%#"DicParameter"+Container.ItemIndex %>" onchange="inputChange(this,<%#Container.ItemIndex%>);" />
                                </td>
                                <td>
                                    <input value="<%# Eval("DefaultValue")%>" name="<%#"DefaultValue"+Container.ItemIndex %>"
                                        onchange="inputChange(this,<%#Container.ItemIndex%>);" />
                                </td>
                                <td>
                                    <input value="<%# Eval("DicGroup")%>" name="<%#"DicGroup"+Container.ItemIndex %>"
                                        onchange="inputChange(this,<%#Container.ItemIndex%>);" />
                                </td>
                                <td>
                                    <input value="<%# Eval("DicSort")%>" name="<%#"DicSort"+Container.ItemIndex %>"
                                        onchange="inputChange(this,<%#Container.ItemIndex%>);" onblur="inputNumber(this);" />
                                </td>
                                <td style="text-align: center">
                                    <a href="dictionaryList.aspx?DicLayer=<%=nDicLayer+1%>&DicParentID=<%# Eval("DicID")%>&DicGrandParentID=<%# Eval("DicParentID")%>&RowNumPerPage=<%=nRowNumPerPage%>&Class=down">
                                        管理选项</a>
                                </td>
                            </tr>
                            <%
                                string nSubDicNum = "0";
                                if (((System.Data.DataTable)DicRepeater.DataSource) == null)
                                { nSubDicNum = "0"; }
                                else
                                {
                                  nSubDicNum = ((System.Data.DataTable)DicRepeater.DataSource).Rows[nIndex++]["SubDicNum"].ToString();
                                }
                                if (!CompareString(nSubDicNum, "0"))
                                { 
                            %>
                            <tr>
                                <td colspan="11" class="noWrap">
                                    <asp:Repeater ID="SubRepeater" runat="server">
                                        <ItemTemplate>
                                            ◇<a href="dictionaryList.aspx?DicLayer=<%=nDicLayer+2%>&DicParentID=<%# Eval("DicID")%>&DicGrandParentID=<%# Eval("DicParentID")%>&RowNumPerPage=<%=nRowNumPerPage%>&Class=down">
                                                <%# Eval("DicName") %></a>&nbsp;&nbsp;
                                        </ItemTemplate>
                                    </asp:Repeater>
                                </td>
                            </tr>
                            <%} %>
                        </ItemTemplate>
                    </asp:Repeater>
                </tbody>
            </table>
        </div>
        <div class="paginationDiv">
             <table style="border:0px;height:28px;" cellpadding="0" cellspacing="0"><tr><td width="460px">
            <div style="float: left;">
                <asp:Label ID="LblPageNavigator" runat="server"></asp:Label>
                </div>
                </td><td>&nbsp;</td><td style="width:250px;">
            <div style="float:left; vertical-align: middle;width:250px; padding-left:20px;margin-top:-2px;">
                <a id="btnModify" class="easyui-linkbutton" icon="icon-ok" href="javascript:btnModify();"
                    tabindex="5">修改确认</a> <a id="btnDelete" class="easyui-linkbutton" icon="icon-cancel"
                        href="#" tabindex="5" onclick='{ $.messager.confirm("操作提示", "删除的字典将不能恢复，并且此字典的所有子字典也将删除!您确定要继续吗？\n", function (data) {if (data) {btnDelete();}else {return false;}});}'>选择删除</a> <a id="btnBack" class="easyui-linkbutton"
                            icon="icon-back" href="javascript:btnBack()" tabindex="5">返回上层</a>
            </div>
            </td><td>&nbsp;</td></tr>
            </table>
        </div>
        <div style="clear: both; float: left; height: 25px; margin-top: 2px; padding-left: 2px;
            vertical-align: middle; text-align: left; line-height: 25px;">
            <span id="lblInfo" style="line-height: 25px; color: #ff0000;" class="lblInfo">说明:ID号橙色表示系统字典，不可删除</span>
        </div>
        <div class="borderDiv28">
        <table><tr>
           <td width='120px'>
            <div style="float: left; text-align: center; line-height: 28px; width: 120px; background: #eeeeee;
                border-right: 1px solid #cccccc;">
                新增当前字典</div>
               </td><td>&nbsp;&nbsp;        
                    <span style="margin-right: 4px; line-height: 26px;">字典名称:</span> 
                </td><td>
                        <input type="text"  id="txtDicName" class="inputAdd" style="width: 120px;" runat="server" />
                 </td><td>&nbsp;&nbsp;
                      <span style="margin-right: 4px; line-height: 26px;">字典代码:</span>
                </td><td>
                      <input type="text" id="txtDicCode" class="inputAdd" style="width: 60px;" runat="server" title="请按默认格式设置!"/>
                </td><td>&nbsp;&nbsp;
                      <span style="margin-right: 4px; line-height: 26px;">默认值:</span>
                 </td><td>
                      <input type="text" id="txtDefaultValue" class="inputAdd" style="width: 240px;" runat="server" />          
            </td>
          </tr>
          </table>
        </div>
        <div class="borderDiv28 divCenter divMiddle">
            <a id="btnAdd" class="easyui-linkbutton" icon="icon-add" href="javascript:btnAdd();"
                tabindex="5" style="margin-right: 50px;">增加</a> <a id="btnReset" class="easyui-linkbutton"
                    icon="icon-undo" href="javascript:btnReset();" tabindex="5">复原</a>
        </div>
        </form>
    </div>
</body>
</html>
