﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using Czou.Common;
using Czou.DataModel;
using Czou.Business.Column;
using Czou.Business.Download;

namespace Czou2012.UI.Manager.Download
{
    public partial class downInput : System.Web.UI.Page
    {
        protected int nColumnID = 0;                  //当前获得ColumnID
        protected string nColumnCode = "";            //当前获得ColumnCode
        protected int nCurrentPage = 1;               //当前页数
        protected int nRowNumPerPage = 0;             //每页显示行数
        protected int nInitRowNumPerPage = 15;        //初始每页显示行数
        protected string nCurrentUrl = "";            //当前页面的URL
        protected int nIndex = 0;                     //当前ItemIndex
        protected string nCurrentRequestUrl = "#";    //通过Request获取到的当前页面Url值

        protected void Page_Load(object sender, EventArgs e)
        {
            //超时判断
            CommonClass.SessionEntity.ValidSession();

            //获取前置信息
            nColumnID = ComStringHelper.QueryIntParse("ColumnID");
            nColumnCode = ComStringHelper.QueryStringParse("ColumnCode");

            //生成导航信息
            string nColumnCodeLayerName = "";           //由ColumnCode转换成LayerName
            nColumnCodeLayerName = BusColumnRule.GetParentColumnNameListByCode(nColumnCode);
            lblNavigator.Text = nColumnCodeLayerName;

            if (!IsPostBack)
            {
                txtInfoRndCode.Value =ComStringHelper.RndCharsCode(8);
                txtPublishTime.Value = ComStringHelper.StringParse(System.DateTime.Now.ToString("yyyy/MM/dd hh:mm:ss"));
                txtColumnCode.Value = nColumnCode;
            }

            //判断访问类型             

            string nType;
            if (Request.QueryString["type"] == null)
            { nType = ""; }
            else
            { nType = ComStringHelper.GetSafeString(Request.QueryString["type"].ToString()); }

            if (nType == "add")
            {
                //判断用户是否有此权限
                CommonClass.OperatorRight.IsCodeRight(nColumnID, "r");
                DownAdd();
            }

        }

        /// <summary>
        /// 新增信息
        /// </summary>
        /// <returns>void</returns>
        private void DownAdd()
        {
            int nReturnInt = 0;
            DmDownload model = new DmDownload();
            model.InfoID = ComStringHelper.IntParse(Request["txtInfoID"]);
            model.InfoRndCode = ComStringHelper.StringParse(Request["txtInfoRndCode"]);
            model.ColumnCode = ComStringHelper.StringParse(Request["txtColumnCode"]);
            model.Title = ComStringHelper.StringParse(Request["txtTitle"]);
            model.SubTitle = ComStringHelper.StringParse(Request["txtSubTitle"]);
            model.TitleColor = ComStringHelper.StringParse(Request["txtTitleColor"]);
            model.Keywords = ComStringHelper.StringParse(Request["txtKeywords"]);
            model.Summary = ComStringHelper.StringParse(Request["txtSummary"]);
            model.Source = ComStringHelper.StringParse(Request["txtSource"]);
            model.Author = ComStringHelper.StringParse(Request["txtAuthor"]);
            model.PictureName = ComStringHelper.StringParse(Request["txtPictureName"]);
            model.PictureSavePath = ComStringHelper.StringParse(Request["txtPictureSavePath"]);
            model.IsPictureNews = ComStringHelper.IntParse(Request["txtIsPictureNews"]);
            model.IsComment = ComStringHelper.IntParse(Request["txtIsComment"]);
            model.CharacterCode = ComStringHelper.StringParse(Request["txtCharacterCode"]);
            model.Commend = ComStringHelper.IntParse(Request["txtCommend"]);
            model.Language = ComStringHelper.StringParse(Request["txtLanguage"]);
            model.InfoSort = ComStringHelper.IntParse(Request["txtInfoSort"]);
            model.Clicks = ComStringHelper.IntParse(Request["txtClicks"]);
            model.RelationID = ComStringHelper.StringParse(Request["txtRelationID"]);
            model.RelationStr = ComStringHelper.StringParse(Request["txtRelationStr"]);
            model.InputBy = ComStringHelper.StringParse(Session["UserNameSession"]);
            //model.AddTime = ComStringHelper.StringParse(Request["txtAddTime"]);
            model.ModifyBy = ComStringHelper.StringParse(Request["txtModifyBy"]);
            model.CheckBy = ComStringHelper.StringParse(Request["txtCheckBy"]);
            //model.PublishTime = ComStringHelper.StringParse(Request["txtPublishTime"]);
            model.HtmlUrl = ComStringHelper.StringParse(Request["txtHtmlUrl"]);
            model.IP = ComStringHelper.StringParse(Request["txtIP"]);
            model.State = ComStringHelper.IntParse(Request["txtState"]);
            model.SysSign = ComStringHelper.IntParse(Request["txtSysSign"]);
            try
            {
                nReturnInt = BusDownRule.DownAdd(model);
            }
            catch
            {
                nReturnInt = 0;
            }
            Response.Write(nReturnInt.ToString());
            Response.End();

        }


    }
}