﻿/*
Author by Czou.com
Data:2012-11
While retaining the copyright case can be modified
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;

using Czou.Common;
using Czou.DataModel;
using Czou.Business.Column;
using Czou.Business.Download;

namespace Czou2012.UI.Manager.Download
{
    public partial class downItemShow : System.Web.UI.Page
    {
        protected int nColumnID = 0;                  //当前获得ColumnID
        protected string nColumnCode = "";            //当前获得ColumnCode
        protected string nColumnName = "";            //当前获得ColumnName
        protected int nCurrentPage = 1;               //当前页数
        protected int nRowNumPerPage = 0;             //每页显示行数
        protected int nInitRowNumPerPage = 15;        //初始每页显示行数
        protected string nCurrentUrl = "";            //当前页面的URL
        protected int nIndex = 0;                     //当前ItemIndex
        protected string nCurrentRequestUrl = "#";    //通过Request获取到的当前页面Url值

        protected void Page_Load(object sender, EventArgs e)
        {
            //超时判断
            CommonClass.SessionEntity.ValidSession();

            //获取前置信息
            nColumnID = ComStringHelper.QueryIntParse("ColumnID");
            nColumnCode = ComStringHelper.QueryStringParse("ColumnCode");

            int nInfoID= ComStringHelper.QueryIntParse("InfoID");

            if (nColumnCode != "")
            {
                nColumnID = BusColumnRule.GetColumnIDByColumnCode(nColumnCode);
            }
            //生成导航信息
            string nColumnCodeLayerName = "";           //由ColumnCode转换成LayerName
            nColumnCodeLayerName = BusColumnRule.GetParentColumnNameListByCode(nColumnCode);
            nColumnName = BusColumnRule.GetColumnFieldByOtherField("ColumnName", "ColumnCode", nColumnCode);
            lblNavigator.Text = nColumnCodeLayerName;

            DmDownload model = new DmDownload();
            model.InfoID = nInfoID;

            model =BusDownRule.GetDownItem(model);
            if (model.PictureSavePath.ToString().Length > 4)
            {
                lblTitle.Text = model.Title.ToString() + "&nbsp;&nbsp;<span class='iconDown icon-image' style='width:16px;height:16px' inner=\"" + model.PictureSavePath + "\">&nbsp;</span>";
                lblBottom.Text = "<a id=\"btnDown\" class=\"easyui-linkbutton\"   icon=\"icon-undo\" href=\"" + model.PictureSavePath.ToString() + "\" >下载</a>";
            }
            else
            { 
            lblTitle.Text = model.Title.ToString();
            lblBottom.Text = "无下载文件!";
            }
            lblProperty.Text = "来源：" + model.Source.ToString() + "&nbsp;&nbsp;&nbsp;&nbsp;录入人：" + model.InputBy.ToString() + "&nbsp;&nbsp;&nbsp;&nbsp;修改人：" + model.ModifyBy.ToString() + "&nbsp;&nbsp;&nbsp;&nbsp;录入时间：" + model.AddTime.ToString() + "&nbsp;&nbsp;&nbsp;&nbsp;发布时间：" + model.PublishTime.ToString();
            lblContent.Text = model.Summary.ToString();
            
        }
    }
}