﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="downList.aspx.cs" Inherits="Czou2012.UI.Manager.Download.downList" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>下载信息列表</title>
    <link type="text/css" rel="stylesheet" href="../Styles/style.css" />
    <link type="text/css" rel="stylesheet" href="../Styles/pagination.css" />
    <link type="text/css" rel="stylesheet" href="../Styles/table.css" />
    <link rel="stylesheet" type="text/css" href="../Scripts/themes/default/easyui.css" />
    <link rel="stylesheet" type="text/css" href="../Scripts/themes/icon.css" />
    <script type="text/javascript" src="../Scripts/jquery.min.js"></script>
    <script type="text/javascript" src="../Scripts/jquery.form.js"></script>
    <script type="text/javascript" src="../Scripts/jquery.easyui.min.js"></script>
    <script type="text/javascript" src="../Scripts/jquery.validate.field.js"></script>
    <script type="text/javascript" src="../Scripts/jquery.fixedtableheader.min.js"></script>
    <script type="text/javascript">

          //Query查询事件--------------------------------------------------------------/
          function btnQuery() {
              document.forms[0].action = "downList.aspx?type=query&ColumnCode=<%=nColumnCode%>&RowNumPerPage=<%=nRowNumPerPage%>";
              document.forms[0].submit();
          }

          //批量Modify事件--------------------------------------------------------------/
          function btnModify() {
              var ifSelected = "0";
              $("tbody input:checkbox[id^='check']").each(function (i) {
                  if ($("tbody input:checkbox[id^='check']").eq(i).attr("checked") == true) {                
                      ifSelected = "1";
                  }
              });

              if (ifSelected == "1") {
                  var options = {
                      target: '#lblDown',
                      method: 'post',
                      url: 'downList.aspx?type=modify&RowNumPerPage=<%=nRowNumPerPage%>',
                      success: function (msg) {
                          if (msg == "1") {
                              $("#lblDown").text("修改成功！");

                              $.messager.alert('系统提示', '修改成功', 'question', function () {
                                  window.location.href = "<%=nCurrentRequestUrl%>";
                              });

                          }
                          else
                              $("#lblDown").text("修改有误，请检查！");
                          return false;
                      },
                      error: function () { $.messager.alert("操作提示", "请求异常！", "warning"); }
                  };
                  $('#formmodify').ajaxSubmit(options);
              }
              else {
                  $.messager.alert("操作提示", "您没有选择下载信息！", "warning");
              }
          }

          //单条下载信息Modify事件--------------------------------------------------------------/
          function btnSingleModify() {
              var ifSelected = "0";
              var numSelected = 0;
              var valSelected = "0";
              $("tbody input:checkbox[id^='check']").each(function (i) {
                  if ($("tbody input:checkbox[id^='check']").eq(i).attr("checked") == true) {
                      valSelected=$.trim($("#InfoID" + i).val());
                      ifSelected = "1";
                      numSelected = numSelected + 1;
                  }
              });

              if (ifSelected == "1" && numSelected == 1) {
                  window.parent.SubIframeAddTab('修改下载信息', 'Download/downModify.aspx?ColumnCode=<%=nColumnCode%>&InfoID=' + valSelected, 'icon icon-ok', true);
                  }
              else if (ifSelected=="0") {
                  $.messager.alert("操作提示", "您没有选择下载信息！", "warning");
              }
              else {
                  $.messager.alert("操作提示", "您选择了多条下载信息！", "warning");
              }
          }

          //delete按钮事件--------------------------------------------------------------/
          function btnDelete() {
              var ifSelected = "0";
              $("tbody input:checkbox[id^='check']").each(function (i) {
                  if ($("tbody input:checkbox[id^='check']").eq(i).attr("checked") == true) {
                      ifSelected = "1";
                  }
              });

              if (ifSelected == "1") {
                  var options = {
                      //参数说明：
                      //1.用此方式提交时，form不能为runat="server"；
                      //2.必须在表单form中加method="post"，此参数中加的method:'post'不能提交含大量表单域的form；
                      //3.必须在cs文件中用Request["名称"]获取表单域的值，否则RequestString获取字符串长度有限制.
                      target: '#lblDown',
                      method: 'post',
                      url: 'downList.aspx?type=delete&RowNumPerPage=<%=nRowNumPerPage%>',
                      success: function (msg) {
                          if (msg == "1") {
                              $("#lblDown").text("删除成功！");
                              $.messager.alert('系统提示', '删除成功', 'question', function () {
                                  window.location.href = "<%=nCurrentRequestUrl%>";
                              });
                          }
                          else
                              $("#lblDown").text("删除有误，请检查！");
                          return false;
                      },
                      error: function () { $.messager.alert("操作提示", "请求异常！", "warning"); }
                  };
                  $('#formmodify').ajaxSubmit(options);
              }
              else {
                  $.messager.alert("操作提示", "您没有选择下载信息！", "warning");
              }

          }

        

          //reset复原按钮---------------------------------------------------------------------/
          function btnReset() {
              $("form").each(function () {
                  this.reset(); //有效，其他无效
              });

              $('#btnForbid').linkbutton('disable');    // disable the button  
              $('#btnDelete').linkbutton('disable');    // disable the button  
              $('#btnAdd').linkbutton('<%=Czou2012.UI.Manager.CommonClass.OperatorRight.IsRightButton("enable","w")%>');    // enable the button  
              window.location.href = "<%=nCurrentRequestUrl%>";
              checkboxClick();

          }

          //checkbox全选事件--------------------------------------------------------------/
          function selectAll(o) {
              if (o.checked) {
                  $("input:checkbox[id^='check']").attr("checked", true);

              } else {
                  $("input:checkbox[id^='check']").attr("checked", false);
              }
              checkboxClick();
          }

          //checkbox点击事件--------------------------------------------------------------/
          function checkboxClick() {
              $("tbody input:checkbox").each(function (i) {
                  if ($("tbody input:checkbox[id^='check']").eq(i).attr("checked") == true) {
                      $("tbody input:checkbox[id^='check']").eq(i).parent().parent().addClass("trSelected");
                  } else {
                      $("tbody input:checkbox[id^='check']").eq(i).parent().parent().removeClass("trSelected");
                  }
              });

          }

          //文本框改变事件--------------------------------------------------------------/
          function inputChange(obj, i) {
              var cc = "#check" + i;
              $(obj).addClass("inputChange");
              $(cc).attr('checked', true);
              checkboxClick()
          }

          //检查是否输入数字-----------------------------------------------------------/
          function inputNumber(obj) {
              var nNumTemp = obj.value;
              var msg = $.ValidateField.ValidateNumber(nNumTemp);
              if (msg != 'ok') {
                  obj.value = "0";
              }
          }

          //全选发布-----------------------------------------------------------/
          function changeAllState(obj) {
              $("[id^='State']").each(function (i) {
              $("#State"+i+" option").each(function (n) {
                  var a = $("#State" + i + " option").eq(n);                          
                      if ($(obj).val() == a.val()) {
                          $(a).attr("selected", true);
                      }
                  });
              });

              $("input:checkbox").attr("checked", true);
              $("tbody input:checkbox").parent().parent().addClass("trSelected");
          }

          //打开下载信息浏览Tab-----------------------------------------------------------/
          function openHref(ColumnCode, InfoID) {
              window.parent.SubIframeAddTab('浏览下载信息', 'Download/downItemShow.aspx?ColumnCode=' + ColumnCode + '&InfoID=' + InfoID, 'icon icon-info', true);          
          }

          //打开新增下载信息Tab-----------------------------------------------------------/
          function btnAdd() {
              window.parent.SubIframeAddTab('新增下载信息', 'Download/downInput.aspx?ColumnCode=<%=nColumnCode%>', 'icon icon-add', true);
          }


          //页面属性 Start--------------------------------------------------------------/
          $(function () {
           //   window.parent.addTab('新增下载信息', '../Down/downInput.aspx?ColumnCode=<%=nColumnCode%>', 'icon icon-add', false);
           //   window.parent.tabSelect(0);

              $("#tableContent table>tbody>tr input:text").addClass("inputText");
              $("#tableContent table>tbody>tr select").addClass("inputText");

              //linkbutton失效实例,增加权限控制       
              $('#btnAdd').linkbutton('<%=Czou2012.UI.Manager.CommonClass.OperatorRight.IsRightButton("enable","w")%>');
              $('#btnModify').linkbutton('<%=Czou2012.UI.Manager.CommonClass.OperatorRight.IsRightButton("enable","m")%>');
              $('#btnModifyMulti').linkbutton('<%=Czou2012.UI.Manager.CommonClass.OperatorRight.IsRightButton("enable","c")%>');
              $('#btnDelete').linkbutton('<%=Czou2012.UI.Manager.CommonClass.OperatorRight.IsRightButton("enable","d")%>');
              $('#btnQuery').linkbutton('<%=Czou2012.UI.Manager.CommonClass.OperatorRight.IsRightButton("enable","r")%>');
              // $('#btnForbid').linkbutton({ text: "可以" });
              $("#downTable").fixedtableheader({ headerrowsize: 1 });
            
            //  this.style.cssText += this.options[this.selectedIndex].style.cssText
          })
    
    </script>
</head>
<body>
     <div class="tableHeader">
        <span class="navImage">&nbsp;</span><asp:Label ID="lblNavigator" class="lblNavigator" runat="server"></asp:Label><span style="padding-left:20px;"><a id="btnAdd" class="easyui-linkbutton" icon="icon-add" href="javascript:btnAdd();" tabindex="8">新增</a></span>
    </div>
    <form id="formmodify" method="post" class="form" style="width:100%;">
    <div id="tableContent" style="height:75%;overflow: auto; border: 0px solid #ccc">
        <table class="commonTable" id="downTable">
            <thead>
                <tr>
                    <th style="width: 15px; text-align: center;">
                        <input type="checkbox" id="allCheck" style="border: 0px;" onclick="selectAll(this)" />
                    </th>
                    <th>
                        下载信息标题
                    </th>
                    <th style="width: 100px;">
                        类别代码
                    </th>
                    <th  style="width: 100px;">
                        录入人
                    </th>
                    <th style="width: 120px;">
                        发布日期
                    </th>
                    <th style="width: 50px; text-align: center;">
                        特征码
                    </th>
                    <th style="width: 50px; text-align: center; ">
                        点击
                    </th>
                    <th style="width: 50px; text-align: center;">
                        排序
                    </th>
                    <th style="width: 50px; text-align: center;">
                        推荐
                    </th>
                    <th style="width: 50px; text-align: center;">
             <select name="select0"  onchange="changeAllState(this);">
			    <option value="0">未审</option>
                <option value="1" style="background:#00cc00">已审</option>
                <option value="2" style="background:red">暂停</option>
              </select>
                    </th>
                </tr>
            </thead>
            <tbody>
                <asp:Label ID="tbodyDiv" runat="server"></asp:Label>
                <asp:Repeater runat="server" ID="columnRepeater">
                    <ItemTemplate>
                        <tr style='cursor: pointer;' id='tr_'>
                            <td style="text-align: center; border-left: 0px; border-right: 0px;">
                               <input type="checkbox" value="1" id="<%#"check"+Container.ItemIndex %>" name="<%#"check"+Container.ItemIndex %>"
                                        onclick="checkboxClick();">
                            </td>
                            <td>
                               <a href="#" onclick="openHref('<%# Eval("ColumnCode")%>','<%# Eval("InfoID")%>')" title="<%# Eval("Title")%>"><%# Eval("Title")%></a>
                               <input type="hidden" value="<%# Eval("InfoID")%>" id="<%#"InfoID"+Container.ItemIndex %>" name="<%#"InfoID"+Container.ItemIndex %>">
                               <input type="hidden" value="<%# Eval("Title")%>" name="<%#"Title"+Container.ItemIndex %>">
                               <%# (DataBinder.Eval(Container.DataItem, "PictureSavePath").ToString().Length > 4) ? "<span class='iconInfo icon-file' style='width:16px;height:16px'>&nbsp;</span>" : ""%>
                             </td>
                            <td>
                               <%# Eval("ColumnCode")%>&nbsp;
                            </td>
                             <td>
                               <%# Eval("InputBy")%>&nbsp;
                            </td>
                             <td>
                               <%# ((DateTime)Eval("PublishTime")).ToString("yyyy/MM/dd hh:mm:ss")%>
                            </td>
                             <td>
                                <input value="<%# Eval("CharacterCode")%>" name="<%#"CharacterCode"+Container.ItemIndex %>"
                                        onchange="inputChange(this,<%#Container.ItemIndex%>);"  maxlength="10"/>
                            </td>
                             <td>
                                <input value="<%# Eval("Clicks")%>"  name="<%#"Clicks"+Container.ItemIndex %>"
                                        onchange="inputChange(this,<%#Container.ItemIndex%>);" onblur="inputNumber(this);"/>
                            </td>
                            <td>
                                <input value="<%# Eval("InfoSort")%>" name="<%#"InfoSort"+Container.ItemIndex %>"
                                        onchange="inputChange(this,<%#Container.ItemIndex%>);"  onblur="inputNumber(this);"/>
                            </td>
                             <td  style="text-align:center;" >
                              <select name="<%#"Commend"+Container.ItemIndex %>" id="<%#"Commend"+Container.ItemIndex %>"
                                        style="margin: 0px;" onchange="inputChange(this,<%#Container.ItemIndex%>);">
                                        <option value='0' <%# (DataBinder.Eval(Container.DataItem, "Commend").ToString() == "0") ? "selected" : ""  %>
                                            style="background: white; height: 25px; line-height: 35px">普通</option>
                                        <option value='1' <%# (DataBinder.Eval(Container.DataItem, "Commend").ToString() == "1") ? "selected" : ""  %>
                                            style="background: yellow; height: 25px; line-height: 35px">推荐</option>
                                        <option value='2' <%# (DataBinder.Eval(Container.DataItem, "Commend").ToString() == "2") ? "selected" : ""  %>
                                            style="background: red; height: 25px;">头条</option>
                                    </select>

                            </td>    
                            <td style="text-align:center;">
                                                          <select name="<%#"State"+Container.ItemIndex %>"  id="<%#"State"+Container.ItemIndex %>"
                                        style="margin: 0px;" onchange="inputChange(this,<%#Container.ItemIndex%>);">
                                        <option value='0' <%# (DataBinder.Eval(Container.DataItem, "State").ToString() == "0") ? "selected" : ""  %>
                                            style="background: white; height: 25px; line-height: 35px">未审</option>
                                        <option value='1' <%# (DataBinder.Eval(Container.DataItem, "State").ToString() == "1") ? "selected" : ""  %>
                                            style="background: #00cc00; height: 25px; line-height: 35px">已审</option>
                                        <option value='2' <%# (DataBinder.Eval(Container.DataItem, "State").ToString() == "2") ? "selected" : ""  %>
                                            style="background: red; height: 25px; line-height: 35px">暂停</option>

                                    </select>

                            </td>

                        </tr>
                    </ItemTemplate>
                </asp:Repeater>
            </tbody>
        </table>
    </div>
    <table style="border: 0px; width: 100%;" cellpadding="0" cellspacing="0">
        <tr>
            <td style="height: 28px; background: #eee;">
                <div style="float: left;">
                    <asp:Label ID="LblPageNavigator" runat="server"></asp:Label>
                </div>
            </td>
            <td style="height: 28px; background: #eee;">
               <a id="btnModify" class="easyui-linkbutton" href="javascript:btnSingleModify();" tabindex="12">单条下载信息修改</a>
                &nbsp;&nbsp;&nbsp; <a id="btnDelete" class="easyui-linkbutton" href="#" tabindex="14" onclick='{ $.messager.confirm("操作提示", "删除的下载信息将不能恢复!您确定要继续吗？\n", function (data) {if (data) {btnDelete();}else {return false;}});}'>
                    选择删除</a>  &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; <a id="btnModifyMulti" class="easyui-linkbutton" href="javascript:btnModify();" tabindex="12">批量修改审核</a>
            </td>
        </tr>
        <tr>
            <td style="height: 28px;">
                <span id="lblDown" style="line-height: 25px; color: #ff0000;" class="lblDown"></span>
            </td>
        </tr>
    </table>
    <table class="pureTable" style="border: 1px solid #ccc; width: 100%;">
        <tr>
           
            <td class="bgGray" style="width: 100px; text-align: center;">
                关键字:
            </td>
            <td style="width: 200px">
                <input type="text" id="txtKeywords" name="txtKeywords" class="inputAdd input100" style="width: 90%;" />
            </td>
             <td class="bgGray" style="width: 100px; text-align: center;">
                录入人:
            </td>
            <td style="width: 150px">
                <input type="text" id="txtInputBy" name="txtInputBy" class="inputAdd input100" style="width: 90%;" />
            </td>
            <td style="text-align: left; padding-left: 15px;">
                <a id="btnQuery" class="easyui-linkbutton" href="javascript:btnQuery();" tabindex="13">
                    查询</a>&nbsp;&nbsp;&nbsp;<a id="btnReset" class="easyui-linkbutton" href="javascript:btnReset();"
                        tabindex="15">复原</a>
            </td>
        </tr>
    </table>
    </form>
</body>
</html>
