﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using Top.Api;
using Top.Api.Domain;
using Top.Api.Parser;
using Top.Api.Request;
using Top.Api.Response;

public class webPublic
{
    XabaraCom xc = new XabaraCom();
    dbDataFunction db = new dbDataFunction();

    /// <summary>
    /// 页面缓存
    /// </summary>
    /// <param name="n">输入时间（分）</param>
    /// <returns>true</returns>
    public bool cacheTime(int n)
    {
        HttpContext.Current.Response.Cache.SetExpires(DateTime.Now.AddSeconds(15 * 60));
        HttpContext.Current.Response.Cache.SetCacheability(HttpCacheability.Public);
        HttpContext.Current.Response.Cache.SetVaryByCustom("browser");
        HttpContext.Current.Response.Cache.VaryByParams["City"] = true;

        return true;
    }

    /// <summary>
    /// 淘宝店铺卖家信誉度
    /// </summary>
    /// <param name="credit">信誉度值</param>
    /// <returns></returns>
    public string taobaoCredit(string credit)
    {
        string htmStr = string.Empty;

        switch (credit)
        {
            case "1":
                htmStr = "b_red_1.gif";
                break;
            case "2":
                htmStr = "b_red_2.gif";
                break;
            case "3":
                htmStr = "b_red_3.gif";
                break;
            case "4":
                htmStr = "b_red_4.gif";
                break;
            case "5":
                htmStr = "b_red_5.gif";
                break;

            case "6":
                htmStr = "s_blue_1.gif";
                break;
            case "7":
                htmStr = "s_blue_2.gif";
                break;
            case "8":
                htmStr = "s_blue_3.gif";
                break;
            case "9":
                htmStr = "s_blue_4.gif";
                break;
            case "10":
                htmStr = "s_blue_5.gif";
                break;

            case "11":
                htmStr = "s_cap_1.gif";
                break;
            case "12":
                htmStr = "s_cap_2.gif";
                break;
            case "13":
                htmStr = "s_cap_3.gif";
                break;
            case "14":
                htmStr = "s_cap_4.gif";
                break;
            case "15":
                htmStr = "s_cap_5.gif";
                break;

            case "16":
                htmStr = "s_crown_1.gif";
                break;
            case "17":
                htmStr = "s_crown_2.gif";
                break;
            case "18":
                htmStr = "s_crown_3.gif";
                break;
            case "19":
                htmStr = "s_crown_4.gif";
                break;
            case "20":
                htmStr = "s_crown_5.gif";
                break;
        }

        htmStr = "<img src=\"/images/creditImg/" + htmStr + "\" style=\"vertical-align:middle;\" />";

        return htmStr;
    }

    /// <summary>
    /// 淘宝读取商品页码数
    /// </summary>
    /// <param name="nums">TotalResults 值</param>
    /// <returns></returns>
    public int taobaoReadPages(long nums, int pageSize)
    {
        int pageNums = Convert.ToInt32(nums % pageSize);
        if (pageNums == 0)
        {
            pageNums = Convert.ToInt32(nums / pageSize);
        }
        else
        {
            pageNums = Convert.ToInt32(nums / pageSize + 1);
        }

        return pageNums;
    }

    /// <summary>
    /// 支付接口更新状态
    /// </summary>
    /// <param name="trade_no">交易号</param>
    /// <param name="order_no">订单号</param>
    /// <param name="total_fee">总金额</param>
    /// <param name="buyer_email">买家账号</param>
    /// <param name="userCheckLogin">是否检查会员登录状态</param>
    public void payUpdate(string trade_no, string order_no, string total_fee, string buyer_email, bool userCheckLogin)
    {
        if (userCheckLogin) //检查登录状态
        {
            xc.checkUserLogin(string.Empty);
        }

        double price = Convert.ToDouble(total_fee);
        if (price > 0)
        {
            DataTable dt;
            /*double myMoney = 0;
            double myBuyMoney = 0;
            string userID = string.Empty;*/

            //取单子状态
            string strSql = "select * from moneyBankRemit where rndID='" + order_no + "' and remitMoney=" + total_fee + " and adminPass=11 and remitBank='支付宝在线支付'";
            //HttpContext.Current.Response.Write(strSql);
            //HttpContext.Current.Response.End();
            dt = db.getDataTable(strSql);
            if (dt.Rows.Count > 0)
            {
                /*userID = dt.Rows[0]["uID"].ToString().Trim();

                DataTable dtMoney = db.getDataTable("select * from moneyDetail where uID='" + userID + "' order by dID DESC LIMIT 0,1");  //取原余额及已消费额
                if (dtMoney.Rows.Count > 0)
                {
                    myMoney = Convert.ToDouble(dtMoney.Rows[0]["nowMoney"]);
                    myBuyMoney = Convert.ToDouble(dtMoney.Rows[0]["buyMoney"]);
                }
                dtMoney.Dispose();*/

                //更新moneyBankRemit状态为12 
                string strDim = "@adminPass,@adminID,@adminDate,@adminIP,@remitInfo";
                string[] strValue = new string[30];
                strValue[0] = "12"; //更新支付宝状态为12 表示有效
                strValue[1] = "alipay";
                strValue[2] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                strValue[3] = xc.GetIP();
                strValue[4] = "交易号：" + trade_no + " 买家帐号:" + buyer_email;
                db.InsertUpdateDB("moneyBankRemit", strDim, strValue, "rndID='" + order_no + "' and remitMoney=" + total_fee + " and adminPass=11 and remitBank='支付宝在线支付'");

                /*strDim = "@uID,@orderID,@addMoney,@subtractMoney,@nowMoney,@buyMoney,@moneyInfo,@adminID,@postDate,@postIP";   //增加帐户余额
                strValue[0] = userID;
                strValue[1] = order_no;
                strValue[2] = total_fee;
                strValue[3] = "0";
                strValue[4] = (myMoney + Convert.ToDouble(total_fee)).ToString();
                strValue[5] = myBuyMoney.ToString();
                strValue[6] = "支付宝在线支付";
                strValue[7] = "alipay";
                strValue[8] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                strValue[9] = xc.GetIP();
                db.InsertUpdateDB("moneyDetail", strDim, strValue, string.Empty);*/

                //广告状态更新
                string num_iid = string.Empty;
                long days = 0;
                strSql = "select * from taobaopop where payID='" + order_no + "'";
                dt = db.getDataTable(strSql);
                if (dt.Rows.Count > 0)
                {
                    days = xc.SafeNum(dt.Rows[0]["buyDays"].ToString().Trim());
                    strValue[0] = "1";
                    strValue[1] = DateTime.Now.AddDays(days).ToString("yyyy-MM-dd HH:mm:ss");
                    db.InsertUpdateDB("taobaopop", "@flagID,@adTo", strValue, "payID=" + order_no);

                    num_iid = dt.Rows[0]["num_iid"].ToString().Trim();
                }
            }
            dt.Dispose();
        }
        else
        {
            HttpContext.Current.Response.Write("返回参数有误！");
            HttpContext.Current.Response.End();
        }
    }

    //取字符长度
    public int wordLength(string wordStr)
    {
        string Str = string.Empty;
        char[] stringChar = wordStr.ToCharArray();
        StringBuilder sb = new StringBuilder();
        int nLength = 0;

        for (int i = 0; i < stringChar.Length; i++)
        {
            if (Encoding.Default.GetByteCount(stringChar[i].ToString()) == 2)
            {
                nLength += 2;
            }
            else
            {
                nLength = nLength + 1;
            }
        }

        return nLength;
    }
}