﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;

public partial class setup_step03 : System.Web.UI.Page
{
    XabaraCom xc = new XabaraCom();
    dbDataFunction db = new dbDataFunction();

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            FormCheck fc = new FormCheck();
            uIDRegularExpressionValidator.ValidationExpression = fc.RegExpressionValidator("userID", 3, 20, false);
            uIDRegularExpressionValidator.ErrorMessage = fc.RegExpressionValidator("userID", 3, 20, true);
            PWRegularExpressionValidator.ValidationExpression = fc.RegExpressionValidator("passWord", 8, 20, false);
            PWRegularExpressionValidator.ErrorMessage = fc.RegExpressionValidator("passWord", 8, 20, true);            
            
            ServerOS.Text = Environment.OSVersion.ToString();
            ServerOSVer.Text = xc.os(Environment.OSVersion.ToString());
            ServerSoft.Text = Request.ServerVariables["SERVER_SOFTWARE"];
            netVer.Text = Environment.Version.ToString();
            sqlVer.Text = db.sqlVer();

            //写入robots.txt
            string txt = Server.MapPath("/robots.txt");
            ExistsFile(txt);
            StreamWriter sr = new StreamWriter(txt, false, System.Text.Encoding.Default);
            try
            {
                sr.WriteLine("#");
                sr.WriteLine("# robots.txt for zdianpu.com");
                sr.WriteLine("# Version 4.0.0");
                sr.WriteLine("#");
                sr.WriteLine();
                sr.WriteLine("User-agent: *");
                sr.WriteLine("Sitemap: http://" + Request.Url.Host + "/sitemap.xml");
                sr.Close();
            }
            catch
            {
                Response.Write("请开启根目录 robots.txt 写入权限！");
            }
        }
    }

    private void ExistsFile(string FilePath)
    {
        if (!File.Exists(FilePath))
        {
            FileStream fs = File.Create(FilePath);
            fs.Close();
        }
    }

    protected void step_Click(object sender, EventArgs e)
    {
        Response.Clear();
        Response.Write("<div class=\"inputTextIME\" style=\"padding:10px;\"><span style=\"font-weight:bold; font-size:14px;\">执行信息如下：</span><br />");

        //创建表
        this.Execute("setup.sql");
        Response.Write("导入脚本安装包完成！<br />");
        Response.Flush();
        this.Execute("newstree.sql");
        Response.Write("导入分类完成！<br />");
        Response.Flush();
        this.Execute("keywordid.sql");
        Response.Write("导入关键词及品牌数据包完成！<br />");
        Response.Flush();
        this.Execute("classAdmin.sql");
        this.Execute("ads.sql");

        //数据导入
        string dt = DateTime.Now.ToString();
        string ip = xc.GetIP();
        string strSql = @"insert  into `adminuser`(`Uid`,`UserId`,`classID`,`UserName`,`userEmail`,`userTel`,`userMobile`,`userQQ`,`UserAdmin`,`UserPW`,`SessionError`,`loginFlag`,`LoginNum`,`RegDate`,`LoginDate`,`LoginIP`) values (1,'" + uID.Text.Trim() + @"',0,'管理员','','','','','xabaraCOM','" + xc.GetMd5(uPW.Text) + "','zdianpu.com',2,0,'" + dt + @"','" + dt + @"','" + ip + @"');";
        db.exeSql(strSql);

        Response.Write("导入数据完成！<br />");
        Response.Flush();      

        Response.Write("<br />恭喜您安装成功，进入网站后台并设置您的网站参数！ <a href=\"/webXabara/\" style=\"font-weight:bold;\" target=\"_top\">点击进入管理平台</a></div><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br />");

        Response.Write("<script type=\"text/javascript\">{setTimeout(\"top.window.location.href='/webXabara/'\",8000);}</script>");
    }

    private void Execute(string sql)
    {
        sql = Server.MapPath("/setup/sql/" + sql);
        System.IO.StreamReader sr = new System.IO.StreamReader(sql);
        string sqlstr = sr.ReadToEnd();
        sr.Close();
        //Response.Write(sqlstr.ToString());
        //Response.End();
        db.exeSql(sqlstr);
    }
}