﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="keyWordEdit.aspx.cs" Inherits="webXabara_shop_keyWordEdit" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>修改关键词</title>
    <link href="../InClude/StyleSheet.css" rel="stylesheet" type="text/css" />
    <style type="text/css">
    <!--
    body {
	    margin:8px 8px 0px 0px;
    }
    -->
    </style>
    <script src="/Scripts/jquery.min.js" type="text/javascript"></script>
    <script src="/Scripts/tipswindow.js" type="text/javascript"></script>
    <script src="/Scripts/all.js" type="text/javascript"></script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="divWidth">
        <div class="titleBg">修改关键词</div>
    </div>
    <div class="height10px">
    </div>
    <div class="divWidth">
        <table width="100%" class="tableLine">
            <tr>
                <td class="tdTitle">
                    <strong>分类名称</strong>
                </td>
                <td class="tdContent">
                    <asp:DropDownList ID="classID" runat="server" CssClass="inputText" 
                        ToolTip="请选择分类" AutoPostBack="True" 
                        onselectedindexchanged="classID_SelectedIndexChanged">
                    </asp:DropDownList>
                    &nbsp;<asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" 
                        ControlToValidate="classID" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    显示关键词</td>
                <td class="tdContent">
                    <asp:TextBox ID="wordName" runat="server" CssClass="inputText" Width="300px"></asp:TextBox>
                &nbsp;<asp:RequiredFieldValidator ID="RequiredFieldValidator6" runat="server" 
                        ControlToValidate="wordName" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    搜索关键词
                </td>
                <td class="tdContent">
                    <asp:TextBox ID="keyword" runat="server" CssClass="inputText" Width="300px"></asp:TextBox>
                &nbsp;<asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" 
                        ControlToValidate="keyword" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    搜索范围</td>
                <td class="tdContent">
                    <asp:RadioButtonList ID="isTmall" runat="server" 
                        RepeatDirection="Horizontal" RepeatLayout="Flow">
                        <asp:ListItem Value="true">只限淘宝商城</asp:ListItem>
                        <asp:ListItem Value="false">淘宝全站</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    用途</td>
                <td class="tdContent">
                    <asp:RadioButtonList ID="useType" runat="server" 
                        RepeatDirection="Horizontal" RepeatLayout="Flow">
                        <asp:ListItem Value="bq">标签</asp:ListItem>
                        <asp:ListItem Value="pp">品牌</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    状态</td>
                <td class="tdContent">
                    <asp:RadioButtonList ID="isBad" runat="server" 
                        RepeatDirection="Horizontal" RepeatLayout="Flow">
                        <asp:ListItem Value="0">启用</asp:ListItem>
                        <asp:ListItem Value="1">禁用</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    搜索价格范围</td>
                <td class="tdContent">
                    从 
                    <asp:TextBox ID="startPrice" runat="server" CssClass="inputTextIME" 
                        Width="80px" style="text-align:center;">50</asp:TextBox>
                    &nbsp;元至 
                    <asp:TextBox ID="endPrice" runat="server" CssClass="inputTextIME" 
                        Width="80px" style="text-align:center;">100000</asp:TextBox>
                    元<asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" 
                        ControlToValidate="startPrice" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator5" runat="server" 
                        ControlToValidate="endPrice" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                    <asp:RegularExpressionValidator SetFocusOnError="True" ForeColor="#ff3300" ID="startPriceRegExpre"
                        runat="server" ControlToValidate="startPrice"></asp:RegularExpressionValidator>
                    <asp:RegularExpressionValidator SetFocusOnError="True" ForeColor="#ff3300" ID="endPriceRegExpre"
                        runat="server" ControlToValidate="endPrice"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    &nbsp;
                </td>
                <td class="tdContent">
                    <asp:Button ID="keywords" runat="server" Text="确定修改" CssClass="inputBottom" 
                        onclick="keywords_Click" />
                </td>
            </tr>
        </table>
    </div>
    <div class="height10px"></div>
    <div class="divWidth">
        <table cellpadding="0" cellspacing="0" border="0" align="left" class="tableLine">
            <tr>
                <td class="tdTitle" style="text-align:left;">关键词</td>
                <td class="tdTitle" style="text-align:left;">搜索范围</td>
                <td class="tdTitle" style="text-align:left;">用途</td>
                <td class="tdTitle" style="text-align:left;">价格范围</td>
                <td class="tdTitle" style="text-align:left;">状态</td>
            </tr>
            <asp:Repeater ID="keyWordList" runat="server">
                <ItemTemplate>
                <tr>
                    <td><%# Eval("wordName").ToString().Trim()+" <span style=\"color:red;\">"+Eval("keywords").ToString().Trim()+"</span>"%></td>
                    <td><%# Eval("isTmall").ToString().Trim().Equals("true")?"淘宝商城":"全淘宝"%></td>
                    <td><%# Eval("useType").ToString().Trim().Equals("pp")?"品牌":"标签"%></td>
                    <td><%# Eval("startPrice").ToString().Trim() + " - " + Eval("endPrice").ToString().Trim()%></td>
                    <td><%# Eval("isBad").ToString().Trim().Equals("0")?"启用":"禁用"%></td>
                </tr>
                </ItemTemplate>
            </asp:Repeater>
        </table>
    </div>
    </form>
</body>
</html>

