﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ImageCropper.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.Accessories.ImageCropper" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>图片裁剪</title>
    <style type="text/css">
        .jcrop-holder
        {
            text-align: left;
        }
        .jcrop-vline, .jcrop-hline
        {
            font-size: 0;
            position: absolute; /*background: white url('Jcrop.gif') top left repeat*/
        }
        .jcrop-vline
        {
            height: 100%;
            width: 1px !important;
        }
        .jcrop-hline
        {
            width: 100%;
            height: 1px !important;
        }
        .jcrop-handle
        {
            font-size: 1px;
            width: 7px !important;
            height: 7px !important;
            border: 1px #eee solid;
            background-color: #333; *width:9px;*height:9px;}
        .jcrop-tracker
        {
            width: 100%;
            height: 100%;
        }
        .custom .jcrop-vline, .custom .jcrop-hline
        {
            background: yellow;
        }
        .custom .jcrop-handle
        {
            border-color: black;
            background-color: #C7BB00;
            -moz-border-radius: 3px;
            -webkit-border-radius: 3px;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <div style="padding: 5px">
        <img id="cropbox" />
            <input runat="server" type="hidden" id="picUrl" />
            <div style="margin-top: 10px">
                <label>
                    X<input runat="server" type="text" size="4" id="pX" name="X" /></label>
                <label>
                    Y<input runat="server" type="text" size="4" id="pY" name="Y" /></label>
                <label>
                    X2<input type="text" size="4" id="pX2" name="pX2" disabled="disabled" /></label>
                <label>
                    Y2<input type="text" size="4" id="pY2" name="pY2" disabled="disabled" /></label>
                <label>
                    W<input runat="server" type="text" size="4" id="wd" name="wd" /></label>
                <label>
                    H<input runat="server" type="text" size="4" id="ht" name="ht" /></label>
                <input id="setsel" type="button" value="设置" class="inputbutton" />
                <input id="release" type="button" value="释放" class="inputbutton" />
                <pe:OneClickButton runat="server" ID="btnCrop" OnClick="BtnCropClick" Text="裁剪" class="inputbutton" />
                <br />
                <input id="anim0" type="button" value="A0" class="inputbutton" />
                <input id="anim1" type="button" value="A1" class="inputbutton" />
                <input id="anim2" type="button" value="A2" class="inputbutton" />
                <input id="anim3" type="button" value="A3" class="inputbutton" />
                <input id="anim4" type="button" value="A4" class="inputbutton" />
                <input id="anim5" type="button" value="A5" class="inputbutton" />
                <input id="anim6" type="button" value="A6" class="inputbutton" />
                <input id="anim7" type="button" value="A7" class="inputbutton" />
                <input id="anim8" type="button" value="A8" class="inputbutton" />
                <input id="anim9" type="button" value="A9" class="inputbutton" />
            </div>
        </div>
        <br />
    </div>

    <script type="text/javascript" src="<%=BasePath%>JS/jquery.Jcrop.min.js"></script>

    <script type="text/javascript">
        var __isInit = true;
        function returnValue(path) {
            if ('<%=Type%>' == 'select') {  //选择文件时特殊处理
                parent.DealwithImageCropper(path);
                return;
            } else {
                parent.jQuery('#<%=ImgId %>').val(path);
                if (parent.document.getElementById('jqDnrFloatDivBg')) {
                    parent.document.getElementById('jqDnrFloatDivBg').style.display = "none";
                    parent.document.getElementById('<%=ImgDialogId%>').style.display = "none";
                }
            }
            __isInit = false;
        }
        var path = "";
        if ('<%=Type%>' == 'select') {  //选择文件时特殊处理
            path = '<%=UploadDir%>';
            var imgPath = parent.jQuery('#<%=ImgId %>').val();
            if (imgPath.indexOf("Template") > -1) {  //上传文件不在UploadDir时，特殊处理
                path = '<%=BasePath%>';
            }
            path = path + imgPath;
        } else {
            path = '<%=UploadDir%>' + parent.jQuery('#<%=ImgId %>').val();
        }

        if (path.indexOf("_S.") > 0) {
            path = path.replace("_S.", ".");
        }

        $('#cropbox').load(function() {
            if (!__isInit) return;
            $('#cropbox').unbind("load");
            function fn(e) {
                showCoords(e);
                aspectRatio: 1;
            }

            function showCoords(c) {
                jQuery('#<%=pX.ClientID %>').val(c.x);
                jQuery('#<%=pY.ClientID %>').val(c.y);
                jQuery('#pX2').val(c.x2);
                jQuery('#pY2').val(c.y2);
                jQuery('#<%=wd.ClientID %>').val(c.w);
                jQuery('#<%=ht.ClientID %>').val(c.h);
            };

            var api = $.Jcrop('#cropbox', {
                boxWidth: 530,
                boxHeight: 350,
                setSelect: [100, 100, 260, 220],
                onChange: fn,
                onSelect: fn
            });

            jQuery('#release').click(function(e) {
                api.release();
            });

            var i, ac;

            function nothing(e) {
                e.stopPropagation();
                e.preventDefault();
                return false;
            };

            function anim_handler(ac) {
                return function(e) {
                    api.animateTo(ac);
                    return nothing(e);
                };
            };

            var ac =
				{
				    anim0: [10, 10, 110, 110],
				    anim1: [30, 30, 90, 90],
				    anim2: [20, 20, 180, 140],
				    anim3: [60, 60, 320, 200],
				    anim4: [0, 0, 390, 260],
				    anim5: [100, 100, 398, 260],
				    anim6: [0, 0, 96, 65],
				    anim7: [80, 160, 420, 260],
				    anim8: [10, 10, 240, 180],
				    anim9: [0, 0, 108, 80]
				};

            for (i in ac) jQuery('#' + i).click(anim_handler(ac[i]));

            jQuery('#setsel').click(function(e) {
                var _x = jQuery('#<%=pX.ClientID %>').val();
                var _y = jQuery('#<%=pY.ClientID %>').val();
                var _wd = jQuery('#<%=wd.ClientID %>').val();
                var _ht = jQuery('#<%=ht.ClientID %>').val();
                api.animateTo([_x, _y, (Number(_x) + Number(_wd)), (Number(_y) + Number(_ht))]);
                return nothing(e);
            });
        });
        jQuery('#cropbox').attr("src", path);

        jQuery('#<%=picUrl.ClientID %>').val(path);
        
    </script>

    </form>
</body>
</html>
