﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="PowerEasy.Module.General.WebSite.Admin.Collection.HistoryManage"
    MasterPageFile="~/Admin/MasterPage.master" Title="采集历史记录管理" ValidateRequest="false"
    CodeBehind="HistoryManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
    <div style="padding-top: 5px;"></div>
    <table border='0' cellpadding='0' cellspacing='1' width='100%' height='100%'>
      <tr >
        <td id="AdminTabs">
            <ul>
                <!-- CSS Tabs -->
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="HistoryList" />>
                    <asp:LinkButton ID="LinkHistoryList" runat="server"   CommandArgument="0"
                        onclick="ShowBookmarks"><span>所有记录</span></asp:LinkButton>
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="SuccessHistory" />> 
                    <asp:LinkButton ID="LinkSuccessHistory" runat="server"  CommandArgument="1"
                        onclick="ShowBookmarks"><span>所有成功记录</span></asp:LinkButton>  
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="FailedHistory" />>    
                    <asp:LinkButton ID="LinkFailedHistory" runat="server" CommandArgument="2"
                        onclick="ShowBookmarks"><span>所有失败记录</span></asp:LinkButton> 
                </li>
            </ul>
          </td>
      </tr>
    </table>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="EgvHistory" runat="server" AllowPaging="True" AutoGenerateColumns="False"
        DataKeyNames="HistoryID" DataSourceID="OdsCollectionHistory" ItemName="历史记录"
        ItemUnit="个" CheckBoxFieldHeaderWidth="3%" SerialText="" AutoGenerateCheckBoxColumn="True"
        OnRowDataBound="EgvHistory_RowDataBound">
        <Columns>
            <pe:BoundField DataField="HistoryID" HeaderText="ID" SortExpression="HistoryID">
                <HeaderStyle Width="3%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="标题" SortExpression="UrlName">
                <ItemTemplate>
                    <asp:HyperLink ID="LnkTitle" runat="server"></asp:HyperLink>
                </ItemTemplate>
                <ItemStyle HorizontalAlign="Left" />
            </pe:TemplateField>
            <pe:TemplateField HeaderText="项目名称" SortExpression="ItemName">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <asp:HyperLink ID="LnkItemName" runat="server"></asp:HyperLink>
                </ItemTemplate>
            </pe:TemplateField>
            
            <pe:BoundField DataField="NodeName" HeaderText="所属栏目" SortExpression="ItemName">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:BoundField DataField="ModelName" HeaderText="所属模型" SortExpression="ItemName">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="采集网站" SortExpression="UrlName">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <a href="<%#Eval("NewsUrl")%>" target='_blank'>点击浏览</a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="结果 " SortExpression="NodeID">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                   <pe:ExtendedLabel HtmlEncode="false" ID="LblResultType" runat="server" Text=""></pe:ExtendedLabel>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="备注 " SortExpression="NodeID">
                <HeaderStyle Width="18%" />
                <ItemTemplate>
                   <pe:ExtendedLabel HtmlEncode="false" ID="LblRemark" runat="server" Text=""></pe:ExtendedLabel>
                </ItemTemplate>
                <ItemStyle HorizontalAlign="Left" />
            </pe:TemplateField>
            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="5%" />
                <ItemTemplate>
                    <a href="HistoryManage.aspx?Action=Delete&HistoryID=<%#Eval("HistoryID")%>" onclick="return confirm('是否删除该采集历史记录？');">
                        删除</a>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnStatus" runat="server" Value="0" />
    <br />
    <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" />选中本页显示的所有项目
    &nbsp;&nbsp;
    <asp:Button ID="BtnBatchDelete" Text="批量删除选定采集历史记录" OnClientClick="return batchconfirm('确实要删除选中的采集历史记录么？')"
        runat="server" OnClick="BtnBatchDelete_Click" />&nbsp;&nbsp;<asp:Button ID="BtnDeleteErr"
            runat="server" Text="删除全部失败记录" OnClick="BtnDeleteErr_Click" OnClientClick="return confirm('确实要删除全部失败记录？')" />&nbsp;&nbsp;<asp:Button
                ID="BtnDeleteSuccess" runat="server" Text="删除全部成功记录" OnClick="BtnDeleteSuccess_Click" OnClientClick="return confirm('确实要删除全部成功记录？')" />&nbsp;&nbsp;<asp:Button
                    ID="BtnDeleteAll" runat="server" Text="清空采集历史记录" OnClick="BtnDeleteAll_Click"
                    OnClientClick="return confirm('确实要清空采集历史记录么？')" />
    <br />
    <asp:ObjectDataSource ID="OdsCollectionHistory" runat="server" SelectMethod="GetCollectionHistory"
        SelectCountMethod="GetCountNumber" TypeName="PowerEasy.Module.General.BusinessLogic.Collection.CollectionHistory"
        EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows"
        OldValuesParameterFormatString="original_{0}">
        <SelectParameters>
            <asp:ControlParameter ControlID="HdnStatus" Type="Int32" Name="status" PropertyName="Value" />
        </SelectParameters>
        <DeleteParameters>
            <asp:Parameter Name="id" Type="String" />
        </DeleteParameters>
    </asp:ObjectDataSource>
</asp:Content>
