﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="Field.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.CommonModel.FieldUI"
    ValidateRequest="false" Title="字段添加/修改" %>

<asp:Content ID="Content3" ContentPlaceHolderID="CphNavigation" runat="Server">
    <table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
        <tr>
            <td>
                <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
            </td>
            <td align="right">
                <pe:ExtendedLabel HtmlEncode="false" ID="LblModelName" runat="server" Text=""></pe:ExtendedLabel>
                &nbsp;
            </td>
        </tr>
    </table>
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="CphContent" runat="Server">
    <asp:ScriptManager ID="SmContent4" runat="server" ScriptMode="Release" EnablePartialRendering="true">
    </asp:ScriptManager>

    <script type="text/javascript">
        function SetLitFieldName(value) {
            document.getElementById("<%= LblFieldName.ClientID %>").innerHTML = value;
        }
    </script>

    <table cellpadding="2" cellspacing="1" border="0" width="100%" class="border">
        <tr>
            <td class="title" colspan="2" align="center">
                <asp:Label ID="LblTitle" runat="server" Text="添加字段" Font-Bold="True"></asp:Label>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>字段名称：</strong>
            </td>
            <td align="left">
                <asp:TextBox ID="TxtFieldName" runat="server" MaxLength="21"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrFieldName" ControlToValidate="TxtFieldName" runat="server"
                    ErrorMessage="字段名称不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                <pe:RegexValidator ValidateType="Field" ControlToValidate="TxtFieldName" ID="FieldValidator1"
                    runat="server"></pe:RegexValidator>
                <br />
                <span style="color: Blue">注：字段名由字母、数字、下划线组成。 例如：Content</span>
                <br />
                可以在模板中用数据源标签调用该字段内容，调用形式例如：<br />
                {PE.Field ID="数据源标签ID" fieldname="<asp:Label ID="LblFieldName" Style="color: Red;"
                    runat="server"></asp:Label>" /}
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>字段别名：</strong>
            </td>
            <td align="left">
                <asp:TextBox ID="TxtFieldAliax" runat="server"></asp:TextBox>
                <br />
                <span style="color: blue">例如：文章内容</span>
                <pe:RequiredFieldValidator ID="ValrFieldAliax" ControlToValidate="TxtFieldAliax"
                    runat="server" ErrorMessage="字段别名不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>字段提示：</strong>
            </td>
            <td align="left">
                <asp:TextBox ID="TxtTips" runat="server"></asp:TextBox>
                <span style="color: Blue">显示在字段别名下方作为重要提示的文字</span>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>字段描述：</strong>
            </td>
            <td align="left">
                <asp:TextBox ID="TxtDescription" runat="server" Height="43px" TextMode="MultiLine"
                    Width="208px"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否必填：</strong>
            </td>
            <td align="left">
                <asp:RadioButtonList ID="RadlEnableNull" runat="server" Height="3px" RepeatDirection="Horizontal">
                    <asp:ListItem Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在搜索表单显示：</strong>
            </td>
            <td align="left">
                <asp:RadioButtonList ID="RadlEnableShowOnSearchForm" runat="server" Height="3px"
                    RepeatDirection="Horizontal">
                    <asp:ListItem Value="True" Selected="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg" id="trDisabled" runat="server">
            <td class="tdbgleft">
                <strong>是否显示在添加页面：</strong><br />
                不显示的字段将不会出现在添加页面，其值是默认值
            </td>
            <td align="left">
                <asp:RadioButtonList ID="RadDisabled" runat="server" Height="3px" RepeatDirection="Horizontal">
                    <asp:ListItem Value="False" Selected="True">是</asp:ListItem>
                    <asp:ListItem Value="True">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>此字段的类型：</strong>
            </td>
            <td id="TdFieldType" runat="server" align="left">
                <table>
                    <tr>
                        <td colspan="3">
                            <strong>基本字段</strong>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButton ID="RadTextType" Checked="true" Text="单行文本" AutoPostBack="true"
                                GroupName="RadFieldType" runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                        </td>
                        <td>
                            <asp:RadioButton ID="RadMultipleTextType" AutoPostBack="true" Text="多行文本（不支持HTML）"
                                GroupName="RadFieldType" runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                        </td>
                        <td>
                            <asp:RadioButton ID="RadMultipleHtmlTextType" AutoPostBack="true" Text="多行文本（支持HTML）"
                                GroupName="RadFieldType" runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButton ID="RadListBoxType" AutoPostBack="true" Text="选项" GroupName="RadFieldType"
                                runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                        </td>
                        <td>
                            <asp:RadioButton ID="RadNumberType" AutoPostBack="true" Text="数字" GroupName="RadFieldType"
                                runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                        </td>
                        <td>
                            <asp:RadioButton ID="RadMoneyType" AutoPostBack="true" Text="货币" GroupName="RadFieldType"
                                runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButton ID="RadDateTimeType" AutoPostBack="true" Text="日期和时间" GroupName="RadFieldType"
                                runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                        </td>
                        <td>
                            <asp:RadioButton ID="RadLookType" AutoPostBack="true" Text="查阅项" GroupName="RadFieldType"
                                runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                        </td>
                        <td>
                            <asp:RadioButton ID="RadLinkType" AutoPostBack="true" Text="超链接" GroupName="RadFieldType"
                                runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButton ID="RadBoolType" AutoPostBack="true" Text="是/否（复选框）" GroupName="RadFieldType"
                                runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                        </td>
                        <td>
                            <asp:RadioButton ID="RadPictureType" AutoPostBack="true" Text="图片" GroupName="RadFieldType"
                                runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                        </td>
                        <td>
                            <asp:RadioButton ID="RadFileType" AutoPostBack="true" Text="文件" GroupName="RadFieldType"
                                runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:RadioButton ID="RadColorType" AutoPostBack="true" Text="颜色代码" GroupName="RadFieldType"
                                runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                        </td>
                        <td>
                            &nbsp;
                        </td>
                        <td>
                            &nbsp;
                        </td>
                    </tr>
                    <tr id="trPreDefined" runat="server">
                        <td colspan="3">
                            <table>
                                <tr>
                                    <td colspan="3">
                                        <strong>系统预定义字段</strong>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButton ID="RadOperatingType" AutoPostBack="true" Text="运行平台" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                    <td>
                                        <asp:RadioButton ID="RadRegionType" AutoPostBack="true" Text="行政区划" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                    <td>
                                        <asp:RadioButton ID="RadKeywordType" AutoPostBack="true" Text="关键字" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButton ID="RadContentType" AutoPostBack="true" Text="内容" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                    <td>
                                        <asp:RadioButton ID="RadSelectUser" AutoPostBack="true" Text="选择用户" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                    <td>
                                        <asp:RadioButton ID="RadMultiplePhotoType" runat="server" AutoPostBack="true" GroupName="RadFieldType"
                                            OnCheckedChanged="RadlFieldType_SelectedIndexChanged" Text="多图片" Visible="false" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButton ID="RadLinkageType" AutoPostBack="true" Text="多级联动" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                    <td></td>
                                    <td>&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButton ID="RadTitleType" AutoPostBack="true" Text="标题" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                    <td>
                                        <asp:RadioButton ID="RadInfoType" AutoPostBack="true" Text="虚链接" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                    <td>
                                        <asp:RadioButton ID="RadTemplateType" AutoPostBack="true" Text="模板" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButton ID="RadSpecialType" AutoPostBack="true" Text="专题" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                    <td>
                                        <asp:RadioButton ID="RadNodeType" AutoPostBack="true" Text="节点" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                    <td>
                                        <asp:RadioButton ID="RadStatusType" AutoPostBack="true" Text="状态" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButton ID="RadSkinType" AutoPostBack="true" Text="风格" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                    <td>
                                    </td>
                                    <td>
                                    </td>
                                </tr>
                                
                            </table>
                            <%--<strong>系统预定义字段</strong>--%>
                        </td>
                    </tr>
                    <%--<strong>房产预定义字段</strong>--%>
                    <tr  id="trHouse" runat="server" visible="false">
                        <td>
                            <asp:RadioButton ID="RadHouseType" AutoPostBack="true" Text="户型" GroupName="RadFieldType"
                                runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                        </td>
                        <td>
                            <asp:RadioButton ID="RadMultiplePhotoViewType" AutoPostBack="true" Text="多图片(视图)" GroupName="RadFieldType"
                                runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                        </td>
                        <td>
                            <asp:RadioButton ID="RadFlvType" AutoPostBack="true" Text="视频" GroupName="RadFieldType"
                                runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                        </td>
                    </tr>
                    <tr id="trCMS" runat="server" visible="false">
                        <td colspan="3">
                            <table>
                                <tr>
                                    <td colspan="3">
                                        <strong>内容系统预定义字段</strong>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButton ID="RadAuthorType" AutoPostBack="true" Text="作者" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                    <td>
                                        <asp:RadioButton ID="RadSourceType" AutoPostBack="true" Text="来源" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                    <td>
                                        <asp:RadioButton ID="RadDownServerType" AutoPostBack="true" Text="下载服务器" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                </tr>
                            </table>
                            <%--<strong>CMS系统预定义字段</strong>--%>
                        </td>
                    </tr>
                    <tr id="trBizIdea" runat="server" visible="false">
                        <td colspan="3">
                            <table>
                                <tr>
                                    <td colspan="3">
                                        <strong>商品系统预定义字段</strong>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButton ID="RadProducer" AutoPostBack="true" Text="厂商" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                    <td>
                                        <asp:RadioButton ID="RadTrademark" AutoPostBack="true" Text="品牌" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                    <td>
                                        <asp:RadioButton ID="RadProperty" AutoPostBack="true" Text="商品属性" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButton ID="RadProductStyle" AutoPostBack="true" Text="商品款式" GroupName="RadFieldType"
                                            runat="server" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                    <td>
                                    </td>
                                    <td>
                                    </td>
                                </tr>
                            </table>
                            <%--<strong>BizIdea系统预定义字段</strong>--%>
                        </td>
                    </tr>
                    <tr id="trOther" runat="server" visible="false">
                        <td colspan="3">
                            <table>
                                <tr>
                                    <td colspan="2">
                                        <strong>其他预定义字段</strong>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:RadioButton ID="RadUserNameType" AutoPostBack="true" Text="用户名" GroupName="RadFieldType"
                                            runat="server" Visible="false" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                    <td>
                                        <asp:RadioButton ID="RadIPType" AutoPostBack="true" Text="IP地址" GroupName="RadFieldType"
                                            runat="server" Visible="false" OnCheckedChanged="RadlFieldType_SelectedIndexChanged" />
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tbody id="PnlText" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>最大字符数：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtTextMaxLength" Text="200" runat="server" Columns="5"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ValrTextMaxLength" ControlToValidate="TxtTextMaxLength"
                        runat="server" ErrorMessage="最大字符数不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                    <asp:RangeValidator ID="ValgTextMaxLength" ControlToValidate="TxtTextMaxLength" runat="server"
                        ErrorMessage="最大字符数超出1-255的范围！" Type="Integer" Display="Dynamic" MaximumValue="255"
                        MinimumValue="1"></asp:RangeValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>文本框长度：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtTextSize" Text="30" runat="server" Columns="5"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ValrTextSize" ControlToValidate="TxtTextSize" runat="server"
                        ErrorMessage="文本框长度不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                    <asp:RangeValidator ID="ValgTextSize" ControlToValidate="TxtTextSize" Type="Integer"
                        runat="server" ErrorMessage="文本框长度超出1-255的范围！" Display="Dynamic" MaximumValue="250"
                        MinimumValue="1"></asp:RangeValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>验证规则：</strong>
                </td>
                <td align="left">
                    <table>
                        <tr id="RegexErrorMsg" style="display: none">
                            <td>
                                验证错误提示：
                            </td>
                            <td>
                                <asp:TextBox ID="TxtRegexErrorMsg" Columns="55" runat="server"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:DropDownList ID="DropTextBoxRegexRule" runat="server">
                                    <asp:ListItem Text="无" Value="" Selected="True"></asp:ListItem>
                                    <asp:ListItem Text="Email地址" Value="\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*"></asp:ListItem>
                                    <asp:ListItem Text="固定电话号码" Value="0?1[35][0-9]{9}|(\(\d{3,4}\)|\d{3,4}-?)?\d{7,8}(-\d{1,5})?"></asp:ListItem>
                                    <asp:ListItem Text="手机号码" Value="0?1[35][0-9]{9}|(\(\d{3,4}\)|\d{3,4}-?)?\d{7,8}(-\d{1,5})?"></asp:ListItem>
                                    <asp:ListItem Text="邮政编码" Value="\d{6}"></asp:ListItem>
                                    <asp:ListItem Text="纯数字" Value="^[0-9]*$"></asp:ListItem>
                                    <asp:ListItem Text="纯英文字母" Value="^[A-Za-z]+$"></asp:ListItem>
                                    <asp:ListItem Text="纯中文" Value="^[\u4e00-\u9fa5]+$"></asp:ListItem>
                                    <asp:ListItem Text="自定义" Value="Self"></asp:ListItem>
                                </asp:DropDownList>
                            </td>
                            <td>
                                <asp:TextBox ID="TxtRegexRule" Columns="55" runat="server"></asp:TextBox>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtTextDefaultValue" Columns="73" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>输入法设置：</strong>
                </td>
                <td align="left">
                    <asp:DropDownList ID="DropTextIMEMode" runat="server">
                        <asp:ListItem Value="0" Selected="True">默认</asp:ListItem>
                        <asp:ListItem Value="1">启用</asp:ListItem>
                        <asp:ListItem Value="2">禁用</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <pec:AttachFieldControl ID="AttachSingle" runat="server"></pec:AttachFieldControl>
        </tbody>
        <tbody id="PnlMultiText" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>显示的宽度：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtMultiTextWidth" Text="500" runat="server" Columns="5"></asp:TextBox>
                    <span style="color: Blue">px &nbsp;例如：500px</span>
                    <pe:RequiredFieldValidator ID="ValrMultiTextWidth" runat="server" ControlToValidate="TxtMultiTextWidth"
                        Display="Dynamic" ErrorMessage="显示宽度不能为空"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidator10" ControlToValidate="TxtMultiTextWidth"
                        runat="server">
                    </pe:RegexValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>显示的高度：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtMultiTextRow" Text="80" runat="server" Columns="5"></asp:TextBox>
                    <span style="color: Blue">px &nbsp;例如：80px</span>
                    <pe:RequiredFieldValidator ID="ValrMultiTextRow" runat="server" ControlToValidate="TxtMultiTextRow"
                        Display="Dynamic" ErrorMessage="显示高度不能为空"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidator9" ControlToValidate="TxtMultiTextRow"
                        runat="server">
                    </pe:RegexValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtMultiDefault" TextMode="MultiLine" Height="100px" Columns="60"
                        runat="server"></asp:TextBox>
                </td>
            </tr>
            <pec:AttachFieldControl ID="AttachMulit" runat="server"></pec:AttachFieldControl>
        </tbody>
        <tbody id="PnlEditor" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>编辑器类型：</strong>
                </td>
                <td align="left">
                    <asp:DropDownList ID="DropEditorType" runat="server">
                        <asp:ListItem Value="1" Selected="True">简洁型编辑器</asp:ListItem>
                        <asp:ListItem Value="2">标准型编辑器</asp:ListItem>
                        <asp:ListItem Value="3">增强型编辑器</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>编辑器大小：</strong>
                </td>
                <td align="left">
                    宽
                    <asp:TextBox ID="TxtEditorWidth" Text="600" runat="server" Columns="5"></asp:TextBox>
                    <span style="color: Blue">px&nbsp;例如：600px</span>
                    <pe:RequiredFieldValidator ID="ValrEditorWidth" runat="server" ControlToValidate="TxtEditorWidth"
                        Display="Dynamic" ErrorMessage="显示宽度不能为空"></pe:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="ValeEditorWidth" runat="server" ControlToValidate="TxtEditorWidth"
                        ErrorMessage="只能输入字母数字百分号" ValidationExpression="^[a-zA-Z%0-9]*$" Display="Dynamic"></asp:RegularExpressionValidator>
                    <br />
                    高
                    <asp:TextBox ID="TxtEditorHight" Text="500" runat="server" Columns="5"></asp:TextBox>
                    <span style="color: Blue">px&nbsp;例如：350px</span>
                    <pe:RequiredFieldValidator ID="ValrEditorHight" runat="server" ControlToValidate="TxtEditorHight"
                        Display="Dynamic" ErrorMessage="显示高度不能为空"></pe:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="ValeEditorHight" runat="server" ControlToValidate="TxtEditorHight"
                        ErrorMessage="只能输入字母数字百分号" ValidationExpression="^[a-zA-Z%0-9]*$" Display="Dynamic"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtMulitHtmlDefault" TextMode="MultiLine" Height="100px" Columns="60"
                        runat="server"></asp:TextBox>
                </td>
            </tr>
            <pec:AttachFieldControl ID="AttachMulitHtml" runat="server"></pec:AttachFieldControl>
        </tbody>
        <tbody id="PhlFilter" runat="server" visible="false">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>是否属于筛选字段：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadlEnableFilter" runat="server" Height="3px" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                    <span style="color: Blue">注：目前只支持“单行文本”和“选项”类型作为筛选字段</span>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlChoice" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>每个选项：</strong>
                </td>
                <td align="left">

                    <script type="text/javascript">
                        function AddUrl() {
                            var url = document.getElementById('newOption').value;
                            if (url != null && url != '') {
                                document.getElementById("<%= eListBox.ClientID %>").options[document.getElementById("<%= eListBox.ClientID %>").length] = new Option(url, url);
                                var thisurl = '选项名称' + (document.getElementById("<%= eListBox.ClientID %>").length + 1) + '|选项值';
                                document.getElementById('newOption').value = thisurl;
                            }
                        }
                        function ModifyUrl() {
                            if (document.getElementById("<%= eListBox.ClientID %>").length == 0) return false;
                            var thisurl = document.getElementById("<%= eListBox.ClientID %>").value;
                            if (thisurl == '') { alert('请先选择一个选项，再点修改按钮！'); return false; }
                            var url = prompt('请输入选项名称和值，中间用“|”隔开：', thisurl);
                            if (url != thisurl && url != null && url != '') {
                                document.getElementById("<%= eListBox.ClientID %>").options[document.getElementById("<%= eListBox.ClientID %>").selectedIndex] = new Option(url, url);
                            }
                        }
                        function DelUrl() {
                            if (document.getElementById("<%= eListBox.ClientID %>").length == 0) return false;
                            var thisurl = document.getElementById("<%= eListBox.ClientID %>").value;
                            if (thisurl == '') { alert('请先选择一个选项，再点删除按钮！'); return false; }
                            document.getElementById("<%= eListBox.ClientID %>").options[document.getElementById("<%= eListBox.ClientID %>").selectedIndex] = null;
                        }

                        function ChangeHiddenFieldValue() {
                            var obj = document.getElementById("<%= HdnChoiceUrls.ClientID %>");
                            var choiceUrl = document.getElementById("<%= eListBox.ClientID %>");
                            var Default = document.getElementById('<%=TxtChoiceDefaultValue.ClientID %>').value;
                            var bFoundMatchWithDefault = false;

                            var value = "";
                            if (choiceUrl.length < 1) {
                                alert("请添加选项！");
                                return false;
                            }

                            for (i = 0; i < choiceUrl.length; i++) {
                                if (value != "") {
                                    value = value + "$$$";
                                }
                                value = value + choiceUrl.options[i].value;

                                if (Default == choiceUrl.options[i].value.split("|")[1]) {
                                    bFoundMatchWithDefault = true;
                                }

                            }
                            obj.value = value;

                            if (Default && !bFoundMatchWithDefault) {
                                alert("“选项”域的默认值必须从指定的选项中选择。请再试一次。");
                                return false;
                            }
                            else {
                                obj.value = value;
                                return true;
                            }

                            return true;
                        }
                        function UpOrder(clientId) {
                            var sel = document.getElementById(clientId);
                            if (sel.selectedIndex >= 0) {
                                var tempValue = sel.options[sel.selectedIndex].value;
                                var tempText = sel.options[sel.selectedIndex].text;
                            } else { alert("请选择要移动的项。"); return; }

                            if (sel.selectedIndex > 0) {
                                sel.options[sel.selectedIndex].text = sel.options[sel.selectedIndex - 1].text;
                                sel.options[sel.selectedIndex - 1].text = tempText;
                                sel.options[sel.selectedIndex].value = sel.options[sel.selectedIndex - 1].value;
                                sel.options[sel.selectedIndex - 1].value = tempValue;
                                sel.selectedIndex = sel.selectedIndex - 1;
                            }
                            if (sel.onchange) {
                                sel.onchange();
                            }
                        }
                        function DownOrder(clientId) {
                            var sel = document.getElementById(clientId);
                            if (sel.selectedIndex >= 0) {
                                var tempValue = sel.options[sel.selectedIndex].value;
                                var tempText = sel.options[sel.selectedIndex].text;
                            } else { alert("请选择要移动的项。"); return; }
                            if (sel.selectedIndex < sel.options.length - 1) {
                                sel.options[sel.selectedIndex].text = sel.options[sel.selectedIndex + 1].text;
                                sel.options[sel.selectedIndex + 1].text = tempText;
                                sel.options[sel.selectedIndex].value = sel.options[sel.selectedIndex + 1].value;
                                sel.options[sel.selectedIndex + 1].value = tempValue;
                                sel.selectedIndex = sel.selectedIndex + 1;
                            }
                            if (sel.onchange) {
                                sel.onchange();
                            }
                        }                   
                    </script>

                    <table width="100%" border="0" cellpadding="0" cellspacing="0">
                        <tr>
                            <td align="left" style="width: 355px;">
                                <asp:HiddenField ID="HdnChoiceUrls" runat="server" />
                                <pe:ExtendedListBox ID="eListBox" Width="100%" Height="100px" UnSelectedClientTips="请选择要移动的项。" runat="server" ondblclick="return ModifyUrl();">
                                </pe:ExtendedListBox>
                               
                            </td>
                            <td align="left">
                                <input type="button" class="inputbutton" value="　　向上　　" onclick="UpOrder('<%= eListBox.ClientID %>')" /><br />
                                <input type="button" class="inputbutton" value="　　向下　　" onclick="DownOrder('<%= eListBox.ClientID %>')" /><br />
                                <input type="button" class="inputbutton" name="modifyurl" value="修改当前选项" onclick="return ModifyUrl();" /><br />
                                <input type="button" class="inputbutton" name="delurl" value="删除当前选项" onclick="DelUrl();" />
                            </td>
                        </tr>
                        <tr>
                        <td colspan="2">
                                <input id="newOption" type="text" class="inputtext" value="选项名称1|选项值" style="width:348px; margin-right:0" />
                                <input type="button" class="inputbutton" style="margin-left:1px" name="addurl" value="　添加选项　" onclick="AddUrl();" /><br />
                                <input id="OptionBeathButton" type="button" class="inputbutton" value="批量设置"/>
                                <span style="color: Green">注</span>：显示数据|保存数据，如果添加空数据可写 “无|”
                        </td>
                        </tr>
                    </table>
                        <div id="OptionBeath" class="HelpTips" title="备忘录">
        <div id="OptionBeathTitle" class="HelpTitle" style="padding-left:0">
            <a href="javascript:" onclick="javascript:$('#ly').click();" title="关闭" class="tips_close">
            </a><span style="padding-left:10px">批量设置</span>
        </div>
        <div id="OptionBeathInfo" class="HelpInfo" height="350px">
           <table width="448">
           <tr>
           <td align="center" style="width:50%">
             选项名称
           </td>
           <td  align="center">
             选项值
           </td>
           </tr>
           <tr>
              <td>
                  <textarea id="optionname" class="inputtext" style="width:200px;height:180px" rows="10" cols="50"></textarea>
              </td>
              <td>
                  <textarea id="optionvalue" class="inputtext" style="width:200px;height:180px" rows="10" cols="50"></textarea>
              </td>
           </tr>
           <tr>
               <td colspan="2" align="center">
                  <input id="Button1" type="button" class="inputbutton" value="保存设置" onclick="updateBeathInfo();"/>
                  <input id="Button2" type="button" class="inputbutton" value="　取消　" onclick="javascript:$('#ly').click();"/>
               </td>
           </tr>
           </table>
        </div>
    </div>
    <div id="ly" style="position: absolute; top: 0px; filter: alpha(opacity=60); opacity: 0.5;
        background-color: #777; z-index: 1000; left: 0px; display: none;">
       <iframe id="ifly" name="ifly" src="" frameborder="0" width="100%" height="100%" scrolling="no"
            marginheight="0" marginwidth="0" style="z-index: 999; filter: chroma(color=#ffffff);"></iframe>
    </div>
    <script type="text/javascript">
        $("#OptionBeathButton").click(function () {
            lock("OptionBeath");
            var optionname = '';
            var optionvalue = '';
            $("select[id='<%= eListBox.ClientID %>'] option").each(function () {
                if ($(this).val() != null && $(this).val() != '') {
                    var vv = $(this).val().split('|');
                    optionname += vv[0] + "\r\n";
                    if (vv.length == 2) {
                        optionvalue += vv[1] + "\r\n";
                    } else {
                        optionvalue += "\r\n";
                    }
                }
            });
            if (optionname.length > 0) {
                optionname = optionname.substring(0, optionname.length - 2);
            }
            if (optionvalue.length > 0) {
                optionvalue = optionvalue.substring(0, optionvalue.length - 2);
            }
            $("#optionname").val(optionname);
            $("#optionvalue").val(optionvalue);
        });

        function updateBeathInfo() {
            var optionname = $("#optionname").val();
            var optionvalue = $("#optionvalue").val();
            $("#<%= eListBox.ClientID %>").empty();
            var oo = optionname.replace("/\r\n/gi", "\n").split('\n');
            var vv = optionvalue.replace("/\r\n/gi", "\n").split('\n');
            for (var i = 0; i < oo.length; i++) {
                if (oo[i] != null && oo[i] != '') {
                    var url = oo[i] + '|' + (typeof (vv[i]) == "undefined" ? '' : vv[i]);
                    document.getElementById("<%= eListBox.ClientID %>").options[document.getElementById("<%= eListBox.ClientID %>").length] = new Option(url, url);
                }
            }
            $('#ly').click();
        }

        function lock(id) {
            var tt = document.body.scrollTop ? document.body.scrollTop : document.documentElement.scrollTop;
            var hh = jQuery(window).height();
            $("#" + id).css("left", (document.body.clientWidth - 500) / 2 + document.body.scrollLeft)
        .css("top", (tt + ((hh - 300) / 2)) + "px")
        .css("display", "block");
            $("#ly").css("display", "block")
        .css("width", document.body.clientWidth)
        .css("height", document.body.clientHeight)
        .unbind().click(function () { $("#" + id).hide(); $(this).hide(); });
            $(window.frames["ifly"].document).click(function () { if (document.getElementById('ly')) { jQuery('#ly').click(); } });
        }

        //移动窗口部份
        var posX, posY, fdiv;
        document.getElementById("OptionBeathTitle").onmousedown = moveFloatingDiv;
        function moveFloatingDiv(e) {
            if (!e) e = window.event;  //如果是IE
            fdiv = this.parentNode;
            posX = e.clientX - parseInt(fdiv.style.left);
            posY = e.clientY - parseInt(fdiv.style.top);
            document.onmousemove = mousemove;
        }

        document.onmouseup = function () {
            document.onmousemove = null;
        }

        function mousemove(ev) {
            if (ev == null) ev = window.event; //如果是IE
            fdiv.style.left = (ev.clientX - posX) + "px";
            fdiv.style.top = (ev.clientY - posY) + "px";
        }
    </script>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>显示选项使用：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadlChoiceType" runat="server">
                        <asp:ListItem Value="1" Selected="True">单选下拉列表框</asp:ListItem>
                        <asp:ListItem Value="2">多选列表框</asp:ListItem>
                        <asp:ListItem Value="3">单选按钮</asp:ListItem>
                        <asp:ListItem Value="4">复选框</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>允许“填充” 选项：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadlEnableFill" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtChoiceDefaultValue" Columns="60" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>每行显示项数：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtRepeatColumns" Text="1" runat="server"></asp:TextBox><asp:CompareValidator
                        ID="CompareValTxtRepeatColumns" ControlToValidate="TxtRepeatColumns" Display="Dynamic"
                        Operator="greaterThanEqual" Type="Integer" ValueToCompare="1" runat="server"
                        ErrorMessage="必须填写大于1的数字"></asp:CompareValidator><br />
                    <span style="color: Blue">只当类型为单选按钮或复选框时起作用</span>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlNumber" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>最小值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtNumberMinLength" runat="server" Text=""></asp:TextBox>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidator6" ControlToValidate="TxtNumberMinLength"
                        runat="server" Display="Dynamic">
                    </pe:RegexValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>最大值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtNumberMaxlength" runat="server" Text=""></asp:TextBox>
                    <asp:CompareValidator ID="ValcNumber" runat="server" ControlToCompare="TxtNumberMinLength"
                        ControlToValidate="TxtNumberMaxlength" ErrorMessage="CompareValidator" Operator="GreaterThan"
                        Type="Double" Display="Dynamic">最大值不能小于或等于最小值</asp:CompareValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidator5" ControlToValidate="TxtNumberMaxlength"
                        runat="server" Display="Dynamic">
                    </pe:RegexValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>小数位数：</strong>
                </td>
                <td align="left">
                    <asp:DropDownList ID="DropNumberDecimals" runat="server">
                        <asp:ListItem Value="-1" Selected="True">自动</asp:ListItem>
                        <asp:ListItem>0</asp:ListItem>
                        <asp:ListItem>1</asp:ListItem>
                        <asp:ListItem>2</asp:ListItem>
                        <asp:ListItem>3</asp:ListItem>
                        <asp:ListItem>4</asp:ListItem>
                        <asp:ListItem>5</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtNumberDefaultValue" Columns="60" runat="server"></asp:TextBox>
                    <asp:RegularExpressionValidator ID="RegularExpressionValidator3" runat="server" ControlToValidate="TxtNumberDefaultValue"
                        ErrorMessage="请输入正确的数字！" ValidationExpression="^-?[0-9]+(\.?[0-9]{1,4})?" Display="Dynamic"></asp:RegularExpressionValidator>
                    <br />
                    <asp:CheckBox ID="ChkNumberPercent" runat="server" />以百分比显示(例如：50%)
                </td>
            </tr>
        </tbody>
        <tbody id="PnlCurrency" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>最小值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtCurrencyMinLength" runat="server"></asp:TextBox>
                    <span style="color: Blue">例如：1.00</span>
                    <asp:RegularExpressionValidator ID="ValeCurrencyMinLength" runat="server" ControlToValidate="TxtCurrencyMinLength"
                        ErrorMessage="只能输入货币字符" ValidationExpression="^[1-9]+[0-9]*(\.?[0-9]+)?|0\.0*[1-9]+0*|[1-9]$"
                        Display="Dynamic"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>最大值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtCurrencyMaxLength" runat="server"></asp:TextBox>
                    <asp:CompareValidator ID="ValCurrency" runat="server" ErrorMessage="CompareValidator"
                        ControlToCompare="TxtCurrencyMinLength" ControlToValidate="TxtCurrencyMaxLength"
                        Operator="GreaterThan" Type="Double" Display="Dynamic">最大值不能小于或等于最小值</asp:CompareValidator>
                    <asp:RegularExpressionValidator ID="ValeCurrencyMaxLength" runat="server" ControlToValidate="TxtCurrencyMaxLength"
                        ErrorMessage="只能输入货币字符" ValidationExpression="^[1-9]+[0-9]*(\.?[0-9]+)?|0\.0*[1-9]+0*|[1-9]$"
                        Display="Dynamic"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtCurrencyDefaultValue" runat="server"></asp:TextBox>
                    <asp:RegularExpressionValidator ID="ValeCurrencyDefaultValue" runat="server" ControlToValidate="TxtCurrencyDefaultValue"
                        ErrorMessage="只能输入货币字符" ValidationExpression="^[1-9]+[0-9]*(\.?[0-9]+)?|0\.0*[1-9]+0*|[1-9]$"
                        Display="Dynamic"></asp:RegularExpressionValidator>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlDateTime" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>日期和时间格式：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadioDateTimeType" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="yyyy-MM-dd" Selected="True">仅日期</asp:ListItem>
                        <asp:ListItem Value="yyyy-MM-dd HH:mm:ss">日期和时间</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <table cellpadding="0" cellspacing="0">
                        <tr>
                            <td align="left">
                                <asp:RadioButtonList ID="RadlDateTimeDefaultType" runat="server">
                                    <asp:ListItem Value="0" Selected="True">无</asp:ListItem>
                                    <asp:ListItem Value="1">当前日期</asp:ListItem>
                                    <asp:ListItem Value="2">指定日期</asp:ListItem>
                                </asp:RadioButtonList>
                            </td>
                            <td align="right">
                                <br />
                                <br />
                                <br />
                                <pe:DatePicker ID="DpkDateTimeInputDefaultValue" runat="server"></pe:DatePicker>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlLookup" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>获取信息来自模型：</strong>
                </td>
                <td align="left">
                    <asp:DropDownList ID="DropLookupTable" runat="server" OnSelectedIndexChanged="DropLookupTable_SelectedIndexChanged"
                        AutoPostBack="True">
                    </asp:DropDownList>
                    <pe:RequiredFieldValidator ID="ReqLookupTable" ControlToValidate="DropLookupTable"
                        runat="server" ErrorMessage="获取信息来自模型不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>在此模型对应信息表的字段：</strong>
                </td>
                <td align="left">
                    <asp:DropDownList ID="DropLookupField" runat="server">
                    </asp:DropDownList>
                    <pe:RequiredFieldValidator ID="ReqLookupField" ControlToValidate="DropLookupField"
                        runat="server" ErrorMessage="模型对应信息表的字段不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                    <br />
                    <span style="color: Red">注：查阅项的字段只能是存在选定的模型对应表里面的单行文本字段</span>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlURL" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>最大字符数：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtURLMaxLength" runat="server" Columns="5" Text="200"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ValeTxtURLMaxLength" ControlToValidate="TxtURLMaxLength"
                        runat="server" ErrorMessage="最大字符数不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                    <asp:RangeValidator ID="ValgURLMaxLength" Type="Integer" ControlToValidate="TxtURLMaxLength"
                        runat="server" ErrorMessage="超出数据范围！" Display="Dynamic" MaximumValue="255" MinimumValue="1"></asp:RangeValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>文本框长度：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtURLSize" Text="80" runat="server" Columns="5"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ValeTxtURLSize" ControlToValidate="TxtURLSize" runat="server"
                        ErrorMessage="文本框长度不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                    <asp:RangeValidator ID="ValigURLSize" Type="Integer" ControlToValidate="TxtURLMaxLength"
                        runat="server" ErrorMessage="超出数据范围！" Display="Dynamic" MaximumValue="255" MinimumValue="1"></asp:RangeValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtURLDefaultValue" Columns="60" runat="server"></asp:TextBox>
                    <span style="color: green">例：http://127.0.0.1/ </span>
                    <pe:RegexValidator ValidateType="Url" ID="VurlURLDefaultValue" ControlToValidate="TxtURLDefaultValue"
                        runat="server"></pe:RegexValidator>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlBoolean" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:DropDownList ID="DropBoolean" runat="server">
                        <asp:ListItem Value="True" Selected="True">是</asp:ListItem>
                        <asp:ListItem Value="False">否</asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlImage" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>图片文本框长度：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtImageTextLength" Text="30" runat="server" Columns="5"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ValrImageTextLength" ControlToValidate="TxtImageTextLength"
                        runat="server" ErrorMessage="文本框长度不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                    <asp:RangeValidator ID="ValgImageTextLength" ControlToValidate="TxtImageTextLength"
                        Type="Integer" runat="server" ErrorMessage="超出数据范围！" Display="Dynamic" MaximumValue="250"
                        MinimumValue="1"></asp:RangeValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>是否启用上传：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadlIsUpload" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True" Selected="True">是</asp:ListItem>
                        <asp:ListItem Value="False">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg" id="ImageSize">
                <td class="tdbgleft">
                    <strong>允许的图片大小：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtImageSize" Text="1024" runat="server" Columns="6" MaxLength="12"></asp:TextBox>
                    KB <span style="color: Blue">提示：1 KB = 1024 Byte，1 MB = 1024 KB</span>
                    <pe:RequiredFieldValidator ID="ValrImageSize" runat="server" ControlToValidate="TxtImageSize"
                        Display="Dynamic" ErrorMessage="允许的图片大小不能为空"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidator2" ControlToValidate="TxtImageSize"
                        runat="server" Display="Dynamic">
                    </pe:RegexValidator>
                </td>
            </tr>
            <tr class="tdbg" id="ImageType">
                <td class="tdbgleft">
                    <strong>允许的图片类型：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TextImageType" runat="server" Columns="30"></asp:TextBox>
                    <span style="color: Blue">注：允许多个类型请用“|”号分割，如：jpg|gif|bmp等等</span>
                    <pe:RequiredFieldValidator ID="ValrTextImageType" runat="server" ControlToValidate="TextImageType"
                        Display="Dynamic" ErrorMessage="图片类型不能为空"></pe:RequiredFieldValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>上传文件名保存规则：</strong><br />
                    <span style="color: Red">可用变量： </span>
                    <br />
                    <span style="color: Blue">{$Year}：年份、{$Month}：月份<br />
                        {$Day}：日期、{$Hour}：小时<br />
                        {$Minute}：分钟、{$Second}：秒<br />
                        {$Origin}：原文件名、{$Random}：随机数</span>
                </td>
                <td>
                    <pe:ComboBox ID="TxtImageNameRule" Width="300" runat="server">
                        <Items>
                            <asp:ListItem>{$Random}</asp:ListItem>
                            <asp:ListItem>{$Year}{$Month}{$Day}{$Hour}{$Minute}{$Second}</asp:ListItem>
                            <asp:ListItem>{$Hour}{$Minute}{$Second}</asp:ListItem>
                            <asp:ListItem>{$Origin}</asp:ListItem>
                        </Items>
                    </pe:ComboBox>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="TxtImageNameRule"
                        ErrorMessage="文件名只能以字母、数字、下划线及可用变量组成，不能为空"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr class="tdbg" id="IsFromSelected">
                <td class="tdbgleft">
                    <strong>是否从系统已上传图片中选择：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadlIsFromSelected" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg" id="UploadFiles" runat="server" style="display: none;">
                <td class="tdbgleft">
                    <strong>是否从信息已上传图片中选择：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadlUploadFiles" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg" id="WsImage">
                <td class="tdbgleft">
                    <strong>图片是否加水印：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadlWsImage" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg" id="Thumb">
                <td class="tdbgleft">
                    <strong>是否上传缩略图：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadlThumb" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg" id="PicDefaultUrl">
                <td class="tdbgleft">
                    <strong>默认图片：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtPicDefaultUrl" Columns="60" runat="server"></asp:TextBox>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlFile" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>是否为下载频道控件：</strong>
                </td>
                <td align="left">
                    <asp:CheckBox ID="ChkDownLoadUrl" Checked="true" runat="server" />
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>保存文件大小设置：</strong>
                </td>
                <td align="left">
                    是否保存文件大小：<asp:CheckBox ID="ChkSoftSize" Checked="true" runat="server" Text="" AutoPostBack="true" OnCheckedChanged="ChkSoftSize_OnCheckedChanged" /><br />
                    保存字段的名称：<asp:TextBox ID="TxtFileSizeField" runat="server" Width="80px" MaxLength="30"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ValrFileSizeField" runat="server" ControlToValidate="TxtFileSizeField"
                        Display="Dynamic" ErrorMessage="保存字段的名称不能为空"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Field" ControlToValidate="TxtFileSizeField" Display="Dynamic"
                        ID="FieldValidator4" runat="server"></pe:RegexValidator>
                    <asp:CompareValidator ID="ValcFileSizeField" runat="server" Display="Dynamic" ErrorMessage="保存文件大小的字段名不能与主字段名重复！"
                        ControlToValidate="TxtFileSizeField" ControlToCompare="TxtFieldName" Operator="NotEqual"
                        SetFocusOnError="True"></asp:CompareValidator>
                    <br />
                    <span style="color: Blue">注：字段名由字母、数字、下划线组成，并且仅能字母开头，不以下划线结尾。 例如：Content</span>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>允许的文件大小：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtFileSize" Text="1024" runat="server" Columns="6" MaxLength="12"></asp:TextBox>
                    KB <span style="color: Blue">提示：1 KB = 1024 Byte，1 MB = 1024 KB</span>
                    <pe:RequiredFieldValidator ID="ValrFileSize" runat="server" ControlToValidate="TxtFileSize"
                        Display="Dynamic" ErrorMessage="文件大小不能为空"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidator1" ControlToValidate="TxtFileSize"
                        runat="server" Display="Dynamic">
                    </pe:RegexValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>允许的文件类型：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TextFileType" runat="server"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ValrFileType" runat="server" ControlToValidate="TextFileType"
                        Display="Dynamic" ErrorMessage="文件类型不能为空"></pe:RequiredFieldValidator>
                    <span style="color: Blue">注：允许多个类型请用“|”号分割，如：jpg|mp3|gif|rm|rmvb等等</span>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>上传文件名保存规则：</strong><br />
                    <span style="color: Red">可用变量： </span>
                    <br />
                    <span style="color: Blue">{$Year}：年份、{$Month}：月份<br />
                        {$Day}：日期、{$Hour}：小时<br />
                        {$Minute}：分钟、{$Second}：秒<br />
                        {$Origin}：原文件名、{$Random}：随机数</span>
                </td>
                <td>
                    <pe:ComboBox ID="TxtFileNameRule" Width="300" runat="server">
                        <Items>
                            <asp:ListItem>{$Random}</asp:ListItem>
                            <asp:ListItem>{$Year}{$Month}{$Day}{$Hour}{$Minute}{$Second}</asp:ListItem>
                            <asp:ListItem>{$Hour}{$Minute}{$Second}</asp:ListItem>
                            <asp:ListItem>{$Origin}</asp:ListItem>
                        </Items>
                    </pe:ComboBox>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ControlToValidate="TxtFileNameRule"
                        ErrorMessage="文件名只能以字母、数字、下划线及可用变量组成，不能为空"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>地址前缀：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtFileUrlPrdfix" runat="server" Width="349px">下载地址</asp:TextBox>
                    <br />
                    <span style="color: Green">例：下载地址</span>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtFileDefaultValue" runat="server" Width="349px"></asp:TextBox>
                    <br />
                    <span style="color: Green">例：下载地址1|http://127.0.0.1/UploadFile/Soft/2007/2/moivename.rmvb</span>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlColor" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认颜色值：</strong>
                </td>
                <td align="left">
                    <pe:XColorPicker ID="CpkColorDefault" runat="server"></pe:XColorPicker>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlAuthor" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>文本框长度：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtAuthorSize" Text="50" runat="server" Columns="5"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="RequiredFieldValidatorAuthor" ControlToValidate="TxtAuthorSize"
                        runat="server" ErrorMessage="文本框长度不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidatorAuthor" ControlToValidate="TxtAuthorSize"
                        runat="server" Display="Dynamic"></pe:RegexValidator>
                    <asp:RangeValidator ID="ValrAuthorSize" ControlToValidate="TxtAuthorSize" Type="Integer"
                        runat="server" ErrorMessage="不能超过200字符长度！" Display="Dynamic" MaximumValue="200"
                        MinimumValue="1"></asp:RangeValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtAuthorDefaultValue" Columns="60" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>是否保存上次记录：</strong><br />
                    启用保存上次记录,下次添加信息时会自动出现上次填写值
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadAuthorIsPCookie" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlSource" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>文本框长度：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtSourceSize" Text="50" runat="server" Columns="5"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="RequiredFieldValidatorSource" ControlToValidate="TxtSourceSize"
                        runat="server" ErrorMessage="文本框长度不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidatorSource" ControlToValidate="TxtSourceSize"
                        runat="server" Display="Dynamic"></pe:RegexValidator>
                    <asp:RangeValidator ID="ValrSourceSize" ControlToValidate="TxtSourceSize" Type="Integer"
                        runat="server" ErrorMessage="不能超过200字符长度！" Display="Dynamic" MaximumValue="200"
                        MinimumValue="1"></asp:RangeValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtSourceDefaultValue" Columns="60" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>是否保存上次记录：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadSourceIsPCookie" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlKeyword" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>文本框长度：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtKeywordSize" Text="50" runat="server" Columns="5"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="RequiredFieldValidatorKeyword" ControlToValidate="TxtKeywordSize"
                        runat="server" ErrorMessage="文本框长度不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidatorKeyword" ControlToValidate="TxtKeywordSize"
                        runat="server" Display="Dynamic"></pe:RegexValidator>
                    <asp:RangeValidator ID="ValrKeywordSize" ControlToValidate="TxtKeywordSize" Type="Integer"
                        runat="server" ErrorMessage="不能超过200字符长度！" Display="Dynamic" MaximumValue="200"
                        MinimumValue="1"></asp:RangeValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtKeywordDefaultValue" Columns="60" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>是否保存上次记录：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadKeywordIsPCookie" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlOperatingSystem" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>分行键入&nbsp;&nbsp;<br />
                        每个平台选项：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtOperatingSystemSelectItem" runat="server" Height="100px" TextMode="MultiLine"
                        Width="300px" Wrap="false"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="RequiredFieldValidatorOperatingSystem" runat="server"
                        ControlToValidate="TxtOperatingSystemSelectItem" Display="Dynamic" ErrorMessage="分行默认项不能为空"></pe:RequiredFieldValidator>
                    <span style="color: blue">注：一行一个默认项</span>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>文本框长度：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtOperatingSystemSize" Text="50" runat="server" Columns="5"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="RequiredFieldValidator1" ControlToValidate="TxtOperatingSystemSize"
                        runat="server" ErrorMessage="文本框长度不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidatorOperatingSystem" ControlToValidate="TxtOperatingSystemSize"
                        runat="server" Display="Dynamic"></pe:RegexValidator>
                    <asp:RangeValidator ID="ValrOperatingSystemSize" ControlToValidate="TxtOperatingSystemSize"
                        Type="Integer" runat="server" ErrorMessage="不能超过200字符长度！" Display="Dynamic" MaximumValue="200"
                        MinimumValue="1"></asp:RangeValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtOperatingSystemDefaultValue" Columns="60" runat="server"></asp:TextBox>
                    <span style="color: green">例：Win2000/XP/Win2003</span>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>是否保存上次记录：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadOperatingIsPCookie" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlProducer" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>文本框长度：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtProducerSize" Text="50" runat="server" Columns="5"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="RequiredFieldValidatorProducer" ControlToValidate="TxtProducerSize"
                        runat="server" ErrorMessage="文本框长度不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidatorProducer" ControlToValidate="TxtProducerSize"
                        runat="server" Display="Dynamic"></pe:RegexValidator>
                    <asp:RangeValidator ID="RangeValidatorProducer" ControlToValidate="TxtProducerSize"
                        Type="Integer" runat="server" ErrorMessage="不能超过200字符长度！" Display="Dynamic" MaximumValue="200"
                        MinimumValue="1"></asp:RangeValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtProducerDefaultValue" Columns="60" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>是否保存上次记录：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadProducerIsPCookie" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlTrademark" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>文本框长度：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtTrademarkSize" Text="50" runat="server" Columns="5"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="RequiredFieldValidatorTrademark" ControlToValidate="TxtTrademarkSize"
                        runat="server" ErrorMessage="文本框长度不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidatorTrademark" ControlToValidate="TxtTrademarkSize"
                        runat="server" Display="Dynamic"></pe:RegexValidator>
                    <asp:RangeValidator ID="RangeValidatorTrademark" ControlToValidate="TxtTrademarkSize"
                        Type="Integer" runat="server" ErrorMessage="不能超过200字符长度！" Display="Dynamic" MaximumValue="200"
                        MinimumValue="1"></asp:RangeValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtTrademarkDefaultValue" Columns="60" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>是否保存上次记录：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadTrademarkIsPCookie" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlContent" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>编辑器大小：</strong>
                </td>
                <td align="left">
                    宽
                    <asp:TextBox ID="TxtContentEditorWidth" Text="600" runat="server" Columns="5"></asp:TextBox>
                    <span style="color: Blue">px&nbsp;例如：600px</span>
                    <pe:RequiredFieldValidator ID="ValrContentEditorWidth" runat="server" ControlToValidate="TxtContentEditorWidth"
                        Display="Dynamic" ErrorMessage="显示宽度不能为空"></pe:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="TxtContentEditorWidth"
                        ErrorMessage="只能输入字母数字百分号" ValidationExpression="^[a-zA-Z%0-9]*$" Display="Dynamic"></asp:RegularExpressionValidator>
                    <br />
                    高
                    <asp:TextBox ID="TxtContentEditorHight" Text="500" runat="server" Columns="5"></asp:TextBox>
                    <span style="color: Blue">px&nbsp;例如：350px</span>
                    <pe:RequiredFieldValidator ID="ValrContentEditorHight" runat="server" ControlToValidate="TxtContentEditorHight"
                        Display="Dynamic" ErrorMessage="显示高度不能为空"></pe:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="RegularExpressionValidator2" runat="server" ControlToValidate="TxtContentEditorHight"
                        ErrorMessage="只能输入字母数字百分号" ValidationExpression="^[a-zA-Z%0-9]*$" Display="Dynamic"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>允许的文件大小：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtUploadSize" Text="" runat="server" Columns="6" MaxLength="12"></asp:TextBox>
                    KB <span style="color: Blue">提示：1 KB = 1024 Byte，1 MB = 1024 KB</span>
                    <pe:RequiredFieldValidator ID="ValrTxtUploadSize" runat="server" ControlToValidate="TxtUploadSize"
                        Display="Dynamic" ErrorMessage="文件大小不能为空"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidator4" ControlToValidate="TxtUploadSize"
                        runat="server" Display="Dynamic">
                    </pe:RegexValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>允许上传的图片类型：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TextUploadImpType" runat="server" Text="jpg|gif|jpeg|png|bmp"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ValrUploadImpType" runat="server" ControlToValidate="TextUploadImpType"
                        Display="Dynamic" ErrorMessage="图片类型不能为空"></pe:RequiredFieldValidator>
                    <span style="color: Blue">注：允许多个类型请用“|”号分割，如：jpg|gif|jpeg|png|bmp等等</span>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>允许上传的媒体类型：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TextUploadFlashType" runat="server" Text="swf|flv|rm|rmvb|mp3|mpeg|avi|mpeg2|wmv|midi"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ValrUploadFlashType" runat="server" ControlToValidate="TextUploadFlashType"
                        Display="Dynamic" ErrorMessage="Flash类型不能为空"></pe:RequiredFieldValidator>
                    <span style="color: Blue">注：允许多个类型请用“|”号分割，如：swf|flv|rm|rmvb|mp3|mpeg|avi|mpeg2|wmv|midi等等</span>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>允许上传的附件类型：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TextUploadAnnexType" runat="server" Text="txt|doc|rar|zip"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ValrUploadAnnexType" runat="server" ControlToValidate="TextUploadAnnexType"
                        Display="Dynamic" ErrorMessage="附件类型不能为空"></pe:RequiredFieldValidator>
                    <span style="color: Blue">注：允许多个类型请用“|”号分割，如：txt|doc|rar|zip等等</span>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>上传文件名保存规则：</strong><br />
                    <span style="color: Red">可用变量： </span>
                    <br />
                    <span style="color: Blue">{$Year}：年份、{$Month}：月份<br />
                        {$Day}：日期、{$Hour}：小时<br />
                        {$Minute}：分钟、{$Second}：秒<br />
                        {$Origin}：原文件名、{$Random}：随机数</span>
                </td>
                <td>
                    <pe:ComboBox ID="TxtContentFileNameRule" Width="300" runat="server">
                        <Items>
                            <asp:ListItem>{$Random}</asp:ListItem>
                            <asp:ListItem>{$Year}{$Month}{$Day}{$Hour}{$Minute}{$Second}</asp:ListItem>
                            <asp:ListItem>{$Hour}{$Minute}{$Second}</asp:ListItem>
                            <asp:ListItem>{$Origin}</asp:ListItem>
                        </Items>
                    </pe:ComboBox>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator5" runat="server" ControlToValidate="TxtContentFileNameRule"
                        ErrorMessage="文件名只能以字母、数字、下划线及可用变量组成，不能为空"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>图片是否加水印：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadlContentWsImage" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>是否上传缩略图：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadlContentThumb" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlVirtualLink" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>显示的宽度：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtVirtualLinkWidth" Text="500" runat="server" Columns="5"></asp:TextBox>
                    <span style="color: Blue">px &nbsp;例如：500px</span>
                    <pe:RequiredFieldValidator ID="RequiredFieldValidatorVirtualLinkWidth" runat="server"
                        ControlToValidate="TxtVirtualLinkWidth" Display="Dynamic" ErrorMessage="显示宽度不能为空"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidatorVirtualLinkWidth" ControlToValidate="TxtVirtualLinkWidth"
                        runat="server">
                    </pe:RegexValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>显示的高度：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtVirtualLinkRow" Text="80" runat="server" Columns="5"></asp:TextBox>
                    <span style="color: Blue">px &nbsp;例如：80px</span>
                    <pe:RequiredFieldValidator ID="RequiredFieldValidatorVirtualLinkRow" runat="server"
                        ControlToValidate="TxtVirtualLinkRow" Display="Dynamic" ErrorMessage="显示高度不能为空"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidatorVirtualLinkRow" ControlToValidate="TxtVirtualLinkRow"
                        runat="server">
                    </pe:RegexValidator>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlDownServer" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>文本框长度：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtDownServerWidth" Text="50" runat="server" Columns="5"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="RequiredFieldValidatorDownServerWidth" ControlToValidate="TxtDownServerWidth"
                        runat="server" ErrorMessage="文本框长度不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidatorDownServerWidth" ControlToValidate="TxtDownServerWidth"
                        runat="server" Display="Dynamic"></pe:RegexValidator>
                    <asp:RangeValidator ID="RangeValidatorDownServerWidth" ControlToValidate="TxtDownServerWidth"
                        Type="Integer" runat="server" ErrorMessage="不能超过100字符长度！" Display="Dynamic" MaximumValue="1000"
                        MinimumValue="1"></asp:RangeValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtDownServerDefaultValue" runat="server" Width="276px"></asp:TextBox>
                    <span style="color: green">例：$$$下载服务器名|下载服务器ID</span>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>是否保存上次记录：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadDownServerIsPCookie" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlRegion" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>排列方式：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadRegionDirection" runat="server" RepeatDirection="Horizontal"
                        AutoPostBack="true" OnSelectedIndexChanged="RadRegionDirection_SelectedIndexChanged">
                        <asp:ListItem Value="true">横向</asp:ListItem>
                        <asp:ListItem Value="false" Selected="True">纵向</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>显示方式：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadRegionShow" runat="server" RepeatDirection="Vertical"
                        AutoPostBack="True" OnSelectedIndexChanged="RadRegionShow_SelectedIndexChanged">
                        <asp:ListItem Value="1">国家+省</asp:ListItem>
                        <asp:ListItem Value="2">国家+省+市</asp:ListItem>
                        <asp:ListItem Value="3" Selected="True">国家+省+市+县</asp:ListItem>
                        <asp:ListItem Value="4">省+市</asp:ListItem>
                        <asp:ListItem Value="5">省+市+县</asp:ListItem>
                        <asp:ListItem Value="6">市+县</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>显示方式默认设置：</strong>
                </td>
                <td align="left">
                    <pec:RegionType ID="RegionType" runat="server" />
                </td>
            </tr>
        </tbody>
        <tbody id="PnlSpecial" visible="false" runat="server">
        </tbody>
        <tbody id="PnlTitle" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>最大字符数：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtTitleMaxLength" Text="200" runat="server" Columns="5"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="RequiredFieldValidatorTitleMaxLength" ControlToValidate="TxtTitleMaxLength"
                        runat="server" ErrorMessage="最大字符数不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                    <asp:RangeValidator ID="RangeValidatorTitleMaxLength" ControlToValidate="TxtTitleMaxLength"
                        runat="server" ErrorMessage="超出数据范围！" Type="Integer" Display="Dynamic" MaximumValue="255"
                        MinimumValue="1"></asp:RangeValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>文本框长度：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtTitleSize" Text="30" runat="server" Columns="5"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="RequiredFieldValidatorTitleSize" ControlToValidate="TxtTitleSize"
                        runat="server" ErrorMessage="文本框长度不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                    <asp:RangeValidator ID="RangeValidatorTitleSize" ControlToValidate="TxtTitleSize"
                        Type="Integer" runat="server" ErrorMessage="超出数据范围！" Display="Dynamic" MaximumValue="250"
                        MinimumValue="1"></asp:RangeValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtTitleDefaultValue" runat="server" Width="276px"></asp:TextBox>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>是否启用检测重复值：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadCheckTitleValue" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>是否自动生成字母标题：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadCreatePinyinTitle" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlMultiplePhoto" visible="false" runat="server">
            <%--<script type="text/javascript">
                function SetMPExtendedListBox(id) { 
                    if(document.getElementById(id + "_0").checked == true) {
                        document.getElementById("MPUpOrderBtnValueTr").style.display = '';
                        document.getElementById("MPDownOrderBtnValueTr").style.display = '';
                    }
                    else {
                        document.getElementById("MPUpOrderBtnValueTr").style.display = 'none';
                        document.getElementById("MPDownOrderBtnValueTr").style.display = 'none';
                    }
                }
            </script>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>是否启用排序</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RblMPEnableOrder" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg" id="MPUpOrderBtnValueTr" style="display:none">
                <td class="tdbgleft">
                    <strong>向上排序默认值</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtMPUpOrderBtnValue" Columns="60" runat="server"></asp:TextBox><br />
                    <span style="color: Blue">注：向上排序按钮的默认值</span>
                </td>
            </tr>
            <tr class="tdbg" id="MPDownOrderBtnValueTr" style="display:none">
                <td class="tdbgleft">
                    <strong>向下排序默认值</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtMPDownOrderBtnValue" Columns="60" runat="server"></asp:TextBox><br />
                    <span style="color: Blue">注：向下排序按钮的默认值</span>
                </td>
            </tr>--%>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>图片是否加水印：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadlMWsImage" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>允许的文件大小：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtMultiPhotoSize" Text="1024" runat="server" Columns="6" MaxLength="12"></asp:TextBox>
                    KB <span style="color: Blue">提示：1 KB = 1024 Byte，1 MB = 1024 KB</span>
                    <pe:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtMultiPhotoSize"
                        Display="Dynamic" ErrorMessage="文件大小不能为空"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumberValidator3" ControlToValidate="TxtMultiPhotoSize"
                        runat="server" Display="Dynamic">
                    </pe:RegexValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>允许的文件类型：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtMultiPhotoExt" runat="server"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ReqTxtMultiPhotoExt" runat="server" ControlToValidate="TxtMultiPhotoExt"
                        Display="Dynamic" ErrorMessage="文件类型不能为空"></pe:RequiredFieldValidator>
                    <span style="color: Blue">注：允许多个类型请用“|”号分割，如：jpg|mp3|gif|rm|rmvb等等</span>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>上传文件名保存规则：</strong><br />
                    <span style="color: Red">可用变量： </span>
                    <br />
                    <span style="color: Blue">{$Year}：年份、{$Month}：月份<br />
                        {$Day}：日期、{$Hour}：小时<br />
                        {$Minute}：分钟、{$Second}：秒<br />
                        {$Origin}：原文件名、{$Random}：随机数</span>
                </td>
                <td>
                    <pe:ComboBox ID="TxtMultiPhotoFileNameRule" Width="300" runat="server">
                        <Items>
                            <asp:ListItem>{$Random}</asp:ListItem>
                            <asp:ListItem>{$Year}{$Month}{$Day}{$Hour}{$Minute}{$Second}</asp:ListItem>
                            <asp:ListItem>{$Hour}{$Minute}{$Second}</asp:ListItem>
                            <asp:ListItem>{$Origin}</asp:ListItem>
                        </Items>
                    </pe:ComboBox>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator6" runat="server" ControlToValidate="TxtMultiPhotoFileNameRule"
                        ErrorMessage="文件名只能以字母、数字、下划线及可用变量组成，不能为空"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtMultiPhotoDefaultValue" runat="server" Width="281px"></asp:TextBox><br />
                    <span style="color: Green">例：图片地址1|Photo/2007/12/2007122209084503640.jpg</span>
                </td>
            </tr>
            <%--<script type="text/javascript">
                SetMPExtendedListBox('<%=RblMPEnableOrder.ClientID %>');
            </script>--%>
        </tbody>
        <tbody id="PnlProperty" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft" style="width: 180px">
                    <asp:Label ID="LblProperty" runat="server" Font-Bold="True" Text="商品属性值："></asp:Label>&nbsp;
                </td>
                <td align="left" class="tdbg">
                    <asp:TextBox ID="TxtProperty" runat="server" Height="100px" TextMode="MultiLine"
                        Width="300px" Wrap="false"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ValrProperty" runat="server" ControlToValidate="TxtProperty"
                        Display="Dynamic" ErrorMessage="商品属性值不能为空"></pe:RequiredFieldValidator>
                    <br />
                    <asp:Label ID="LblPropertyDesc" runat="server" Text="注：(1)商品属性值之间以“回车”分隔，属性值中不能带有半角的“$”、“|”、“*”字符！"
                        ForeColor="Blue"></asp:Label>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlSelectUser" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>文本框长度：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtSelectUserSize" Text="50" runat="server" Columns="5"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ReqSelectUser" ControlToValidate="TxtSelectUserSize"
                        runat="server" ErrorMessage="文本框长度不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ValidateType="Number" ID="NumValSelectUserSize" ControlToValidate="TxtSelectUserSize"
                        runat="server" Display="Dynamic"></pe:RegexValidator>
                    <asp:RangeValidator ID="RangeValSelectUserSize" ControlToValidate="TxtSelectUserSize"
                        Type="Integer" runat="server" ErrorMessage="不能超过200字符长度！" Display="Dynamic" MaximumValue="200"
                        MinimumValue="1"></asp:RangeValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtSelectUserDefault" Columns="60" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>是否保存上次记录：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadSelectUserIsPCookie" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
        </tbody>
		<tbody id="PnlHouseType" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>设置户型默认值：</strong>
                </td>
                <td align="left">
                    <pec:HouseType ID="HouseType" runat="server" />
                </td>
            </tr>
        </tbody>
         <tbody id="PnlMultiplePhotoViewType" visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>图片是否加水印：</strong>
                </td>
                <td align="left">
                    <asp:RadioButtonList ID="RadlViewWsImage" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="True">是</asp:ListItem>
                        <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>允许的文件大小：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtViewFileSize" Text="1024" runat="server" Columns="6" MaxLength="6"></asp:TextBox>
                    KB <span style="color: Blue">提示：1 KB = 1024 Byte，1 MB = 1024 KB</span>
                    <pe:RequiredFieldValidator ID="ReqViewFileSize" runat="server" ControlToValidate="TxtViewFileSize"
                        Display="Dynamic" ErrorMessage="文件大小不能为空"></pe:RequiredFieldValidator>
                    <pe:RegexValidator ID="NumberValidator7" runat="server" ValidateType="Number" Display="Dynamic" ControlToValidate="TxtViewFileSize"></pe:RegexValidator>
                    
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>允许的文件类型：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtViewFileType" runat="server"></asp:TextBox>
                    <pe:RequiredFieldValidator ID="ReqViewFileType" runat="server" ControlToValidate="TxtViewFileType"
                        Display="Dynamic" ErrorMessage="文件类型不能为空"></pe:RequiredFieldValidator>
                    <span style="color: Blue">注：允许多个类型请用“|”号分割，如：gif|png|jpeg|jpg|gif|bmp等等</span>
                </td>
            </tr>
            <tr class="tdbg">
            <td class="tdbgleft">
                <strong>上传文件名保存规则：</strong><br />
                <span style="color: Red">可用变量： </span>
                <br />
                <span style="color: Blue">{$Year}：年份、{$Month}：月份<br />
                    {$Day}：日期、{$Hour}：小时<br />
                    {$Minute}：分钟、{$Second}：秒<br />
                    {$Origin}：原文件名、{$Random}：随机数</span>
            </td>
            <td>
                <pe:ComboBox ID="TxtImageViewNameRule" Width="300" runat="server">
                    <Items>
                        <asp:ListItem>{$Random}</asp:ListItem>
                        <asp:ListItem>{$Year}{$Month}{$Day}{$Hour}{$Minute}{$Second}</asp:ListItem>
                        <asp:ListItem>{$Hour}{$Minute}{$Second}</asp:ListItem>
                        <asp:ListItem>{$Origin}</asp:ListItem>
                    </Items>
                </pe:ComboBox>
                <asp:RequiredFieldValidator ID="ReqImageViewNameRule" runat="server" ControlToValidate="TxtImageViewNameRule" ErrorMessage="文件名只能以字母、数字、下划线及可用变量组成，不能为空"></asp:RequiredFieldValidator>
            </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>默认值：</strong>
                </td>
                <td align="left">
                    <asp:TextBox ID="TxtViewDefaultValue" runat="server" Width="281px"></asp:TextBox><br />
                    <span style="color: Green">例：图片1|Photo/2007/12/2007122209084503640.jpg</span>
                </td>
            </tr>
        </tbody>
        <tbody id="PnlLinkage" runat="server" visible="false">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>设置联动项：</strong>
                </td>
                <td align="left" style="width:70%">
                    <div style="margin:5px 15px;">
                        <input id="BtnAdd" type="button" value="添加联动" />
                    </div>
                    <div style="margin:5px 0px;display:inline;">
                        <ul id="Linkage">
                            <li id="1" style="float:left;width:335px;list-style:none;margin-bottom:5px;">  
                                <div style="float:left;">
                                    <select size='4' style='width:235px;height:120px;'></select>
                                </div>
                                <div style="float:left; height:22px; padding-top:98px">
                                    <input type='button' value='移除项' onclick='RemoveValue(1);'/>
                                </div>
                                <input type="text" class="inputtext" value="选项名称1|选项值" style="width:233px" id="lk-1" /><input type='button' value='添加项' onclick='AddOption(1);'/>
                            </li>
                        </ul>
                    </div>
                    <div style="clear:both;margin:15px;"><span style="color:Green;">提示</span>：双击选项可修改选项值</div>
                    <asp:HiddenField ID="HdnLinkageValue" runat="server" Value="[]" />
                    <script type="text/javascript">
                        var date = $("#<%=HdnLinkageValue.ClientID %>").val();
                        $(function() {
                            $("#BtnAdd").click(function() { AddLinkage(); date += "|[]"; });
                            $("#1 select").click(function() {
                                BindLinkage(1);
                            }).dblclick(function() {
                                var index = $(this).get(0).selectedIndex;
                                if (index > -1) {
                                    ModifyOption($(this));
                                }
                            });
                            $("#<%=DropLinkageSplit.ClientID %>").change(function() {
                                $("#SpnExample span").html($(this).val());
                            });
                            InitLinkage();
                        });

                        function InitLinkage() {
                            var array = date.split("|");
                            var arrValue = $("#<%=HdnLinkageDefault.ClientID %>").val().split("|");
                            for (var i = 0; i < array.length; i++) {
                                var id = i + 1;
                                var objJson = eval("(" + array[i] + ")");
                                if (id == 1) {
                                    for (var p1 in objJson) {
                                        var temp = objJson[p1].key + "|" + objJson[p1].value;
                                        AddValue(1, temp, temp);
                                    }
                                } else {
                                    if ($("#" + id).length == 0) {
                                        AddLinkage();
                                    }
                                }
                            }

                            $("#SpnExample span").html($("#<%=DropLinkageSplit.ClientID %>").val());
                            if ($("#<%=ChkLinkageDefault.ClientID %>").attr("checked")) {
                                for (var i = 0; i < array.length; i++) {
                                    if (i < arrValue.length) {
                                        if (i > 0) {
                                            BindLinkage(i);
                                        }

                                        var temp = eval("(" + array[i] + ")");
                                        for (var j in temp) {
                                            if (i == 0) {
                                                if (temp[j].value == arrValue[i]) {
                                                    $("#" + (i + 1) + " select").val(temp[j].key + "|" + temp[j].value);
                                                }
                                            } else {
                                            for (var k in temp[j].value) {
                                                    if (temp[j].value[k].value == arrValue[i]) {
                                                        $("#" + (i + 1) + " select").val(temp[j].value[k].key + "|" + temp[j].value[k].value);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }

                        // 添加联动项
                        function AddLinkage() {
                            var id = $("#Linkage li").length + 1;
                            var text = "<li id='" + id + "' style='float:left;width:335px;list-style:none;margin-bottom:5px;'>";
                            text += "<div style='float:left'><select size='4' style='width:235px;height:120px;'></select></div><div style='float:left; height:64px; padding-top:56px'><br/><input type='button' value='移除项' onclick='RemoveValue(" + id + ");' class='inputbutton'/><br/><input type='button' value='删除联动' onclick='DeleteLinkage(" + id + ");' class='inputbutton'/></div><input type='text' value='选项名称1|选项值' class='inputtext' style='width:233px' id='lk-"+id+"' /><input type='button' value='添加项' onclick='AddOption(" + id + ");' class='inputbutton'/></li>";
                            $(text).find("select").click(function() { BindLinkage(id); }).end().appendTo("#Linkage");
                            $("#" + id + " select").dblclick(function() {
                                var index = $(this).get(0).selectedIndex;
                                if (index > -1) {
                                    ModifyOption($(this));
                                }
                            });
                            
                            Save();
                        }

                        function DeleteLinkage(id) {
                            if (confirm("确定删除此项？关联项将一起被删除。")) {
                                $("#" + id).nextAll().remove().end().remove();
                            }

                            var val = "";
                            var tempArray = date.split("|");
                            for (var i = 0; i < $("#Linkage li select").length; i++) {
                                if (val != "") {
                                    val += "|";
                                }

                                val += tempArray[i];
                            }

                            date = val;
                            Save();
                        }

                        // 绑定列表
                        function BindLinkage(id) {
                            if ($("#" + id).next().length > 0) {
                                var nextId = "#" + (id + 1);
                                if ($("#" + id + " select").get(0).selectedIndex != -1) {
                                    var selectValue = $("#" + id + " select").val().split("|")[0];
                                    var obj = eval("(" + date.split("|")[id] + ")");
                                    $(nextId + " select option").each(function() { $(this).remove(); });
                                    var value = Traversal($("#" + id + " select").val().split("|")[0], eval("(" + date.split("|")[id] + ")"));
                                    for (var index in value) {
                                        var temp = value[index].key + "|" + value[index].value;
                                        AddValue(id + 1, temp, temp);
                                    }
                                }
                            }

                            $("#" + id).next().nextAll().each(function() {
                                $(this).find("option").each(function() {
                                    $(this).remove();
                                });
                            });
                            Save();
                        }

                        // 根据传入值及json对象查找,返回json对象
                        function Traversal(text, obj) {
                            for (var index in obj) {
                                if (text == obj[index].key) {
                                    return obj[index].value;
                                }
                            }
                        }

                        function AddOption(id) {
                            var obj = "#" + id;
                            var inpt = $("#lk-" + id);
                            

                            var url = inpt.val();  //prompt('请输入选项名称和值，中间用“|”隔开：', thisurl);
                            if (url != null && url != '') {
                                if (url.split("|").length == 1) {
                                    url += "|" + url;
                                }
                                
                                if (id > 1) {
                                    if ($("#" + (id - 1) + " select option:selected").length == 0) {
                                        alert("请选择父项");
                                        return;
                                    }
                                }

                                var b = false;
                                $(obj + " select option").each(function() {
                                    if ($(this).val().split("|")[0] == url.split("|")[0]) {
                                        b = true;
                                    }
                                });
                                
                                if(b){
                                    alert("不能添加重复项");
                                    return;
                                }

                                AddValue(id, url, url, false);
                                var index = $(obj + " select option").length + 1;
                                var thisurl = '选项名称' + index + '|选项值';
                                inpt.val(thisurl)
                                var temp = url.split("|");
                                OperateOption(id, temp[0], temp[temp.length - 1], "add");
                            }
                        }

                        function ModifyOption(obj) {
                            var op = obj.get(0).selectedIndex;
                            var thisurl = obj.val();
                            var url = prompt('请输入选项名称和值，中间用“|”隔开：', thisurl);
                            if (url != null && url != '') {
                                if (url.split("|").length == 1) {
                                    url += "|" + url;
                                }
                                
                                var b = false;
                                obj.find("option").each(function(index) {
                                    if (index != op) {
                                        if ($(this).val().split("|")[0] == url.split("|")[0]) {
                                            b = true;
                                        }
                                    }
                                });

                                if (b) {
                                    alert("修改失败，此项已重复");
                                    return;
                                }
                                
                                var index = obj.get(0).selectedIndex;
                                obj[0].options[index].text = url;
                                obj[0].options[index].value = url;
                                var arr = url.split("|");
                                var id = obj.parent().parent().attr("id");
                                var current = eval("(" + date.split("|")[id - 1] + ")");
                                if (id == 1) {
                                    for (var i in current) {
                                        if (current[i].key == thisurl.split("|")[0]) {
                                            current[i].key = arr[0];
                                            current[i].value = arr[arr.length - 1];
                                        }
                                    }
                                } else {
                                    var pre = obj.parent().parent().prev().find("select").val().split("|")[0];
                                    for (var i in current) {
                                        if (current[i].key == pre) {
                                            for (var j in current[i].value) {
                                                if (current[i].value[j].key == thisurl.split("|")[0]) {
                                                    current[i].value[j].key = arr[0];
                                                    current[i].value[j].value = arr[arr.length - 1];
                                                }
                                            }
                                        }
                                    }
                                }

                                SetValue(id - 1, current, date.split("|"));
                                current = eval("(" + date.split("|")[id] + ")");
                                for (var i in current) {
                                    if (current[i].key == thisurl.split("|")[0]) {
                                        current[i].key = arr[0];
                                    }
                                }

                                SetValue(id, current, date.split("|"));
                            }
                        }

                        // 添加项
                        function AddValue(id, text, value) {
                            var obj = "#" + id;
                            var option = new Option(text, value);
                            $(obj + " select")[0].options[$(obj + " select option").length] = option;
                        }

                        function RemoveValue(id) {
                            var currentId = "#" + id + " select option:selected";
                            if ($(currentId).length > 0) {                                
                                var del = $(currentId).val().split("|");
                                $(currentId).remove();
                                $("#" + id).nextAll().find("select option").each(function() {
                                    $(this).remove();
                                });
                                OperateOption(id, del[0], del[del.length - 1], "delete");
                            }
                        }

                        function OperateOption(id, text, value, operate) {
                            var tempArray = date.split("|");
                            var current = eval("(" + tempArray[id - 1] + ")");
                            if (operate == "add") {
                                if (id == 1) {
                                    current.push(eval("({key:'" + text + "',value:'" + value + "'})"));
                                } else {
                                    var exists = false;
                                    var selectedValue = $("#" + (id - 1) + " select").val().split("|")[0];
                                    for (var i in current) {
                                        if (current[i].key == selectedValue) {
                                            exists = true;
                                            current[i].value.push(eval("({key:'" + text + "',value:'" + value + "'})"));
                                            break;
                                        }
                                    }

                                    if (!exists) {
                                        var v = "{key:'" + selectedValue + "',value:[{key:'" + text + "',value:'" + value + "'}]}";
                                        current.push(eval("(" + v + ")"));
                                        $("#t2").html(JsonToString(current));
                                    }
                                }
                            } else if (operate == "delete") {
                                var b = false;
                                if (id == 1) {
                                    for (var i in current) {
                                        if (current[i].key == text) {
                                            b = true;
                                            break;
                                        }
                                    }

                                    if (b) {
                                        current.splice(i, 1);
                                    }
                                } else {
                                    var selectedValue = $("#" + (id - 1) + " select").val().split("|")[0];
                                    for (var i in current) {
                                        if (selectedValue == current[i].key) {
                                            for (var j in current[i].value) {
                                                if (current[i].value[j].key == text) {
                                                    b = true;
                                                    break;
                                                }
                                            }

                                            if (b) {
                                                current[i].value.splice(j, 1);
                                            }
                                        }
                                    }
                                }
                                
                                tempArray = Del(id, text, tempArray);
                            }

                            SetValue(id - 1, current, tempArray);
                        }

                        function Del(id, text) {
                            var current = eval("(" + date.split("|")[id] + ")");
                            var b = false;
                            for (var i in current) {
                                if (current[i].key == text) {
                                    b = true;
                                    for (var j in current[i].value) {
                                        Del(id + 1, current[i].value[j].key);
                                    }

                                    break;
                                }
                            }

                            if (b) {
                                current.splice(i, 1);
                            }

                            SetValue(id, current, date.split("|"));
                            return date.split("|");
                        }

                        function JsonToString(o) {
                            var arr = [];
                            for (var i in o) {
                                arr.push(Cnv(o[i]));
                            }

                            return '[' + arr.join(',') + ']';
                        }

                        function Cnv(o) {
                            var str = "";
                            var p = "{key:'" + o.key + "',";
                            if (typeof o.value == 'object' && o.value != null) {
                                var arr = [];
                                for (var i = 0; i < o.value.length; i++) {
                                    arr.push("{key:'" + o.value[i].key + "',value:'" + o.value[i].value + "'}");
                                }

                                str += p + "value:" + "[" + arr.join(',') + "]}";
                            } else {
                                str += p + "value:'" + o.value + "'}";
                            }

                            return str;
                        }

                        function SetValue(id, objJson, tempArray) {
                            var val = "";
                            for (var i = 0; i < tempArray.length; i++) {
                                if (val != "") {
                                    val += "|";
                                }

                                if (i == id) {
                                    val += JsonToString(objJson);
                                } else {
                                    val += tempArray[i];
                                }
                            }

                            date = val;
                            Save();
                        }

                        function Save() {
                            $("#<%=HdnLinkageValue.ClientID %>").val(date);

                            // 默认值
                            var obj = $("#<%=HdnLinkageDefault.ClientID %>");
                            obj.val("");
                            $("#Linkage li select").each(function() {
                                if (obj.val() != "") {
                                    obj[0].value += "|";
                                }

                                if ($(this).find("option:selected").length > 0) {
                                    var temp = $(this).val().split("|");
                                    obj[0].value += temp[temp.length - 1];
                                }
                            });
                        }
                    </script>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>设置默认值：</strong>
                </td>
                <td align="left">
                    <asp:HiddenField ID="HdnLinkageDefault" runat="server" />
                    <asp:CheckBox ID="ChkLinkageDefault" runat="server" Text="启用默认值" />
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>显示方式：</strong>
                </td>
                <td>
                    <asp:RadioButtonList ID="RbtnLinkageShowType" runat="server" RepeatDirection="Horizontal">
                        <asp:ListItem Value="1" Selected="True">横向显示</asp:ListItem>
                        <asp:ListItem Value="0">纵向显示</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>显示时使用的分隔符：</strong>
                </td>
                <td align="left">
                    <asp:DropDownList ID="DropLinkageSplit" runat="server" Width="100">
                        <asp:ListItem Value="">无</asp:ListItem>
                        <asp:ListItem Value=",">逗号(,)</asp:ListItem>
                        <asp:ListItem Value="-">减号(-)</asp:ListItem>
                        <asp:ListItem Value="/">斜杠(/)</asp:ListItem>
                        <asp:ListItem Value="\">反斜杠(\)</asp:ListItem>
                    </asp:DropDownList>
                    <span style="color:Green;">如</span>：<span id="SpnExample">一级选项<span></span>二级选项<span></span>三级选项</span>
                </td>
            </tr>
        </tbody>
        <tbody runat="server" id="PnlRoleList">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>禁止设置该字段值的会员组：</strong>
                </td>
                <td align="left">
                    <pe:ExtendedCheckBoxList ID="EChkGroupList" RepeatColumns="5" runat="server">
                    </pe:ExtendedCheckBoxList>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>禁止设置该字段值的角色：</strong>
                </td>
                <td align="left">
                    <pe:ExtendedCheckBoxList ID="EChkRoleList" RepeatColumns="5" runat="server">
                    </pe:ExtendedCheckBoxList>
                </td>
            </tr>
        </tbody>
        <tr class="tdbgbottom">
            <td colspan="2">
                <asp:Button ID="EBtnSubmit" Text="保存字段" OnClick="EBtnSubmit_Click" runat="server" />&nbsp;&nbsp;
                <asp:Button ID="BtnCancel" runat="server" Text="返回字段管理" OnClick="BtnCancel_Click"
                    CausesValidation="False" />
                <asp:HiddenField ID="HdnFieldLevel" runat="server" />
                <asp:HiddenField ID="HdnFieldType" runat="server" />
                <asp:HiddenField ID="HdnOrderId" runat="server" />
                <asp:HiddenField ID="HdnDisabled" runat="server" />
            </td>
        </tr>
    </table>
    <script language="javascript" type="text/javascript">

        function ChangeTxtRegexRule() {
            var TxtRegex = document.getElementById("<%=TxtRegexRule.ClientID %>");
            var dropRegex = document.getElementById("<%=DropTextBoxRegexRule.ClientID %>");
            var regexErrorMsg = document.getElementById("RegexErrorMsg");
            var dropRegexValue = dropRegex.options[dropRegex.selectedIndex].value;

            if (dropRegexValue == "") {
                TxtRegex.style.display = "none";
                regexErrorMsg.style.display = "none";
                TxtRegex.value = "";
            } else if (dropRegexValue == "Self") {
                TxtRegex.style.display = "";
                regexErrorMsg.style.display = "";
                TxtRegex.value = "";
            } else {
                regexErrorMsg.style.display = "";
                TxtRegex.style.display = "";
                TxtRegex.value = dropRegexValue;
            }
        }
    </script>
</asp:Content>