﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.General.WebSite.Admin.Contents.ContentManageUI" Title="内容管理" CodeBehind="ContentManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" EnablePartialRendering="true" runat="server">
    </asp:ScriptManager>        
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
    <div style="padding-top: 5px;"></div>
    <table border='0' cellpadding='0' cellspacing='1' width='100%' height='100%'>
      <tr>
        <td id="AdminTabs">
            <ul>
                <!-- CSS Tabs -->
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteContentList" />>
                    <asp:LinkButton ID="LinkContentList" runat="server"   CommandArgument="100"
                        onclick="ShowBookmarks"><span>所有内容</span></asp:LinkButton>
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteDraft" />> 
                    <asp:LinkButton ID="LinkDraft" runat="server"  CommandArgument="-1"
                        onclick="ShowBookmarks"><span>草稿</span></asp:LinkButton>  
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="ElitePending" />>    
                    <asp:LinkButton ID="LinkPending" runat="server" CommandArgument="101"
                        onclick="ShowBookmarks"><span>待审核</span></asp:LinkButton> 
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteAudited" />>
                    <asp:LinkButton ID="LinkAudited"  CommandArgument="99"  runat="server" 
                        onclick="ShowBookmarks"><span>已审核</span></asp:LinkButton>  
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteTuigao" />>
                    <asp:LinkButton ID="LinkTuigao" CommandArgument="-2" runat="server" 
                        onclick="ShowBookmarks"><span>退稿</span></asp:LinkButton>  
                </li>
                <asp:PlaceHolder runat="server" ID="SiteGroupPh" Visible="false">
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteSiteGroup" />>
                    <asp:LinkButton ID="LinkSiteGroup" CommandArgument="-999" runat="server" 
                        onclick="ShowBookmarks"><span>已共享到站群</span></asp:LinkButton>  
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteFromSiteGroup" />>
                    <asp:LinkButton ID="LinkFromSiteGroup" CommandArgument="-1000" runat="server" 
                        onclick="ShowBookmarks"><span>从站群中获取</span></asp:LinkButton>  
                    </li>
                </asp:PlaceHolder>
            </ul>
          </td>
          <td align="right">
          <asp:DropDownList ID="DrModelQuery" AutoPostBack="true" OnSelectedIndexChanged="DrModelQuery_Changed" runat="server">
            <asp:ListItem Value="0">--请选择模型--</asp:ListItem>
        </asp:DropDownList>&nbsp;&nbsp;<asp:DropDownList ID="DropRescentQuery" AutoPostBack="true" OnSelectedIndexChanged="DropSelectedIndex_Changed"
            runat="server">
            <asp:ListItem Value="-1">按ID降序</asp:ListItem>
            <asp:ListItem Value="-2">按ID升序</asp:ListItem>
            <asp:ListItem Value="13">按更新时间降序</asp:ListItem>
            <asp:ListItem Value="14">按更新时间升序</asp:ListItem>
            <asp:ListItem Value="1">按推荐级别降序</asp:ListItem>
            <asp:ListItem Value="2">按推荐级别升序</asp:ListItem>
            <asp:ListItem Value="3">按优先级别降序</asp:ListItem>
            <asp:ListItem Value="4">按优先级别升序</asp:ListItem>
            <asp:ListItem Value="5">按日点击数降序</asp:ListItem>
            <asp:ListItem Value="6">按日点击数升序</asp:ListItem>
            <asp:ListItem Value="7">按周点击数降序</asp:ListItem>
            <asp:ListItem Value="8">按周点击数升序</asp:ListItem>
            <asp:ListItem Value="9">按月点击数降序</asp:ListItem>
            <asp:ListItem Value="10">按月点击数升序</asp:ListItem>
            <asp:ListItem Value="11">按总点击数降序</asp:ListItem>
            <asp:ListItem Value="12">按总点击数升序</asp:ListItem>
        </asp:DropDownList>
          </td>
      </tr>
    </table>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="EgvContent" runat="server" DataSourceID="OdsContents" SerialText=""
        AutoGenerateCheckBoxColumn="True" AutoGenerateColumns="False" AllowPaging="True"
        OnRowDataBound="EgvContent_RowDataBound" OnRowCommand="EgvContent_RowCommand"
        DataKeyNames="GeneralId" CheckBoxFieldHeaderWidth="3%" IsHoldState="True">
        <Columns>
            <pe:TemplateField HeaderText="操作" HeaderStyle-Width="70px">
                <ItemTemplate>
                    <pe:DropdownMenu runat="server" ID="ddmenu" ShowShortcut="true">
                        <pe:LinkMenuItem ID="ContentModify" SkinID="Edit" runat="server" />
                        <pe:ButtonMenuItem ID="ContentDelete" SkinID="Delete" runat="server" />
                        <pe:MenuSeparator runat="server" ID="MenuSeparator1"></pe:MenuSeparator>
                        <pe:ButtonMenuItem ID="BMPass" Text="审核通过" runat="server" Visible="false" OnClick="EBtnPass_Click" />
                        <pe:ButtonMenuItem ID="BMCancelPass" Text="取消审核" runat="server" Visible="false" OnClick="EBtnCancelPass_Click" />
                        <pe:ButtonMenuItem ID="BMBatchSpecialSet" Text="添加到专题" runat="server" OnClick="EBtnBatchSpecialSet_Click" />
                        <pe:ButtonMenuItem ID="BMBatchNodeSet" Text="添加到其他栏目" runat="server" OnClick="BatchNodeSet_Click" />
                        <pe:ButtonMenuItem ID="BMBtnArchiving" Text="归档内容" runat="server" OnClick="BtnArchiving_Click" />
                        <pe:MenuSeparator runat="server" ID="MenuSeparator2"></pe:MenuSeparator>
                        <pe:LinkMenuItem ID="ContentPreview" Target="_blank" Text="前台预览" runat="server" />
                    </pe:DropdownMenu>
                </ItemTemplate>
            </pe:TemplateField>
            <asp:BoundField DataField="GeneralId" HeaderText="ID" SortExpression="GeneralId">
                <HeaderStyle Width="5%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="标题" SortExpression="Title">
                <ItemTemplate>
                    <pe:LinkImage ID="LinkImageModel" runat="server">
                        <pe:ExtendedHyperLink ID="LnkNodeLink" runat="server" />
                        <asp:HyperLink ID="HypTitle" runat="server" />
                    </pe:LinkImage>
                </ItemTemplate>
                <ItemStyle HorizontalAlign="Left" />
            </asp:TemplateField>
            <asp:BoundField DataField="Inputer" HeaderText="录入者" SortExpression="Inputer">
                <HeaderStyle Width="6%" />
            </asp:BoundField>
            <asp:BoundField DataField="Hits" HeaderText="点击数" SortExpression="Hits">
                <HeaderStyle Width="6%" />
            </asp:BoundField>
            <asp:BoundField DataField="EliteLevel" HeaderText="推荐级别" SortExpression="EliteLevel">
                <HeaderStyle Width="8%" />
            </asp:BoundField>
            <asp:BoundField DataField="Priority" HeaderText="优先级" SortExpression="Priority">
                <HeaderStyle Width="6%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="状态" SortExpression="Status">
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                    <asp:Label ID="LabStatusName"  runat="server"></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="已生成" SortExpression="Status">
                <ItemTemplate>
                    <pe:ExtendedLabel ID="LblIsCreateHtml" runat="server" HtmlEncode="false">
                &nbsp;&nbsp;
                    </pe:ExtendedLabel>
                </ItemTemplate>
                <HeaderStyle Width="6%" />
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnListType" runat="server" Value="-1" />
    <asp:HiddenField ID="HdnStatus" runat="server" Value="100" />
    <asp:HiddenField ID="HdnSearchType" runat="server" Value="" />
    <asp:HiddenField ID="HdnSearchKeyword" runat="server" Value="" />
    <asp:HiddenField ID="HdnIsMyInformation" runat="server" Value="false" />
    <asp:HiddenField ID="HdnModelID" runat="server" Value="0" />
        
    <asp:ObjectDataSource ID="OdsContents" runat="server" SelectMethod="GetSearchContentList"
        TypeName="PowerEasy.Module.General.BusinessLogic.Contents.ContentManage" EnablePaging="True" MaximumRowsParameterName="maxNumberRows"
        StartRowIndexParameterName="startRowIndexId" SelectCountMethod="GetTotalOfCommonModelInfo">
        <SelectParameters>
            <asp:QueryStringParameter Name="nodeId" QueryStringField="NodeID" Type="Int32" />
            <asp:ControlParameter Name="modelId" ControlID="HdnModelID" Type="Int32" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnListType" Type="Int32" Name="sortType" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnStatus" Type="Int32" Name="status" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnSearchType" Type="String" Name="searchType" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnSearchKeyword" Type="String" Name="keyword" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnIsMyInformation" Type="Boolean" Name="isMyInformation" PropertyName="Value" />
              <asp:ControlParameter ControlID="EgvContent" DefaultValue="0" 
                PropertyName="VirtualItemCount" Type="Int32" Direction="InputOutput" 
                Name="total" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <table border="0" cellpadding="0" cellspacing="1" style="width: 100%; height: 100%;">
        <tr>
            <td style="width: 170px;">
                <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" /><label
                    for="ChkAll">选中本页显示的所有项目</label></td>
            <td>
                <asp:Button ID="EBtnBatchDelete" Text="批量删除" Width="115" OnClientClick="return batchconfirm('确定要删除选中的项目吗？本操作把选中的信息移到回收站中。必要时您可从回收站中恢复！');"
                    OnClick="EBtnBatchDelete_Click" CausesValidation="False" runat="server" />
                <asp:Button ID="EBtnBatchSet" Text="批量设置" Width="115" runat="server" OnClick="EBtnBatchSet_Click" />
                <asp:Button ID="EBtnBatchMove" Text="批量移动" Width="115" runat="server" OnClick="EBtnBatchMove_Click" />
                <asp:Button ID="EBtnShare" Text="批量推送" Width="115" Visible="false" runat="server" OnClick="EBtnShare_Click" />
                <asp:Button ID="EBtnRejection" Text="退稿" Width="115" runat="server" OnClick="EBtnRejection_Click" />
                <asp:Button ID="EBtnPass" Text="审核通过" Width="115" runat="server" OnClick="EBtnPass_Click" />
                <asp:Button ID="EBtnCancelPass" Text="取消审核" Width="115" runat="server" OnClick="EBtnCancelPass_Click" />
                <asp:Button ID="BatchSpecialSet" Text="添加到专题" Width="115" runat="server" OnClick="EBtnBatchSpecialSet_Click" />
                <asp:Button ID="BatchNodeSet" Text="添加到其他栏目" Width="115" runat="server" OnClick="BatchNodeSet_Click" />
                <asp:Button ID="BtnArchiving" Text="归档内容" Width="115" runat="server" OnClick="BtnArchiving_Click" />
            </td>
        </tr>
    </table>
    <br />
    <table style="width: 100%;" cellpadding="2" cellspacing="1" class="border">
        <tr>
            <td style="width: 80px" align="left" class="tdbg">
                <b>搜索选项：</b>
            </td>
            <td class="tdbg">
                <asp:DropDownList ID="DrpSearchType" runat="server">
                    <asp:ListItem Value="ID" Text="ID" />
                    <asp:ListItem Value="Title" Text="内容标题" Selected="True"/>
                    <asp:ListItem Value="Inputer" Text="录入者" />
                </asp:DropDownList>
                <asp:TextBox ID="TxtSearchKeyword" onkeypress="javascript:return DefaultButton(event)" runat="server" />
                <asp:Button ID="BtnSearch"  runat="server" Text="搜索" OnClick="BtnSearch_Click" />&nbsp;
                <asp:LinkButton ID="LinkAdvancedSearch" runat="server" 
                        onclick="LinkAdvancedSearch_Click"><span>高级搜索</span></asp:LinkButton>
            </td>
            <td class="tdbg" style="width: 80px" align="left">
                <b>高级功能：</b>
            </td>
            <td class="tdbg">
                &nbsp;&nbsp;
                <input id="btnHashKey" type="button" class="inputbutton" value="重建标题索引..." onclick="ShowHash();" style="width:115px" />
            </td>
        </tr>
    </table>
    <script language="javascript" type="text/javascript">
        function ShowHash() {
            parent.jQuery("#newFrameTab").click();
            var d = jQuery(parent.document);
            d.find("#main_right").attr("src", "<%=BasePath%><%= PowerEasy.Foundation.SiteConfig.SiteOption.ManageDir %>/Contents/ContentHashProgress.aspx?IsShow=true");
        }

        function Check(id) {
            checkBoxes = document.getElementsByTagName("input");
            for (var i = 0; i < checkBoxes.length; i++) {
                if (checkBoxes[i].type == "checkbox") {
                    checkBoxes[i].checked = false;
                }
            }
            document.getElementById(id).checked = true;
            if (document.getElementById(id).checked) {
                return true;
            }
            else {
                return false;
            }
          }
          function DefaultButton(event) {
            if (event.keyCode == 13 && !(event.srcElement && (event.srcElement.tagName.toLowerCase() == "textarea"))) {
              var defaultButton = document.getElementById('<%= BtnSearch.ClientID %>');
              if (defaultButton && typeof (defaultButton.click) != "undefined") {
                defaultButton.click();
                event.cancelBubble = true;
                if (event.stopPropagation)
                  event.stopPropagation();
                return false;
              }
            }
            return true;
          }
    </script>
</asp:Content>
