﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="Company.ascx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.Controls.Company.CompanyControl" %>

<tr class='tdbg'>
    <td align='right' style="width: 20%;" class='tdbgleft'>
        <asp:Localize ID="Localize1" Text="企业名称：" runat="server" /></td>
    <td align='left' colspan="3" style="width: 80%;">
        <asp:TextBox ID="TxtCompanyName" runat="server" Width="300px" MaxLength="200"></asp:TextBox>  
        <pe:RequiredFieldValidator ID="ValrCompanyName" runat="server" Display="dynamic"
            ControlToValidate="TxtCompanyName" ErrorMessage="企业名称不能为空！"></pe:RequiredFieldValidator>
        <asp:RegularExpressionValidator ID="ValeCompanyName" Display="Dynamic" ControlToValidate="TxtCompanyName"
            ValidationExpression="^[\w\W\u4e00-\u9fa5]{6,100}$" SetFocusOnError="true" runat="server" ErrorMessage="企业名称的长度不能小于6位大于100位"></asp:RegularExpressionValidator>
    </td>
</tr>
<tr class='tdbg'>
    <td align='right' class='tdbgleft'>
        <asp:Localize ID="Localize2" Text="通讯地址：" runat="server" /></td>
    <td align='left' colspan="3">
        <pec:Region ID="Region1" runat="server" />
        <table border="0" cellpadding="2" cellspacing="1" width="100%"  style="width: 100%; background-color: white;">
            <tr class="tdbg">
                <td style="width: 20%" align="right" class="tdbgleft">
                    <asp:Localize ID="Localize3" Text="联系地址：" runat="server" /></td>
                <td>
                    <asp:TextBox ID="TxtAddress" runat="server" Width="300px" MaxLength="255"></asp:TextBox>
                    <asp:RequiredFieldValidator ID="ValrAddress" ControlToValidate="TxtAddress" SetFocusOnError="true"
                        Display="dynamic" runat="server" ErrorMessage="请输入详细的联系地址 "></asp:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="ValeAddress" Display="Dynamic" ControlToValidate="TxtAddress"
                        ValidationExpression="^[\w\W\u4e00-\u9fa5]{10,}$" SetFocusOnError="true" runat="server" ErrorMessage="联系地址的长度不能小于10"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td align="right" class="tdbgleft">
                    <asp:Localize ID="Localize4" Text="邮政编码：" runat="server" /></td>
                <td>
                    <asp:TextBox ID="TxtZipCode" runat="server" MaxLength="6" Width="200px"></asp:TextBox><pe:RegexValidator ValidateType="ZipCode"
                        ID="VzipZipCode" ControlToValidate="TxtZipCode" SetFocusOnError="true" Display="dynamic"
                        runat="server"></pe:RegexValidator>
                    <asp:RequiredFieldValidator ID="ValrZipCode" ControlToValidate="TxtZipCode" SetFocusOnError="true"
                        Display="dynamic" runat="server" ErrorMessage="请输入单位的邮政编码 "></asp:RequiredFieldValidator>
                </td>
            </tr>
        </table>
    </td>
</tr>
<tr class='tdbg'>
    <td align='right' class='tdbgleft'>
        <asp:Localize ID="Localize5" Text="联系电话：" runat="server" /></td>
    <td align='left'>
        <asp:TextBox ID="TxtPhone" runat="server" MaxLength="30" ></asp:TextBox>
    </td>
    <td align='right' class='tdbgleft'>
        <asp:Localize ID="Localize6" Text="传真号码：" runat="server" /></td>
    <td align='left'>
        <asp:TextBox ID="TxtFax" runat="server" MaxLength="30" ></asp:TextBox>
    </td>
</tr>
<tr class='tdbg'>
    <td align='right' class='tdbgleft'>
        <asp:Localize ID="Localize7" Text="开户银行：" runat="server" /></td>
    <td align='left'>
        <asp:TextBox ID="TxtBankOfDeposit" runat="server" MaxLength="50" ></asp:TextBox>
    </td>
    <td align='right' class='tdbgleft'>
        <asp:Localize ID="Localize8" Text="银行帐号：" runat="server" /></td>
    <td align='left'>
        <asp:TextBox ID="TxtBankAccount" runat="server" MaxLength="50" ></asp:TextBox>
    </td>
</tr>
<tr class='tdbg'>
    <td align='right' class='tdbgleft'>
        <asp:Localize ID="Localize9" Text="税号：" runat="server" /></td>
    <td align='left'>
        <asp:TextBox ID="TxtTaxNum" runat="server" MaxLength="20" ></asp:TextBox>
    </td>
    <td align='right' class='tdbgleft'>
        <asp:Localize ID="Localize10" Text="网址：" runat="server" /></td>
    <td align='left'>
        <asp:TextBox ID="TxtHomepage" runat="server" MaxLength="100" ></asp:TextBox>
    </td>
</tr>
<tr class='tdbg'>
    <td align='right' class='tdbgleft'>
        <asp:Localize ID="Localize11" Text="行业地位：" runat="server" /></td>
    <td align='left'>
        <asp:DropDownList ID="DropStatusInField" runat="server" DataTextField="DataTextField"
            DataValueField="DataValueField">
        </asp:DropDownList>
    </td>
    <td align='right' class='tdbgleft'>
        <asp:Localize ID="Localize12" Text="公司规模：" runat="server" /></td>
    <td align='left'>
        <asp:DropDownList ID="DropCompanySize" runat="server" DataTextField="DataTextField"
            DataValueField="DataValueField">
        </asp:DropDownList>
    </td>
</tr>
<tr class='tdbg'>
    <td align='right' class='tdbgleft'>
        <asp:Localize ID="Localize13" Text="业务范围：" runat="server" /></td>
    <td align='left'>
        <asp:TextBox ID="TxtBusinessScope" runat="server" MaxLength="255" ></asp:TextBox>
    </td>
    <td align='right' class='tdbgleft'>
        <asp:Localize ID="Localize14" Text="年销售额：" runat="server" /></td>
    <td align='left'>
        <asp:TextBox ID="TxtAnnualSales" runat="server" MaxLength="20" ></asp:TextBox><asp:Localize ID="Localize15" Text="万元  " runat="server" />
<asp:CompareValidator 
    ID="ValcAnnualSales" runat="server" ControlToValidate="TxtAnnualSales" 
    Display="Dynamic" ErrorMessage="请输入有效的数值！" Operator="GreaterThan" 
    Type="Double" ValueToCompare="0"></asp:CompareValidator>
&nbsp;</td></tr><tr class='tdbg'><td align='right' class='tdbgleft'><asp:Localize ID="Localize16" Text="经营状态：" runat="server" /></td>
    <td align='left'>
        <asp:DropDownList ID="DropManagementForms" runat="server" DataTextField="DataTextField"
            DataValueField="DataValueField">
        </asp:DropDownList>
    </td>
    <td align='right' class='tdbgleft'>
        <asp:Localize ID="Localize17" Text="注册资本：" runat="server" /></td>
    <td align='left'>
        <asp:TextBox ID="TxtRegisteredCapital" runat="server" MaxLength="20" ></asp:TextBox><asp:Localize ID="Localize18" Text="万元  " runat="server" /><asp:CompareValidator 
    ID="ValcRegisteredCapital" runat="server" 
    ControlToValidate="TxtRegisteredCapital" Display="Dynamic" 
    ErrorMessage="请输入有效的数值！" Operator="GreaterThan" Type="Double" 
    ValueToCompare="0"></asp:CompareValidator>
&nbsp;</td></tr><tr class='tdbg'><td align='right' class='tdbgleft'><asp:Localize ID="Localize19" Text="公司照片：" runat="server" /></td>
    <td align='left' colspan="3">
        <asp:TextBox ID="TxtCompanyPic" runat="server" MaxLength="255"  Width="250px"></asp:TextBox>
    </td>
</tr>
<tr class='tdbg'>
    <td align='right' class='tdbgleft'>
        <asp:Localize ID="Localize20" Text="公司简介：" runat="server" /></td>
    <td align='left' colspan="3">
        <asp:TextBox ID="TxtCompanyIntro" TextMode="MultiLine" Height="120px" runat="server" Width="250px"></asp:TextBox>
    </td>
</tr>
<%-- <tr class="tdbg">
              <td colspan="4">
                        <asp:UpdatePanel ID="UpnlCompanyOption" runat="server" UpdateMode="Conditional">
                        <ContentTemplate>
                            <table cellpadding="2" cellspacing="1" style="width: 100%; background-color: white;">
                                <asp:Repeater ID="RepModel" runat="server" OnItemDataBound="RepModel_OnItemDataBound">
                                    <ItemTemplate>
                                        <tr id='Tab' runat="server" class='tdbg'>
                                            <td align='right' class='tdbgleft' style="width:20%;">
                                                <div class="DivWordBreak">
                                                        <%# Eval("FieldAlias")%>
                                                        ：&nbsp;<br />
                                                    <%# Eval("Tips") %>
                                                </div>
                                            </td>
                                            <td align='left'>
                                                <pe:FieldControl ID="Field" runat="server" EnableNull='<%# (bool)Eval("EnableNull") %>'
                                                    FieldAlias='<%# Eval("FieldAlias")%>' Tips='<%# Eval("Tips") %>' FieldName='<%#Eval("FieldName")%>'
                                                    ControlType='<%# Eval("FieldType") %>' FieldLevel='<%# Eval("FieldLevel") %>' ModelId='<%# Eval("ModelId") %>'
                                                    Description='<%# Eval("Description")%>' Settings='<%# ((PowerEasy.Module.General.Model.CommonModel.FieldInfo)Container.DataItem).Settings %>'
                                                    Value='<%# Eval("DefaultValue") %>' IsAdminManage="false">
                                                </pe:FieldControl>
                                            </td>
                                        </tr>
                                    </ItemTemplate>
                                </asp:Repeater>
                            </table>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                      </td>
        </tr>--%>
<asp:HiddenField ID="HdnCompanyAction" runat="server" />      
