﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    ValidateRequest="false" CodeBehind="ApplyGatheringLog.aspx.cs" Inherits="PowerEasy.Module.Promotion.WebSite.Admin.Promotion.ApplyGatheringLog"
    Title="提现管理" %>
<%@ Import Namespace="PowerEasy.Framework.Common" %>
<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
        <tr>
            <td id="AdminTabs">
                <ul>
                    <li
                        <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrAll" />>
                        <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="-2" OnClick="ShowBookmarks"><span>所有</span></asp:LinkButton>
                    </li>
                    <li
                        <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrApply" />>
                        <asp:LinkButton ID="LinkApply" runat="server" CommandArgument="0" OnClick="ShowBookmarks"><span>待审批</span></asp:LinkButton>
                    </li>
                    <li
                        <pe:ExtendedLiteral ID="LtrApproval" runat="server" HtmlEncode="false" />>
                        <asp:LinkButton ID="LinkApproval" runat="server" CommandArgument="1" OnClick="ShowBookmarks"><span>已审批待支付</span></asp:LinkButton>
                    </li>
                    <li
                        <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrRemittances" />>
                        <asp:LinkButton ID="LinkRemittances" runat="server" CommandArgument="2" OnClick="ShowBookmarks"><span>已汇款</span></asp:LinkButton>
                    </li>
                    <li
                        <pe:ExtendedLiteral ID="LtrNoPass" runat="server" HtmlEncode="False"></pe:ExtendedLiteral>>
                        <asp:LinkButton ID="LinkNoPass" runat="server" CommandArgument="-1" OnClick="ShowBookmarks"><span>已拒绝</span></asp:LinkButton>
                    </li>
                </ul>
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView ID="EgvApplyGathering" runat="server" AutoGenerateColumns="False"
        CheckBoxFieldHeaderWidth="3%" DataSourceID="OdsApplyGathering" IsHoldState="True"
        SerialText="" AllowPaging="True" OnRowCommand="EgvApplyGathering_RowCommand"
        AutoGenerateCheckBoxColumn="True" DataKeyNames="ID" OnRowDataBound="EgvApplyGathering_RowDataBound">
        <Columns>
            <asp:BoundField DataField="Id" HeaderText="ID" SortExpression="Id" ItemStyle-Width="5%">
                <ItemStyle Width="5%"></ItemStyle>
            </asp:BoundField>
             <asp:TemplateField HeaderText="申请时间" ItemStyle-Width="20%">
                <ItemTemplate>
                <%#Eval("CreateTime", "{0:yyyy-MM-dd HH:mm:ss}")%>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="UserName" HeaderText="申请人" SortExpression="UserName" ItemStyle-Width="10%">
                <ItemStyle Width="10%"></ItemStyle>
            </asp:BoundField>
            <pe:TemplateField HeaderText="申请金额" SortExpression="Amount">
                <ItemStyle HorizontalAlign="Center" Width="10%" />
                <ItemTemplate>
                    <%# Eval("Amount", "{0:N2}")%>元
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="实付金额" SortExpression="RealityAmount">
                <ItemStyle HorizontalAlign="Center" Width="12%" />
                <ItemTemplate>
                    <%# Eval("RealityAmount", "{0:N2}")%>元
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="申请人余额" SortExpression="Amount">
                <ItemStyle HorizontalAlign="Center" Width="12%" />
                <ItemTemplate>
                    <asp:Label runat="server" ID="LblBalance"></asp:Label>元
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="状态" SortExpression="State">
                <ItemStyle HorizontalAlign="Center" Width="12%" />
                <ItemTemplate>
                    <label title='<%#Eval("Remark") %>' id="labState" runat="server">
                        <%#PowerEasy.Module.Promotion.BusinessLogic.ApplyGathering.GetState(DataConverter.ToInt32(Eval("State")))%></label>
                </ItemTemplate>
            </pe:TemplateField>
            <asp:TemplateField HeaderText="操作">
                <ItemStyle HorizontalAlign="Center" Width="10%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor ID="ModifyApply" runat="server" OperateCode="Approval" href='<%#string.Format("PaymentAction.aspx?Id={0}",Eval("ID")) %>'
                        IsChecked="true">
                        审核</pe:ExtendedAnchor>
                    <pe:ExtendedAnchor Visible="false"  ID="ShowInfo" runat="server" OperateCode="None"
                        href='<%#string.Format("ShowGatheringDetail.aspx?Id={0}",Eval("ID")) %>' IsChecked="false">
                        查看</pe:ExtendedAnchor>
                </ItemTemplate>
                <HeaderStyle Width="10%" />
                <ItemStyle Wrap="false" />
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsApplyGathering" runat="server" SelectMethod="GetApplyGatheringInfoList"
        TypeName="PowerEasy.Module.Promotion.BusinessLogic.ApplyGathering" SelectCountMethod="GetTotalOfApplyGathering" 
        EnablePaging="True" MaximumRowsParameterName="maxNumberRows" StartRowIndexParameterName="startRowIndexId">
        <SelectParameters>
            <asp:ControlParameter ControlID="HdnKey" Name="state" PropertyName="Value" Type="String"
                DefaultValue="-2" />
            <asp:QueryStringParameter DefaultValue="1" Name="sortType" QueryStringField="sortType"
                Type="String" />
            <asp:QueryStringParameter Name="keyWords" QueryStringField="KeyWord" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:HiddenField ID="HdnKey" runat="server" />
    <asp:HiddenField ID="HdnState" runat="server" />
    <table border="0" cellpadding="0" cellspacing="1" style="width: 100%; height: 100%;">
        <tr>
            <td>
                <asp:Button ID="EBtnConfirmed" Width="95px" CausesValidation="False" Text="批量确认"
                    runat="server" OnClick="EBtnConfirmed_Click" Visible="false" />
                <asp:Button ID="EBtnBatchApply" Width="95px" CausesValidation="False" Visible="false"
                    Text="批量拒绝" runat="server" OnClick="EBtnBatchApply_Click" />&nbsp;<asp:Button ID="BtnExportExcel"
                        Width="95px" runat="server" OnClick="BtnExportExcel_Click" Visible="false" Text="导出到Excel" />
            </td>
        </tr>
    </table>
</asp:Content>
