﻿<%@ Page Language="C#" MasterPageFile="~/Admin/Guide.master" Codebehind="PromotionGuide.aspx.cs"
    Inherits="PowerEasy.Module.Promotion.WebSite.Admin.Promotion.PromotionGuide" AutoEventWireup="True"
    Title="推广向导" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphTitle" runat="Server">
    推广商品管理
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphSubMenu" runat="Server">
    <div class="guideexpand" onclick="Switch(this)">
        快速查找</div>
    <div class="guide" style="display: ">
        <ul>
            <li><a href="PromotionManage.aspx?ListType=-1" target="main_right">所有推广商品</a> </li>
            <li><a href="PromotionManage.aspx?ListType=10" target="main_right">佣金百分比降序</a> </li>
            <li><a href="PromotionManage.aspx?ListType=11" target="main_right">佣金百分比升序</a> </li>
            <li><a href="PromotionManage.aspx?ListType=12" target="main_right">固定佣金价格降序</a> </li>
            <li><a href="PromotionManage.aspx?ListType=13" target="main_right">固定佣金价格升序</a> </li>
        </ul>
    </div>
    <div class="guideexpand" onclick="Switch(this)">
        查询推广商品</div>
    <div class="guidesearch">
        <ul>
            <li>
                <select id="SelField" style="width: 140px" onchange="ChanageSelect(this)">
                    <option value="1" selected="selected">商品名称</option>
                    <option value="2">固定佣金范围</option>
                    <option value="3">佣金百分比范围</option>
                </select>
            </li>
            <li id="key" style="display:">
                <asp:TextBox ID="TxtKeyWord" runat="server" Width="134" onclick="keyWord();" value="请输入关键字..."></asp:TextBox>
            </li>
            <li id="key2" style="display:none">
              <asp:TextBox ID="TxtCommission1"  runat="server"  style="width: 45px;text-align: right;" type="text" value ="0.00" ></asp:TextBox> 到 
              <asp:TextBox ID="TxtCommission2"  runat="server"  style="width: 45px;text-align: right;" type="text" value ="0.00" ></asp:TextBox> 元
            </li>
            <li id="key3" style="display:none">
              <asp:TextBox ID="TxtCommission3"  runat="server"  style="width: 45px;text-align: right;" type="text" value ="0.00" ></asp:TextBox> 到 
              <asp:TextBox ID="TxtCommission4"  runat="server"  style="width: 45px;text-align: right;" type="text" value ="0.00" ></asp:TextBox> %
            </li>
            <li>
                <input id="BtnSearch" type="button" class="inputbutton" value="查询" onclick="return OpenMainRight()" />
            </li>
        </ul>
    </div>
    <script type="text/javascript">
    function keyWord() {
        if (document.getElementById('<%=TxtKeyWord.ClientID%>').value == '请输入关键字...') document.getElementById('<%=TxtKeyWord.ClientID%>').value = '';
    }
    function ChanageSelect(select) { 
        switch (select.options[select.options.selectedIndex].value)
        {
            case "1":
                document.getElementById("key").style.display = "";
                document.getElementById("key2").style.display = "none";
                document.getElementById("key3").style.display = "none";
                break;
            case "2":
                document.getElementById("key").style.display = "none";
                document.getElementById("key2").style.display = "";
                document.getElementById("key3").style.display = "none";
                break;
            case "3":
                document.getElementById("key").style.display = "none";
                document.getElementById("key2").style.display = "none";
                document.getElementById("key3").style.display = "";
                break;
            default:
                break;
        }
    }
    function checkMoney(obj) {
        var tempValue = obj.value.replace(/(^\s+)|(\s+$)/g, '');
        if (!tempValue) { return }
        if (/^-?\d+(\.\d+)?$/.test(tempValue)) {
            obj.value = parseFloat(tempValue).toFixed(2);
            return true;
        } else {
            obj.value = "0.00";
            obj.focus();
            return false;
        }
    }
    function OpenMainRight()
    {
        var field=0;
        var objSel = document.getElementById("SelField");
        var keyword = "";
        field = objSel.options[objSel.options.selectedIndex].value;

        switch (field) {
            case "1":
                keyword = document.getElementById("<%=TxtKeyWord.ClientID%>").value.trim();
                if (keyword == "") {
                    alert("请输入要查询的条件！");
                    return false;
                }
                break;
            case "2":
                if (!checkMoney(document.getElementById("<%=TxtCommission1.ClientID%>")) || !checkMoney(document.getElementById("<%=TxtCommission2.ClientID%>"))) {
                    alert('请输入可包含小数点后2位的有效数字值！');
                    return false;
                }
                var commission1 = document.getElementById("<%=TxtCommission1.ClientID%>").value.trim();
                if (commission1 == "") {
                    alert("请输入要开始的查询范围！");
                    return false;
                }
                var commission2 = document.getElementById("<%=TxtCommission2.ClientID%>").value.trim();
                if (commission2 == "") {
                    alert("请输入要结束的查询范围！");
                    return false;
                }
                if (parseInt(commission1) > parseInt(commission2)) {
                    alert("查询开始范围不能大于查询结束范围！");
                    return false;
                }
                keyword = commission1 + "$$$" + commission2;
                break;
            case "3":
                if (!checkMoney(document.getElementById("<%=TxtCommission3.ClientID%>")) || !checkMoney(document.getElementById("<%=TxtCommission4.ClientID%>"))) {
                    alert('请输入可包含小数点后2位的有效数字值！');
                    return false;
                }
                var commission3 = document.getElementById("<%=TxtCommission3.ClientID%>").value.trim();
                if (commission3 == "") {
                    alert("请输入要开始的查询范围！");
                    return false;
                }
                var commission4 = document.getElementById("<%=TxtCommission4.ClientID%>").value.trim();
                if (commission4 == "") {
                    alert("请输入要结束的查询范围！");
                    return false;
                }
                if (parseInt(commission3) > parseInt(commission4)) {
                    alert("查询开始范围不能大于查询结束范围！");
                    return false;
                }
                keyword = commission3 + "$$$" + commission4;
                break;
            default:
                break;
        }
        
        var url = "PromotionManage.aspx?ListType=" + field + "&KeyWord=" + escape(keyword);
        JumpToMainRight(url);
    }
    </script>
</asp:Content>

