﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    ValidateRequest="false" CodeBehind="RegisterPromotion.aspx.cs" Inherits="PowerEasy.Module.Promotion.WebSite.Admin.Promotion.RegisterPromotion"
    Title="注册推广管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <pe:ExtendedGridView ID="EgvRegister" runat="server" AllowPaging="True" AutoGenerateColumns="False"
        CheckBoxFieldHeaderWidth="3%" DataSourceID="OdsSearch" IsHoldState="True" SerialText=""
        AutoGenerateCheckBoxColumn="True" DataKeyNames="ID" OnRowCommand="EgvRegister_RowCommand"
        OnRowDataBound="EgvRegister_RowDataBound">
        <Columns>
             <pe:TemplateField HeaderText="推广人">
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                  <a href='../User/UserShow.aspx?UserName=<%#Eval("UserName") %>'><%# Eval("UserName")%></a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="注册会员名">
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                  <a href='../User/UserShow.aspx?UserName=<%#Eval("RegisterUserName") %>'><%# Eval("RegisterUserName")%></a>
                </ItemTemplate>
            </pe:TemplateField>
            <asp:TemplateField HeaderText="注册IP">
                <ItemTemplate>
                    <pe:ExtendedLabel ID="ELblRegisterIP" runat="server" Text='<%# Eval("RegisterIP") %>'>
                    &nbsp;&nbsp;&nbsp;
                    </pe:ExtendedLabel>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="注册时间">
                <ItemTemplate>
                <%#Eval("RegisterTime", "{0:yyyy-MM-dd HH:mm:ss}")%>
                </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="状态">
                <ItemTemplate>
                    <pe:ExtendedLabel ID="ELblState" runat="server" Text='<%# Eval("State") %>'>
                    &nbsp;&nbsp;&nbsp;
                    </pe:ExtendedLabel>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="操作">
                <ItemTemplate>
                    <pe:ExtendedLinkButton ID="LbtnApply" runat="server" CausesValidation="false" CommandArgument='<%# Eval("ID") %>'
                        CommandName="Approval" IsChecked="true" OperateCode="RegisterPromotion">审核</pe:ExtendedLinkButton>
                    <pe:ExtendedLinkButton ID="LbtnCancel" runat="server" CausesValidation="false" CommandArgument='<%# Eval("ID") %>'
                        CommandName="Cancel" IsChecked="true" OperateCode="RegisterPromotion">取消审核</pe:ExtendedLinkButton>
                    <pe:ExtendedLinkButton ID="LbtnDelete" runat="server" CausesValidation="false" CommandArgument='<%# Eval("ID") %>'
                        CommandName="Del" IsChecked="true" OperateCode="RegisterPromotion" OnClientClick="return confirm('确定要删除记录吗？');">删除</pe:ExtendedLinkButton>
                </ItemTemplate>
                <HeaderStyle Width="10%" />
                <ItemStyle Wrap="false" />
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsSearch" runat="server" SelectMethod="GetList" TypeName="PowerEasy.Module.Promotion.BusinessLogic.RegisterPromotionManage"
        SelectCountMethod="GetTotalOfRegisterPromotion" EnablePaging="True" MaximumRowsParameterName="maxNumberRows" StartRowIndexParameterName="startRowIndexId">
        <SelectParameters>
            <asp:ControlParameter ControlID="TxtFiled" Name="filed" PropertyName="Text" Type="String" />
            <asp:QueryStringParameter DefaultValue="0" Name="listType" QueryStringField="listType"
                Type="Int32" />
            <asp:ControlParameter ControlID="DrpSearchType" Name="searchType" PropertyName="SelectedValue"
                Type="Int32" />
            <asp:ControlParameter ControlID="DpkStart" Name="startTime" PropertyName="Text" Type="DateTime" />
            <asp:ControlParameter ControlID="DpkEnd" Name="endTime" PropertyName="Text" Type="DateTime" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <table border="0" cellpadding="0" cellspacing="1" style="width: 100%; height: 100%;">
        <tr>
            <td>
                <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" />选中本页显示的所有记录
                &nbsp;
                <asp:Button ID="EBtnBatchDelete" Text="批量删除" Width="115" OnClientClick="return batchconfirm('确定要删除选中的记录吗？');"
                    OnClick="EBtnBatchDelete_Click" runat="server" />
                <asp:Button ID="BtnApply" Text="批量审核" Width="115" OnClick="BtnApply_Click" CausesValidation="False"
                    runat="server" />
                <asp:Button ID="BtnCancel" Text="批量取消审核" Width="115" OnClick="BtnCancel_Click" CausesValidation="False"
                    runat="server" />
            </td>
        </tr>
    </table>
    <br />
     <div style="padding-top: 5px;">
    <table style="width: 100%;" cellpadding="2" cellspacing="1" class="border">
        <tr>
            <td style="width: 80px" align="left" class="tdbg">
                <b>搜索选项：</b>
            </td>
            <td class="tdbg">
                <asp:DropDownList ID="DrpSearchType" runat="server">
                    <asp:ListItem Text="推广人" Value="1"></asp:ListItem>
                    <asp:ListItem Text="注册会员名" Value="2"></asp:ListItem>
                     <asp:ListItem Text="登录次数" Value="3"></asp:ListItem>
                </asp:DropDownList>
                &nbsp;
                <asp:TextBox ID="TxtFiled" runat="server" Width="80px" onkeypress="javascript:return DefaultButton(event)"></asp:TextBox>
                &nbsp; 注册时间： 从<pe:DatePicker ID="DpkStart" Width="100px" runat="server"></pe:DatePicker>  <pe:RegexValidator ID="VregDateStart" runat="server" 
                    ControlToValidate="DpkStart" Display="Dynamic" ErrorMessage="请输入正确的时间格式！" 
                    ValidateType="Date"></pe:RegexValidator>&nbsp;到&nbsp;<pe:DatePicker
                    ID="DpkEnd" runat="server" Width="100px"></pe:DatePicker><pe:RegexValidator ID="VregDateEnd" runat="server" 
                    ControlToValidate="DpkEnd" Display="Dynamic" ErrorMessage="请输入正确的时间格式！" 
                    ValidateType="Date"></pe:RegexValidator>&nbsp;
                <asp:Button ID="BtnSearch" runat="server" CssClass="inputbutton" Text=" 搜索 " OnClick="BtnSearch_Click"  />
               
              
                
            </td>
        </tr>
    </table>
    </div>
     <script type="text/javascript">
         function DefaultButton(event) {
             if (event.keyCode == 13 && !(event.srcElement && (event.srcElement.tagName.toLowerCase() == "textarea"))) {
                 var defaultButton = document.getElementById('<%= BtnSearch.ClientID %>');
                 if (defaultButton && typeof (defaultButton.click) != "undefined") {
                     defaultButton.click();
                     event.cancelBubble = true;
                     if (event.stopPropagation)
                         event.stopPropagation();
                     return false;
                 }
             }
             return true;
         }
    </script>
</asp:Content>
