﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.General.WebSite.Admin.Template.LabelManageUI" Title="标签管理"
    CodeBehind="LabelManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
    <br />
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr class="title">
            <td style="width: 88px">
                <strong>分类列表：</strong>
            </td>
            <td align="left">
                <a href="LabelManage.aspx">显示全部</a>
                <asp:Repeater ID="RptLabel" runat="server" DataSourceID="OdsLabelType">
                    <ItemTemplate>
                        | <a href="LabelManage.aspx?type=-1&labelCategory=<%# Server.UrlEncode(Eval("Name").ToString()) %>"><%# Eval("Name") %></a>
                    </ItemTemplate>
                </asp:Repeater>
                <asp:ObjectDataSource ID="OdsLabelType" runat="server" SelectMethod="GetLabelTypeList"
                    TypeName="PowerEasy.Module.General.BusinessLogic.Templates.LabelManage"></asp:ObjectDataSource>
            </td>
        </tr>
    </table>
    <br />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="GdvLabelList" AutoGenerateColumns="False" runat="server"
        DataSourceID="OdsLabel" DataKeyNames="name" AllowPaging="True" ItemName="标签"
        ItemUnit="个" AutoGenerateCheckBoxColumn="True" OnRowCommand="GdvLabelList_RowCommand"
        PageSize="20" CheckBoxFieldHeaderWidth="3%" SerialText="" OnRowDataBound="GdvLabelList_RowDataBound">
        <Columns>
            <pe:TemplateField HeaderText="名称">
                <ItemTemplate>
                    <a href="Label.aspx?type=<%# Server.UrlEncode(Eval("Type").ToString()) %>&name=<%# Server.UrlEncode(Eval("name").ToString()) %>" title='<%# Eval("Intro") %>'>
                        <span runat="server" id="spanLabelName">
                            <%# Eval("Name") %></span> </a>
                </ItemTemplate>
                <ItemStyle HorizontalAlign="Left" />
            </pe:TemplateField>
            <pe:BoundField DataField="Type" HeaderText="分类" SortExpression="Type">
                <HeaderStyle Width="15%" />
            </pe:BoundField>
            <pe:BoundField DataField="UpDateTime" HeaderText="更新时间" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}"
                SortExpression="UpDateTime" HtmlEncode="False">
                <HeaderStyle Width="18%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                    <a href="Label.aspx?type=<%# Server.UrlEncode(Eval("Type").ToString()) %>&name=<%# Server.UrlEncode(Eval("name").ToString()) %>">修改</a>
                    <asp:LinkButton ID="LinkButton1" runat="server" CausesValidation="False" CommandArgument='<%# Bind("name") %>'
                        CommandName="Edit">编辑</asp:LinkButton>
                    <asp:LinkButton ID="LbtnDelete" runat="server" CausesValidation="False" CommandArgument='<%# Eval("type").ToString() + "$$$" +  Eval("Name").ToString() %>'
                        CommandName="Deleted" OnClientClick="return confirm('是否删除本标签？')">删除</asp:LinkButton>
                    <asp:LinkButton ID="LbtnCopy" runat="server" CausesValidation="False" CommandArgument='<%# Bind("name") %>'
                        CommandName="Copy">复制</asp:LinkButton>
                    <asp:LinkButton ID="DownloadSingleLabel" runat="server" CausesValidation="False"
                        CommandArgument='<%# Bind("name") %>' CommandName="DownloadSingleLabel">下载</asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <span id="sameLabelNameMsg" runat="server" visible="false" style="color: Blue" enableviewstate="false">
        <br />
        注：<b style="color: Red">*红色加粗</b>名称的标签为有重复名称的标签，您需要搜索并修改他们。
        <br />
    </span>
    <span id="repeatLabelListMsg" runat="server" visible="false" style="color: Blue" enableviewstate="false">
        <br />
        注：重复的标签在前台调用的时候会按上面列表中的顺序调用第一个标签。
        <br />
    </span>
    <br />
    <asp:Button ID="BtnDel" runat="server" Text="批量删除" CausesValidation="False" OnClientClick="return batchconfirm('确实要删除选中的标签？');"
        OnClick="BtnDel_Click" />&nbsp;&nbsp;<asp:Button ID="BtnAdd" runat="server" Text="增加标签"
            OnClick="BtnAdd_Click" />&nbsp;&nbsp;
    <input id="InputUploadLabel" type="button" class="inputbutton" value="上传标签" onclick="javascript:window.open('LabelUpload.aspx','上传标签','width=600,height=250,resizable=0,scrollbars=yes');" />
    <pe:OneClickButton ID="DownloadLabelPackage" runat="server" Text="下载标签" OnClick="DownloadLabelPackage_Click"
        ToolTip="打包下载标签遵循：选中打包下载，分类打包下载，全部下载 的主次关系进行打包" IsOneClick="false" />
    <pe:OneClickButton ID="BtnDWplugin" runat="server" Text="生成Dreamweaver插件" OnClick="BtnDWplugin_Click" IsOneClick="false" />
    <pe:OneClickButton ID="BtnDw" runat="server" Text="生成Dreamweaver代码片断" OnClick="BtnDW_Click" IsOneClick="false" />
   <%-- <pe:OneClickButton ID="BtnXsltCompile" runat="server" IsOneClick="false" Text="编译标签" OnClick="BtnXsltCompile_Click"
        OnClientClick="return confirm('编译标签将提高前台访问的性能，编译通过后，应用程序将重启，确实要编译标签吗？');" />--%>
    <asp:ObjectDataSource ID="OdsLabel" runat="server" TypeName="PowerEasy.Module.General.BusinessLogic.Templates.LabelManage"
        SelectMethod="GetLabelList">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="type" QueryStringField="type" Type="Int32" />
            <asp:QueryStringParameter DefaultValue="0" Name="field" Type="Int32" QueryStringField="field" />
            <asp:QueryStringParameter DefaultValue="" Name="keyword" Type="string" QueryStringField="keyword" />
            <asp:QueryStringParameter DefaultValue="" Name="labelCategory" Type="string" QueryStringField="LabelCategory" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
