﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/Admin/MasterPage.master" ValidateRequest="false"
    CodeBehind="Department.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.User.DepartmentUI"
    Title="部门添加/修改" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <asp:ScriptManager ID="SmCategory" ScriptMode="release" runat="server" EnablePartialRendering="true">
        <Services>
            <asp:ServiceReference Path="~/WebServices/CategoryService.asmx" />
        </Services>
    </asp:ScriptManager>
    <script language="javascript" type="text/javascript">
        function GetInitial() {
            if ($get("<%= TxtDepartmentName.ClientID %>").value != "") {
                PowerEasy.Module.General.WebSite.WebServices.CategoryService.GetInitial($get("<%= DdlCategoryName.ClientID %>").value + $get("<%= TxtDepartmentName.ClientID %>").value, onInitial);
            }
        }

        function onInitial(value) {  
            if ($get("<%= TxtUploadDir.ClientID %>").disabled == false) {
                $get("<%= TxtUploadDir.ClientID %>").value = value;
                $get("<%= TxtNumber.ClientID %>").value = value;
            }
        }
    </script>
    <table style="width: 100%; margin: 0 auto;" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <strong>
                    <pe:AlternateLiteral ID="AltrTitle" Text="添加部门" AlternateText="修改部门" runat="Server" />
                </strong>
            </td>
        </tr>
        <tr class='tdbg'>
            <td style="width: 30%" align="right" class="tdbgleft">
                所属部门：
            </td>
            <td>
            <asp:DropDownList ID="DrpLParentDepartment" runat="server" Width="200px"></asp:DropDownList>
            </td>
        </tr>
        <tr class='tdbg' style='<%=m_IsSmartGov ? "" : "display:none" %>' >
            <td style="width: 30%" align="right" class="tdbgleft">
                所属分类：
            </td>
            <td>
                <asp:DropDownList ID="DdlCategoryName" Width="200px" runat="server">
                </asp:DropDownList>
                <span style="color:Red">*</span>
            </td>
        </tr>
        <tr class='tdbg'>
            <td class='tdbgleft' align='right' style="width: 30%;">
                部门名称：
            </td>
            <td>
                <asp:TextBox ID="TxtDepartmentName" runat="server" MaxLength="20" Width="200px"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValerDepartmentName" runat="server" ErrorMessage="部门名称不能为空！"
                    Display="Dynamic" ControlToValidate="TxtDepartmentName"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class='tdbg'>
            <td class='tdbgleft' align='right' style="width: 30%;">
                部门缩写：
            </td>
            <td>
                <asp:TextBox ID="Abbreviation" runat="server" MaxLength="20" Width="200px"></asp:TextBox>
                <span style="color: Blue">注：部门缩写默认为部门名称</span>
            </td>
        </tr>
        <tr id="Tr2" runat="server" class='tdbg'>
            <td class='tdbgleft' align='right' style="width: 30%;">
                上传目录：
            </td>
            <td>
                <asp:TextBox ID="TxtUploadDir" MaxLength="20" runat="server" Width="200px"></asp:TextBox>
                <span style="color: Blue"><pe:RequiredFieldValidator ID="ValrUploadDir"
                    ControlToValidate="TxtUploadDir" Display="Dynamic" ErrorMessage="目录名不能为空！"
                    SetFocusOnError="True" runat="server"></pe:RequiredFieldValidator><asp:RegularExpressionValidator ID="RegTxtUploadDir" runat="server" ControlToValidate="TxtUploadDir"
                        Display="Dynamic" ValidationExpression="[_a-zA-Z0-9]*" ErrorMessage="目录格式错误！"
                        SetFocusOnError="True"></asp:RegularExpressionValidator>注：目录只包含字母、数字、下划线</span>
            </td>
        </tr>
        <tr class='tdbg'>
            <td class='tdbgleft' align='right' style="width: 30%;">
                部门编号：
            </td>
            <td style="width: 60%">
                <asp:TextBox ID="TxtNumber" MaxLength="20" runat="server" Width="200px"></asp:TextBox>
                <span style="color: Blue"><pe:RequiredFieldValidator ID="RequiredFieldValidator1"
                    ControlToValidate="TxtNumber" Display="Dynamic" ErrorMessage="编号不能为空！"
                    SetFocusOnError="True" runat="server"></pe:RequiredFieldValidator><asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="TxtNumber"
                        Display="Dynamic" ValidationExpression="[-_a-zA-Z0-9]*" ErrorMessage="编号格式错误！"
                        SetFocusOnError="True"></asp:RegularExpressionValidator>注：编号只包含字母、数字、下划线、短横线</span>
            </td>
        </tr>
        <tr class='tdbg'>
            <td class='tdbgleft' align='right' style="width: 30%;">部门权重：</td>
            <td>
            <asp:TextBox ID="weight" MaxLength="10" runat="server" Text="0" Width="200px"></asp:TextBox>
            <span style="color: Blue">
            <pe:RegexValidator ID="validator1" runat="server" Display="Dynamic" ValidateType="Number" ControlToValidate="weight" ErrorMessage="必须填写数字！"></pe:RegexValidator>
            注：权重值越大越排前（默认：0）</span>
            </td>
        </tr>
        <tr class='tdbg'>
        <td class='tdbgleft' align="right" style='width:30%'>
            模板配置：
        </td>
        <td>
            <pe:TemplateSelectControl ID="CNTemplate" runat="server" Width="260px"></pe:TemplateSelectControl>
        </td>
        </tr>
        <tr class="tdbgbottom">
            <td colspan="2" align="center">
                <asp:Button ID="BtnSave" Text="保存" OnClick="BtnSave_Click" runat="server" />&nbsp;&nbsp;
                <input name="Cancel" type="button" class="inputbutton" id="Cancel" value="取消" onclick="Redirect('DepartmentManage.aspx')" />
            </td>
        </tr>
    </table>
    <div>
        <asp:HiddenField ID="HdnDepartmentId" runat="server" />
    </div>
</asp:Content>
