﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="PowerEasy.Module.General.WebSite.Admin.User.ValidLog"
    MasterPageFile="~/Admin/MasterPage.master" Title="会员有效期明细管理" Codebehind="ValidLog.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
<table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
  <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitAll" />>
                        <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="-1" onclick="ShowBookmarks"><span>全部</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitAdd" />>    
                       <asp:LinkButton ID="LinkAdd" runat="server" CommandArgument="2" onclick="ShowBookmarks"><span>添加</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitDeduct" />>    
                       <asp:LinkButton ID="LinkDeduct" runat="server" CommandArgument="3" onclick="ShowBookmarks"><span>扣除</span></asp:LinkButton>
                    </li>
                </ul>
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView ID="EgvUserValid" runat="server" AllowPaging="True" AutoGenerateColumns="False"
    DataKeyNames="LogId" DataSourceID="OdsUserValid" ItemName="记录" ItemUnit="条" OnRowDataBound="EgvUserValid_RowDataBound">
    <Columns>
        <pe:BoundField DataField="LogTime" HeaderText="时间" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}"
            SortExpression="LogTime" HtmlEncode="False">
            <HeaderStyle Width="17%" />
        </pe:BoundField>
        <pe:TemplateField HeaderText="用户名">
            <HeaderStyle Width="10%" />
            <ItemTemplate>
                <asp:HyperLink runat="server" ID="HypUserName"></asp:HyperLink>
            </ItemTemplate>
        </pe:TemplateField>
        <pe:BoundField DataField="IP" HeaderText="IP地址" SortExpression="IP">
            <HeaderStyle Width="13%" />
        </pe:BoundField>
        <pe:TemplateField HeaderText="有效期" SortExpression="IncomePayout">
            <HeaderStyle Width="8%" />
            <ItemTemplate>
                <pe:ExtendedLabel HtmlEncode="false" runat="server" Text='<%#GetIncomePayout(Convert.ToInt32(DataBinder.Eval(Container.DataItem,"IncomePayout")),Convert.ToInt32(DataBinder.Eval(Container.DataItem,"ValidNum")))%>'
                    ID="LblIncomePayOut">
                </pe:ExtendedLabel>
            </ItemTemplate>
        </pe:TemplateField>
        <pe:BoundField DataField="Inputer" HeaderText="操作员" SortExpression="Inputer" >
            <HeaderStyle Width="10%" />
        </pe:BoundField>
        <pe:TemplateField HeaderText="备注/说明">
            <ItemStyle HorizontalAlign="Left" />
            <ItemTemplate>
                <%# PowerEasy.Framework.Common.StringHelper.SubString(Eval("Remark").ToString(), 43, "...")%>
            </ItemTemplate>
        </pe:TemplateField>
        <pe:TemplateField HeaderText="操作" HeaderStyle-Width="5%">
            <ItemTemplate>
                <a href='<%#string.Format("ValidLogDetail.aspx?LogID={0}",Eval("LogId"))%>'>查看</a>
            </ItemTemplate>
        </pe:TemplateField>
    </Columns>
</pe:ExtendedGridView>
<asp:HiddenField ID="HdnSearchType" runat="server" />
<asp:HiddenField ID="HdnField" runat="server" />
<asp:HiddenField ID="HdnKeyword" runat="server" />
<asp:HiddenField ID="HdnType" runat="server" />
<asp:ObjectDataSource ID="OdsUserValid" runat="server" SelectMethod="GetValidList"
    SelectCountMethod="GetNumberOfValidList" TypeName="PowerEasy.Module.General.BusinessLogic.UserManage.UserValidLog"
    EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
    <SelectParameters>
        <asp:ControlParameter ControlID="HdnSearchType" DefaultValue="-1" Name="scopesType"
            Type="Int32" />
        <asp:ControlParameter ControlID="HdnField" DefaultValue="0" Name="field" Type="Int32" />
        <asp:ControlParameter ControlID="HdnKeyword" DefaultValue="" Name="keyword" Type="String" />
        <asp:ControlParameter ControlID="HdnType" DefaultValue="-1" Name="type" Type="Int32" />
    </SelectParameters>
</asp:ObjectDataSource>

    <br />
    <table width="100%" cellpadding="5" cellspacing="0" class="border">
        <tr class="tdbg">
            <td align="right" style="width: 10%;">
                时间范围：</td>
            <td align="left" style="width: 55%;">
                <asp:RadioButtonList ID="RadlDatepartType" runat="server" RepeatDirection="Horizontal">
                    <asp:ListItem Value="0" Selected="True">10天前</asp:ListItem>
                    <asp:ListItem Value="1">1个月前</asp:ListItem>
                    <asp:ListItem Value="2">2个月前</asp:ListItem>
                    <asp:ListItem Value="3">3个月前</asp:ListItem>
                    <asp:ListItem Value="4">6个月前</asp:ListItem>
                    <asp:ListItem Value="5">1年前</asp:ListItem>
                </asp:RadioButtonList></td>
            <td align="left">
                <asp:Button ID="BtnDelete" runat="server" OnClientClick="return confirm('确实要删除有关记录吗？一旦删除这些记录，会出现会员查看原来已经付过费的收费信息时重复收费等问题。请慎重！')"
                    Text="删除" OnClick="BtnDelete_Click" CausesValidation="False" />
            </td>
        </tr>
    </table>
    <div id="prompt-note">
        <dl>
        <dt class="prompt-note-tit">
        <span>提示说明</span>
        </dt>
            <dd class="prompt-note-con">
                  如果有效期明细记录太多，影响了系统性能，可以删除一定时间段前的记录以加快速度。但可能会带来会员在查看以前收过费的信息时重复收费（这样会引发众多消费纠纷问题），无法通过有效期明细记录来真实分析会员的消费习惯等问题。
            </dd>  
        </dl>
    </div>
</asp:Content>
