﻿<%@ Page Language="C#" AutoEventWireup="true" ValidateRequest="false" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Net" %>
<%@ Import Namespace="System.Xml" %>
<%@ Import Namespace="System.Web.Security" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>无标题页</title>

    <script runat="server" type="text/C#">
        protected void Page_Load(object sender, EventArgs e)
        {
            Stream proxyStream = Request.InputStream;
            
            string result = Request.ServerVariables["HTTP_X_FORWARDED_FOR"];
            if (string.IsNullOrEmpty(result))
            {
                result = Request.ServerVariables["REMOTE_ADDR"];
            }
           
            string siteUrl = "{$SiteUrl}Ajax.aspx";

            Uri url = new Uri(siteUrl);
            HttpWebRequest myHttpWebRequest = (HttpWebRequest)WebRequest.Create(url);
            myHttpWebRequest.Accept = "image/gif, image/x-xbitmap, image/jpeg, image/pjpeg,application/xaml+xml, */*";
            myHttpWebRequest.Headers.Add("Accept-Language:   zh-cn");
            
            byte[] byteData = new byte[proxyStream.Length];
            proxyStream.Read(byteData, 0, byteData.Length);
            if (byteData.Length>0)
            {
                try
                {
                    string postContent = Encoding.Default.GetString(byteData, 0, byteData.Length);
                    XmlDocument xmldoc = new XmlDocument();
                    xmldoc.LoadXml(postContent);
                    XmlElement element = xmldoc.CreateElement("userip");
                    element.InnerText = result;
                    XmlNode node = xmldoc.LastChild;
                    node.AppendChild(element);
                    postContent = xmldoc.InnerXml;
                    byteData = Encoding.Default.GetBytes(postContent);
                    node = xmldoc.SelectSingleNode("//username");
                    if (node != null)
                    {
                        Session["UserName"] = node.Value;
                    }
                }
                catch { }
            }
           
            
            myHttpWebRequest.Method = "POST";
            myHttpWebRequest.ContentType = "application/x-www-form-urlencoded";
            myHttpWebRequest.ContentLength = byteData.Length;
            myHttpWebRequest.CookieContainer = new CookieContainer();
            CookieCollection cookieCollection = new CookieCollection();
            foreach (string cookieName in Request.Cookies)
            {
                Cookie cookie = new Cookie();
                cookie.Name = Request.Cookies[cookieName].Name;
                cookie.Value = Request.Cookies[cookieName].Value;
                cookie.Expires = Request.Cookies[cookieName].Expires;
                cookie.Domain = "{$MainDomain}";
                cookieCollection.Add(cookie);
            }
            myHttpWebRequest.CookieContainer.Add(cookieCollection);

            using (Stream requestStream = myHttpWebRequest.GetRequestStream())
            {
                requestStream.Write(byteData, 0, byteData.Length);
            }

            HttpWebResponse myHttpWebResponse = (HttpWebResponse)myHttpWebRequest.GetResponse();
            foreach (Cookie cookie in myHttpWebResponse.Cookies)
            {
                Response.Cookies[cookie.Name].Value = cookie.Value;
                Response.Cookies[cookie.Name].Expires = cookie.Expires;
                Response.Cookies[cookie.Name].Domain = cookie.Domain;
            }
            Stream receiveStream = myHttpWebResponse.GetResponseStream();
            StreamReader readStream = new StreamReader(receiveStream, Encoding.UTF8);
            string msg = readStream.ReadToEnd();
            readStream.Close();
            Response.Clear();
            Response.Buffer = true;
            Response.Charset = "utf-8";
            Response.AddHeader("contenttype", "text/xml");
            Response.ContentEncoding = Encoding.GetEncoding("utf-8");
            Response.ContentType = "text/xml";
            Response.Write(msg);
            Response.End();
        }
    </script>

</head>
</html>
