﻿<%@ Page Language="C#" Inherits="PowerEasy.Foundation.Web.UI.BasePage"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<script runat="server">
protected void Page_Load(object sender, EventArgs e)
    {
        string payOnlineShopID;
        string PayOnlineKey;

        int payPlatformId = 1;  //网银在线
        PowerEasy.Module.General.Model.Accessories.PayPlatformInfo payPlatform = PowerEasy.Module.General.BusinessLogic.Accessories.PayPlatform.GetPayPlatformById(payPlatformId);
        if (payPlatform.IsDisabled || payPlatform.MD5 == "3069" || string.IsNullOrEmpty(payPlatform.MD5))
        {
            Response.Write(Resources.DynamicPageResources.PayOnline_PayResult99bill_ToPayNo);
            return;
        }
        payOnlineShopID = payPlatform.AccountsId;
        PayOnlineKey = payPlatform.MD5;
        Page.Request.ContentEncoding = Encoding.GetEncoding("gb2312");
       string v_mid, v_oid, v_pmode, v_pstatus, v_pstring, v_amount, v_md5, v_moneytype;
    
        v_mid = payOnlineShopID;
        v_oid = Request["v_oid"].Trim();
        v_md5 = Request["v_md5str"].Trim();            //数字签名
        v_amount = Request["v_amount"].Trim();         //支付金额
        v_pstatus = Request["v_pstatus"].Trim();       //支付状态
        v_moneytype = Request["v_moneytype"].Trim();   //支付币种
        //v_pmode = Server.(Request["v_pmode"].Trim());           //支付银行
        //v_pstring = Server.UrlEncode(Request["v_pstring"].Trim());       //支付结果说明
        v_pmode = "";
        v_pstring = "";
        string md5string = PowerEasy.Framework.Common.DataCrypto.MD5(v_oid + v_pstatus + v_amount + v_moneytype + PayOnlineKey);

        StringBuilder message = new StringBuilder();
        bool payResult = false;
        if (md5string.ToUpper() == v_md5.ToUpper() && v_pstatus == "20")
        {
            message.Append(Resources.DynamicPageResources.PayOnline_PayResultChinabank_ToPayYes);
            payResult = true;
        }
        else
        {
            message.Append(Resources.DynamicPageResources.PayOnline_PayResultChinabank_ToPayNo);
        }
        if (payResult)
        {
            PowerEasy.Module.Shop.BusinessLogic.PayOnline payOnline = new PowerEasy.Module.Shop.BusinessLogic.PayOnline();
            PowerEasy.Module.General.Enumerations.Accessories.PayOnlineState payOnlineState = payOnline.UpdateOrder(v_oid, PowerEasy.Framework.Common.DataConverter.ToDecimal(v_amount), v_pstring, 3, v_pmode, true, true);
            if (payOnlineState == PowerEasy.Module.General.Enumerations.Accessories.PayOnlineState.Ok)
            {
                message.Append(payOnline.Message);
            }
            else
            {
                message.Append(PowerEasy.Module.Shop.BusinessLogic.PayOnline.GetStateDescription(payOnlineState));
            }
        }
        LblMsg.Text = message.ToString();
        PowerEasy.Module.Shop.BusinessLogic.PayOnline.TestLog(false, Resources.DynamicPageResources.PayOnline_PayResultChinabank_FastToPay, v_pstatus, v_md5.ToUpper(), md5string.ToUpper());
    }
</script>
<html xmlns="http://www.w3.org/1999/xhtml" >
<head id="Head1" runat="server">
    <title><asp:Localize ID="Localize1" Text="<%$ Res: PayOnline_PayResultChinabank_Page , 网银在线 %>" runat="server" /></title>
</head>
<body>
    <form id="form1" runat="server">
    <div>
         <pe:ExtendedLabel HtmlEncode="false" ID="LblMsg" runat="server"></pe:ExtendedLabel>
    </div>
    </form>
</body>
</html>
