﻿<%@ Page Language="C#" Inherits="PowerEasy.Foundation.Web.UI.BasePage"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<script runat="server">
    protected void Page_Load(object sender, EventArgs e)
    {
        string payOnlineShopID;
        string PayOnlineKey;

        int payPlatformId = 2;  //中国在线支付
        PowerEasy.Module.General.Model.Accessories.PayPlatformInfo payPlatform = PowerEasy.Module.General.BusinessLogic.Accessories.PayPlatform.GetPayPlatformById(payPlatformId);
        if (payPlatform.IsDisabled || payPlatform.MD5 == "3056" || string.IsNullOrEmpty(payPlatform.MD5))
        {
            LblMsg.Text = Resources.DynamicPageResources.PayOnline_PayResult99bill_ToPayNo;
            return;
        }

        payOnlineShopID = payPlatform.AccountsId;
        PayOnlineKey = payPlatform.MD5;

        string v_mid = payOnlineShopID;
        string v_date = Request["v_date"].Trim();    //订单日期
        string v_oid = Request["v_oid"].Trim();       //支付订单号
        string v_amount = Request["v_amount"].Trim();     //订单金额
        string v_pstatus = Request["v_pstatus"].Trim();  //订单状态
        string v_md5 = Request["v_md5"].Trim();            //MD5签名

        StringBuilder md5string = new StringBuilder();
        md5string.Append(v_date);
        md5string.Append(v_mid);
        md5string.Append(v_oid);
        md5string.Append(v_amount);
        md5string.Append(v_pstatus);
        md5string.Append(PayOnlineKey);
        string md5 = PowerEasy.Framework.Common.DataCrypto.MD5(md5string.ToString());

        bool paySuccess = false;
        if (v_md5.ToUpper() == md5.ToUpper() && v_pstatus == "00")
        {
            paySuccess = true;

        }
        if (paySuccess)
        {
            string prefix_PaymentNum = PowerEasy.Foundation.SiteConfig.ShopConfig.PrefixPaymentNum;    //支付序号前缀
            v_oid = prefix_PaymentNum + v_oid;

            StringBuilder message = new StringBuilder();
            message.Append(Resources.DynamicPageResources.PayOnline_PayResultIpay_ToPayYes);
            PowerEasy.Module.Shop.BusinessLogic.PayOnline payOnline = new PowerEasy.Module.Shop.BusinessLogic.PayOnline();
            PowerEasy.Module.General.Enumerations.Accessories.PayOnlineState payOnlineState = payOnline.UpdateOrder(v_oid, PowerEasy.Framework.Common.DataConverter.ToDecimal(v_amount), "", 3, "", true, true);
            if (payOnlineState == PowerEasy.Module.General.Enumerations.Accessories.PayOnlineState.Ok)
            {
                message.Append(payOnline.Message);
            }
            else
            {
                message.Append(PowerEasy.Module.Shop.BusinessLogic.PayOnline.GetStateDescription(payOnlineState));
            }
            LblMsg.Text = message.ToString();
        }
        else
        {
            LblMsg.Text = Resources.DynamicPageResources.PayOnline_PayResultIpay_ToPayNo;
        }
        PowerEasy.Module.Shop.BusinessLogic.PayOnline.TestLog(false, Resources.DynamicPageResources.PayOnline_PayResultCncard_FastToPay, v_pstatus, v_md5.ToUpper(), md5.ToUpper());
    }      
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title><asp:Localize ID="Localize1" Text="<%$ Res: PayOnline_PayResultIpay_Page , 中国在线支付 %>" runat="server" /></title>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <pe:ExtendedLabel HtmlEncode="false" ID="LblMsg" runat="server"></pe:ExtendedLabel>
        </div>
    </form>
</body>
</html>
