﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="PowerEasy.Foundation.Web.UI.BasePage"%>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Net.Mail" %>
<%@ Import Namespace="PowerEasy.Foundation" %>
<%@ Import Namespace="PowerEasy.Module.Shop.BusinessLogic" %>
<%@ Import Namespace="PowerEasy.Module.Shop.Model" %>
<%@ Import Namespace="PowerEasy.Module.General.Model.Accessories" %>
<%@ Import Namespace="PowerEasy.Framework.Components" %>
<%@ Import Namespace="PowerEasy.Module.General.BusinessLogic.UserManage" %>
<%@ Import Namespace="PowerEasy.Framework.Common" %>
<%@ Import Namespace="PowerEasy.Module.General.Model.UserManage" %>
<%@ Import Namespace="PowerEasy.Framework.Components.SmtpMail" %>
<%@ Import Namespace="PowerEasy.Module.General.Enumerations.Accessories" %>
<%@ Import Namespace="PowerEasy.Module.General.BusinessLogic.Accessories" %>
<%@ Import Namespace="PowerEasy.Module.General.Enumerations.CommonModel" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head id="Head1" runat="server">
    <title><asp:Localize ID="Localize1" Text="<%$ Res: PayOnline_ShowResult_Page , 在线支付成功 %>" runat="server" /></title>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <br />
        <br />
        <pe:ExtendedLabel HtmlEncode="false" ID="LblResult" runat="server" Text="<%$ Res: PayOnline_ShowResult_LblResult , 在线支付成功 %>"></pe:ExtendedLabel>
    </div>
    </form>
</body>
</html>
<script runat="server">
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {            
            if(Request.QueryString["PayMessage"] == "ok")
            {
                LblResult.Text = Resources.DynamicPageResources.PayOnline_ShowResult_ToPayYes;
                int orderId = 0;
                if (!string.IsNullOrEmpty(Request.QueryString["PaymentNum"]))
                {
                    orderId = PowerEasy.Framework.Common.DataConverter.ToInt32(PowerEasy.Module.General.BusinessLogic.Accessories.PaymentLog.GetInfoByPaymentNum(Request.QueryString["PaymentNum"]).OrderId);
                }
                if (orderId > 0)
                {
                    // 是否存在充值卡
                    //
                    bool haveCard = false;
                    string orderCardNum = string.Empty;
                    string title = Resources.DynamicPageResources.PayOnline_ShowResult_OrderSendCard;//充值卡交付通知
                    
                    IList<OrderItemInfo> lstOrderItem = OrderItem.GetInfoListByOrderId(orderId);
                    OrderInfo order = Order.GetOrderById(orderId);
                    
                    // 循环获取订单详细信息,并且得到卡信息
                    //
                    foreach (OrderItemInfo orderItem in lstOrderItem)
                    {
                        if (Product.CharacterIsExists(orderItem.ProductCharacter, ProductCharacter.Card))
                        {
                            CardInfo cardInfo = Cards.GetCardByOrderItemId(orderItem.ProductId, orderItem.TableName, orderItem.ItemId);
                            if (!cardInfo.IsNull)
                            {
                                haveCard = true;
                                orderCardNum += " 卡号:" + cardInfo.CardNum + ",密码:"+cardInfo.Password+";";
                            }
                        }
                    }
                    // 如果存在充值卡
                    //
                    if (haveCard)
                    {
                        // 发送站内信
                        //
                        if (SiteConfig.ShopConfig.CardOnlinePayMessage)
                        {
                            MessageInfo message = new MessageInfo();
                            message.Incept = order.UserName;
                            message.IsDelInbox = 0;
                            message.IsDelSendbox = 0;
                            message.SendTime = DateTime.Now;
                            message.Title = title;
                            message.Content = orderCardNum;
                            try
                            {
                                Message.Add(message);
                            }
                            catch{}
                        }
                        // 发送手机信息
                        //
                        if (SiteConfig.ShopConfig.CardOnlinePayMobilePhone)
                        {
                            try
                            {
                                SmsMessage.SendMessage(order.UserName,orderCardNum,"0","","系统");
                            }
                            catch{}
                        }
                        // 发送邮件
                        //
                        if (SiteConfig.ShopConfig.CardOnlinePayMail)
                        {
                            SmtpMailSender mailSender = new SmtpMailSender(SiteConfig.MailConfig);

                            MailState mailcode    = new MailState();
                            mailSender.MailBody   = orderCardNum;
                            mailSender.Subject    = title;
                            mailSender.IsBodyHtml = true;
                            if (!string.IsNullOrEmpty(order.Email) && DataValidator.IsEmail(order.Email))
                            {
                                mailSender.MailToAddressList.Add(new MailAddress(order.Email));
                                try
                                {
                                    mailcode = mailSender.Send();
                                }
                                catch{}
                            }
                        }
                    }
                    LblResult.Text = LblResult.Text + "<br><a href='../User/Shop/ShowOrder.aspx?OrderId=" + orderId.ToString() + "'>" + Resources.DynamicPageResources.PayOnline_ShowResult_LookOrdersInfo + "</a>";
                }
                else
                {
                    LblResult.Text = LblResult.Text + "<br><a href='../User/Info/PaymentLog.aspx'>" + Resources.DynamicPageResources.PayOnline_ShowResult_LookToPayRecord + "</a>";
                }
            }
            else
            {
                LblResult.Text = Resources.DynamicPageResources.PayOnline_ShowResult_ToPayNo;
            }
        }
    }
</script>