﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Signin.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.User.Content.SignIn" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
    <div class="model_info_list">
        <div class="model_info_sate mtop10">
            <ul>
                <li class="hover"><span><a href="javascript:void(0)">
                    <asp:Localize ID="Localize4" Text="<%$ Res: User_Contents_Signin_Page,我签收的信息 %>"
                        runat="server" /></a></span></li>
            </ul>
        </div>
        <div class="model_info_content">
            <pe:MemberExtendedGridView ID="EgvContentSignIn" runat="server" DataSourceID="OdsContents"
                SerialText="" AutoGenerateCheckBoxColumn="True" AutoGenerateColumns="False" AllowPaging="True"
                OnRowDataBound="EgvContentSignIn_RowDataBound" OnRowCommand="EgvContentSignIn_RowCommand"
                DataKeyNames="GeneralId" CheckBoxFieldHeaderWidth="3%">
                <Columns>
                    <pe:BoundField DataField="GeneralId" HeaderText="ID" SortExpression="GeneralId">
                        <HeaderStyle Width="5%" />
                    </pe:BoundField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Contents_Signin_TemplateField1,标题 %>"
                        SortExpression="Title">
                        <ItemStyle CssClass="content_left" />
                        <ItemTemplate>
                            <pe:LinkImage ID="LinkImageModel" runat="server">
                                <pe:ExtendedHyperLink ID="LnkNodeLink" runat="server" />
                                <asp:HyperLink ID="HypTitle" NavigateUrl='<%# FullBasePath %>Item/<%#Eval("GeneralId") %>.aspx'
                                    Text='<%# Eval("Title").ToString().Length <= 20 ? Eval("Title") : Eval("Title").ToString().Substring(0, 20) + ".."%>'
                                    runat="server" />
                            </pe:LinkImage>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:BoundField DataField="Inputer" HeaderText="<%$ Res: User_Contents_Signin_BoundField2,录入者 %>"
                        SortExpression="Inputer">
                        <HeaderStyle Width="7%" HorizontalAlign="Center" />
                    </pe:BoundField>
                    <pe:BoundField DataField="Hits" HeaderText="<%$ Res: User_Contents_Signin_BoundField3,点击数 %>"
                        SortExpression="Hits">
                        <HeaderStyle Width="7%" HorizontalAlign="Center" />
                    </pe:BoundField>
                    <pe:BoundField DataField="EliteLevel" HeaderText="<%$ Res: User_Contents_Signin_BoundField4,推荐级别 %>"
                        SortExpression="EliteLevel">
                        <HeaderStyle Width="8%" HorizontalAlign="Center" />
                    </pe:BoundField>
                    <pe:BoundField DataField="Priority" HeaderText="<%$ Res: User_Contents_Signin_BoundField5,优先级 %>"
                        SortExpression="Priority">
                        <HeaderStyle Width="7%" HorizontalAlign="Center" />
                    </pe:BoundField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Contents_Signin_TemplateField2,签收状态 %>"
                        SortExpression="Status">
                        <HeaderStyle Width="8%" HorizontalAlign="Center" />
                        <ItemTemplate>
                            <pe:ExtendedLabel HtmlEncode="false" ID="LblSignInStatus" runat="Server"></pe:ExtendedLabel>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Contents_Signin_TemplateField3,操作 %>"
                        SortExpression="Disabled">
                        <HeaderStyle Width="8%" HorizontalAlign="Center" />
                        <ItemTemplate>
                            <pe:ExtendedNodeLinkButton ID="ELbtnContentSignIn" Text="<%$ Res: User_Contents_Signin_ELbtnContentSignIn,签收 %>"
                                IsChecked="false" runat="server" CommandArgument='<%# Eval("GeneralId")%>' CommandName="SignIn" />
                        </ItemTemplate>
                    </pe:TemplateField>
                </Columns>
            </pe:MemberExtendedGridView>
        </div>
        <asp:HiddenField ID="HdnListType" runat="server" Value="-1" />
        <asp:ObjectDataSource ID="OdsContents" runat="server" SelectMethod="GetCommonModelInfoListBySignInLog"
            SelectCountMethod="GetTotalOfCommonModelInfoBySignInLog" TypeName="PowerEasy.Module.General.BusinessLogic.Contents.ContentManage"
            EnablePaging="True" MaximumRowsParameterName="maxNumberRows" StartRowIndexParameterName="startRowIndexId">
            <SelectParameters>
                <asp:Parameter Name="userName" Type="String" DefaultValue="" />
            </SelectParameters>
        </asp:ObjectDataSource>
    </div>
    <div class="clear">
    </div>
    <div class="model_list_manage">
        <label for="ChkAll" class="checkbox">
        <input id="ChkAll" type="checkbox" />
            <asp:Localize ID="Localize1" Text="<%$ Res: User_Contents_Signin_Localize1,全选 %>"
                runat="server" /></label>
        <pe:ExtendedNodeButton CssClass="input_button_six" ID="EBtnSignIn" OnClientClick="return batchconfirm();" Text="<%$ Res: User_Contents_Signin_EBtnSignIn,批量签收 %>"
            IsChecked="false" runat="server" OnClick="EBtnSignIn_Click" />
    </div>
    </form>
</body>
</html>
