﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="PaymentLog.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.User.Info.PaymentLog" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
    <div class="model_info_sate mtop10">
        <ul>
            <li class="hover"><span><a href="javascript:void(0)">
                <asp:Localize ID="Localize1" Text=" <%$ Res: User_Info_PaymentLog_Page, 在线支付记录 %>"
                    runat="server" /></a></span></li>
        </ul>
    </div>
    <div class="model_info_content">
        <pe:MemberExtendedGridView ID="EgvPayment" runat="server" AutoGenerateColumns="False"
            CheckBoxFieldHeaderWidth="3%" DataSourceID="OdsPayment" SerialText="" OnRowDataBound="EgvPayment_RowDataBound"
            AllowPaging="True">
            <Columns>
                <pe:BoundField DataField="PaymentNum" HeaderText="<%$ Res: User_Info_PaymentLog_BoundField1,支付序号 %>"
                    SortExpression="PaymentNum">
                    <HeaderStyle Width="16%" />
                </pe:BoundField>
                <pe:TemplateField HeaderText="<%$ Res: User_Info_PaymentLog_TemplateField1,支付平台 %>"
                    SortExpression="PlatformId">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="LblPlatform"></asp:Label>
                    </ItemTemplate>
                    <HeaderStyle Width="10%" />
                </pe:TemplateField>
                <pe:BoundField DataField="PayTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HeaderText="<%$ Res: User_Info_PaymentLog_BoundField2,交易时间 %>"
                    HtmlEncode="False" SortExpression="PayTime">
                    <HeaderStyle Width="16%" />
                </pe:BoundField>
                <pe:BoundField DataField="MoneyPay" DataFormatString="{0:N2}" HeaderText="<%$ Res: User_Info_PaymentLog_BoundField3,汇款金额 %>"
                    SortExpression="MoneyPay" HtmlEncode="False">
                    <ItemStyle HorizontalAlign="right" />
                    <HeaderStyle Width="10%" />
                </pe:BoundField>
                <pe:BoundField DataField="MoneyTrue" DataFormatString="{0:N2}" HeaderText="<%$ Res: User_Info_PaymentLog_BoundField4,实际转账金额 %>"
                    SortExpression="MoneyTrue" HtmlEncode="False">
                    <ItemStyle HorizontalAlign="right" />
                    <HeaderStyle Width="14%" />
                </pe:BoundField>
                <pe:TemplateField HeaderText="<%$ Res: User_Info_PaymentLog_TemplateField2,交易状态 %>"
                    SortExpression="Status">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="LblStatus"></asp:Label>
                    </ItemTemplate>
                    <HeaderStyle Width="10%" />
                </pe:TemplateField>
                <pe:BoundField DataField="PlatformInfo" HeaderText="<%$ Res: User_Info_PaymentLog_BoundField5,银行信息 %>"
                    SortExpression="PlatformInfo">
                    <HeaderStyle Width="10%" />
                </pe:BoundField>
                <pe:BoundField DataField="Remark" HeaderText="<%$ Res: User_Info_PaymentLog_BoundField6,备注 %>"
                    SortExpression="Remark" />
            </Columns>
        </pe:MemberExtendedGridView>
    </div>
    <br />
    <asp:Button ID="btnPayPlatform" CssClass='submit_button_four' runat="server" OnClick="btnPayPlatform_OnClick"
        Text="在线支付" />
    <asp:ObjectDataSource ID="OdsPayment" runat="server" SelectMethod="GetListByUserName"
        TypeName="PowerEasy.Module.General.BusinessLogic.Accessories.PaymentLog" EnablePaging="True"
        MaximumRowsParameterName="maxNumberRows" SelectCountMethod="GetTotalOfPaymentLogByUserName"
        StartRowIndexParameterName="startRowIndexId">
        <SelectParameters>
            <asp:ControlParameter ControlID="HdnUserName" DefaultValue="" Name="userName" PropertyName="Value"
                Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:HiddenField ID="HdnUserName" runat="server" />
    </form>
</body>
</html>
