﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="MessageManager.aspx.cs"
    Inherits="PowerEasy.Module.General.WebSite.User.Message.MessageManager" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
    <div class="model_info_sate mtop10">
        <ul>
            <li id="TabTitle0"><span><a href="###" onclick="ShowTabs(0)">
                <asp:Literal ID="Literal1" runat="server" Text="<%$ Res: User_Message_MessageManager_AllMessage,所有短消息 %>" />
            </a></span></li>
            <li id="TabTitle1"><span><a href="###" onclick="ShowTabs(1)">
                <asp:Literal ID="Literal2" runat="server" Text="<%$ Res: User_Message_MessageManager_NoRead,未读短消息 %>" />
            </a></span></li>
            <li id="TabTitle2"><span><a href="###" onclick="ShowTabs(2)">
                <asp:Literal ID="Literal3" runat="server" Text="<%$ Res: User_Message_MessageManager_IsRead,已读短消息 %>" />
            </a></span></li>
        </ul>
    </div>
    <asp:PlaceHolder ID="userMessageList" runat="server">
        <asp:HiddenField ID="HdnTabId" runat="server" Value="0" />
        <pe:MemberExtendedGridView ID="GdvMessageList" runat="server" DataKeyNames="MessageId"
            AllowPaging="True" ItemName="<%$ Res: Controls_ShowMessageList_GdvMessageList_ItemName ,短消息 %>"
            AutoGenerateColumns="False" AutoGenerateCheckBoxColumn="True" OnRowDataBound="GdvMessageList_RowDataBound"
            OnRowCommand="GdvMessageList_RowCommand" OnPageIndexChanging="GdvMessageList_PageIndexChanging"
            DataSourceID="OdsMessageList" CheckBoxFieldHeaderWidth="3%" SerialText="" OnDataBound="GdvMessageList_DataBound">
            <Columns>
                <pe:TemplateField HeaderText="<%$ Res: Controls_ShowMessageList_TemplateField1 ,短消息主题 %>"
                    ShowHeader="False">
                    <ItemStyle CssClass="content_left" />
                    <ItemTemplate>
                        <asp:HyperLink runat="server" ID="HlnkMessage" ToolTip='<%# Eval("Title").ToString()%>'
                            Text='<%# Eval("Title").ToString().Length <= 22 ? Eval("Title") : Eval("Title").ToString().Substring(0, 22) + ".."%>'
                            NavigateUrl='<%# Eval("MessageID","MessageRead.aspx?MessageID={0}") %>'></asp:HyperLink></ItemTemplate>
                </pe:TemplateField>
                <pe:BoundField DataField="Incept" HeaderText="<%$ Res: Controls_ShowMessageList_BoundField1 ,收件人 %>" />
                <pe:BoundField DataField="Sender" HeaderText="<%$ Res: Controls_ShowMessageList_BoundField2 ,发件人 %>" />
                <pe:TemplateField HeaderText="<%$ Res: Controls_ShowMessageList_TemplateField2 ,发送日期 %>"
                    SortExpression="SendTime">
                    <HeaderStyle Width="150" />
                    <ItemTemplate>
                        <%# Eval("SendTime", "{0:yyyy-MM-dd HH:mm:ss}")%>
                    </ItemTemplate>
                </pe:TemplateField>
                <pe:TemplateField HeaderText="<%$ Res: Controls_ShowMessageList_TemplateField3 ,大小 %>"
                    SortExpression="Content">
                    <HeaderStyle Width="100" />
                    <ItemStyle HorizontalAlign="Right" />
                    <ItemTemplate>
                        <%# Eval("Content").ToString().Length +" Byte"%>
                    </ItemTemplate>
                </pe:TemplateField>
                <pe:TemplateField HeaderText="<%$ Res: Controls_ShowMessageList_TemplateField4 ,已读 %>">
                    <HeaderStyle Width="50" />
                    <ItemTemplate>
                        <%# Convert.ToInt32(Eval("IsRead")) == 0 ? "<font color=red>×</font>" : "√"%>
                    </ItemTemplate>
                </pe:TemplateField>
                <pe:TemplateField HeaderText="<%$ Res: Controls_ShowMessageList_TemplateField5 ,操作 %>">
                    <HeaderStyle Width="50" />
                    <ItemTemplate>
                        <asp:LinkButton ID="LbtnDelete" runat="server" CausesValidation="False" CommandArgument='<%# Eval("MessageID") %>'
                            CommandName="Del" OnClientClick='<%$ Res: Controls_ShowMessageList_LbtnDelete_OnClientClick ,return confirm("是否删除此短消息?") %>'
                            Text="<%$ Res: Controls_ShowMessageList_LbtnDelete ,删除 %>"></asp:LinkButton>
                    </ItemTemplate>
                </pe:TemplateField>
            </Columns>
        </pe:MemberExtendedGridView>
        <asp:ObjectDataSource ID="OdsMessageList" runat="server" SelectMethod="GetMessageList"
            SelectCountMethod="Count" TypeName="PowerEasy.Module.General.BusinessLogic.Accessories.Message"
            EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
            <SelectParameters>
                <asp:ControlParameter ControlID="HdnSearchField" DefaultValue="0" Name="searchField"
                    PropertyName="Value" />
                <asp:ControlParameter ControlID="HdnKeyword" DefaultValue="" Name="keyword" PropertyName="Value" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:HiddenField ID="HdnSearchField" runat="server" />
        <asp:HiddenField ID="HdnKeyword" runat="server" />
        <asp:HiddenField ID="HdnManageType" runat="server" Value="0" />
        <br />
    </asp:PlaceHolder>
    <asp:PlaceHolder ID="operate" runat="server">
        <label for="ChkAll" class="checkbox">
            <input id="ChkAll" type="checkbox" />
            <asp:Localize ID="Localize2" Text="<%$ Res: Controls_ShowMessageList_Localize1 ,全选 %>"
                runat="server" /></label>
        <asp:Button ID="BtnDelete" runat="server" CssClass="input_button_eight" Text="<%$ Res: Controls_ShowMessageList_BtnDelete ,删除选定的短消息 %>"
            OnClientClick="return batchconfirm('是否删除选定的短消息？');" OnClick="BtnDelete_Click"
            CausesValidation="False" />
        <asp:Button ID="BtnDeleteAll" CssClass="input_button_five" runat="server" OnClick="BtnDeleteAll_Click"
            OnClientClick="<%$ Res: Controls_ShowMessageList_BtnDeleteAll_OnClientClick ,return confirm('确定要清空短消息吗') %>" />&nbsp;<br />
    </asp:PlaceHolder>
    <p id="javascript" runat="server">
        <script language="javascript" type="text/javascript">
            Request = {
                QueryString: function (item) {
                    var svalue = location.search.match(new RegExp("[\?\&]" + item + "=([^\&]*)(\&?)", "i"));
                    return svalue ? svalue[1] : svalue;
                }
            }
            if (Request.QueryString("managetype") == "1") {
                document.getElementById("TabTitle1").style.display = "none";
                document.getElementById("TabTitle2").style.display = "none";

            }
            var hdnTabId = document.getElementById('<%=HdnTabId.ClientID%>');
            function ShowTabs(ID) {
                var tID = parseInt(hdnTabId.value);
                if (ID != tID) {
                    hdnTabId.value = ID.toString();
                    __doPostBack("ClientDoPostBack", ID.toString());
                }
            }
            document.getElementById("TabTitle" + hdnTabId.value).className = "hover";
        </script>
    </p>
    <div class="model_list_manage">
        <div class="search_box">
            <strong>
                <asp:Localize ID="Localize1" Text="<%$ Res: User_Message_MessageManager_Localize1,短消息搜索： %>"
                    runat="server" /></strong>
            <asp:DropDownList ID="DropSearch" runat="server">
                <asp:ListItem Value="1" Text="<%$ Res: User_Message_MessageManager_ListItem6,短消息主题 %>"></asp:ListItem>
                <asp:ListItem Value="2" Text="<%$ Res: User_Message_MessageManager_ListItem7,短消息内容 %>"></asp:ListItem>
            </asp:DropDownList>
            <asp:TextBox ID="TxtKeyword" CssClass="inputxt" runat="server"></asp:TextBox>
            <pe:RequiredFieldValidator ID="ValrKeyword" runat="server" Display="Dynamic" ValidationGroup="2"
                ControlToValidate="TxtKeyWord" ErrorMessage="RequiredFieldValidator" SetFocusOnError="True">
                <asp:Localize ID="Localize3" Text="<%$ Res: User_Message_MessageManager_Localize3,请输入搜索的关键字！ %>" runat="server" />
            </pe:RequiredFieldValidator>
            <pe:ExtendedButton IsChecked="false" OperateCode="None" ID="BtnSubmit" ValidationGroup="2"
                CssClass="input_button_four" runat="server" Text="<%$ Res: User_Message_MessageManager_BtnSubmit,搜索 %>" />
        </div>
    </div>
    </form>
</body>
</html>
