/*--------------------------------------------------------------
check
所有检查函数如果通过返回true, 失败返回false
*/
//用户名必须是1～20个字节间的数字、字母或汉字(1汉字=2字节)
window.checkName = function(name) {
    str = name.replace(/[\u4e00-\u9fa5]/g, '00');
    exp = /^([a-zA-Z0-9]|[._\-]){1,20}$/;
    return exp.test(str);
};

//用户名首字符只能是英文、数字或汉字
window.checkNameFirstWord = function (name) {
    if (name.indexOf("-") == 0 || name.indexOf("_") == 0 || name.indexOf(".") == 0) {
        return false;
    }
    return true;
};

//匹配由数字、26个英文字母或者下划线组成的字符串
window.checkLimitChar = function (str) {
    exp = /^\w+$/;
    return exp.test(str);
};

//email检查
window.checkEmail = function (str) {
    exp = /^[A-Za-z0-9]+([-*_*.][A-Za-z0-9]+)*@[A-Za-z0-9]+([-.]\w+)*(\.)(com|com\.cn|net|cn|net\.cn|org|biz|info|gov|gov\.cn|edu|edu\.cn)$/;
    return exp.test(str);
};

//手机号检查(包括13 15 18 开头号码以及小灵通号码)
window.checkMobilePhone = function (phone) {
    exp1 = /^(13|14|15|18)\d{9}$/;
    exp2 = /^0\d{10,11}$/;
    if (exp1.test(phone) || exp2.test(phone)) {
        return true;
    }
    return false;
};

//中国移动手机号检查(包括134、135、136、137、 138、139、150、151、157、158、159、187、188 号段)
window.checkChinaMobile  = function (phone) {
    exp = /^1(3[4-9]|4[7]|5[012789]|8[7-8])\d{8}$/;
    if (exp.test(phone)) {
        return true;
    }
    return false;
};
//固定号码检查
window.checkPhoneCode = function (str) {
    exp = /^0\d{2,3}-\d{7,8}(-\d{1,4})?$/;
    return exp.test(str);
};

//QQ号码检查
window.checkQQ = function (str) {
    exp = /^[1-9][0-9]{4,}$/;
    return exp.test(str);
}

//邮政编码验证
window.checkPostCode = function (str) {
    exp = /^\d{6}$/;
    return exp.test(str);
};

//15位身份证转换为18位,如果参数字符串中有非数字字符,则返回"#"表示参数不正确
window.idCardUpdate = function (_str) {
    var idCard18;
    var regIDCard15 = /^(\d){15}$/;
    if (regIDCard15.test(_str)) {
        var nTemp = 0;
        var ArrInt = new Array(7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2);
        var ArrCh = new Array('1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2');
        _str = _str.substr(0, 6) + '1' + '9' + _str.substr(6, _str.length - 6);
        for (var i = 0; i < _str.length; i++) {
            nTemp += parseInt(_str.substr(i, 1)) * ArrInt[i];
        }
        _str += ArrCh[nTemp % 11];
        idCard18 = _str;
    }
    else {
        idCard18 = "#";
    }
    return idCard18;
};

//是否是有效中国身份证
window.checkIDCard = function (_str) {
    var iSum = 0;
    var info = "";
    var sId;
    var aCity = { 11: "北京", 12: "天津", 13: "河北", 14: "山西", 15: "内蒙古", 21: "辽宁", 22: "吉林", 23: "黑龙江", 31: "上海", 32: "江苏", 33: "浙江", 34: "安徽", 35: "福建", 36: "江西", 37: "山东", 41: "河南", 42: "湖北", 43: "湖南", 44: "广东", 45: "广西", 46: "海南", 50: "重庆", 51: "四川", 52: "贵州", 53: "云南", 54: "西藏", 61: "陕西", 62: "甘肃", 63: "青海", 64: "宁夏", 65: "***", 71: "台湾", 81: "香港", 82: "澳门", 91: "国外" };
    //如果输入的为15位数字,则先转换为18位身份证号
    if (_str.length == 15)
        sId = idCardUpdate(_str);
    else
        sId = _str;

    if (!/^\d{17}(\d|x)$/i.test(sId)) {
        return false;
    }
    sId = sId.replace(/x$/i, "a");
    //非法地区
    if (aCity[parseInt(sId.substr(0, 2))] == null) {
        return false;
    }
    var sBirthday = sId.substr(6, 4) + "-" + Number(sId.substr(10, 2)) + "-" + Number(sId.substr(12, 2));
    var d = new Date(sBirthday.replace(/-/g, "/"))
    //非法生日
    if (sBirthday != (d.getFullYear() + "-" + (d.getMonth() + 1) + "-" + d.getDate())) {
        return false;
    }
    for (var i = 17; i >= 0; i--) {
        iSum += (Math.pow(2, i) % 11) * parseInt(sId.charAt(17 - i), 11);
    }
    //非法校验码
    if (iSum % 11 != 1) {
        return false;
    }
    return true;
};

//密码强度判断
//0：太短 1：弱 2：一般 3：极佳
window.checkPasswordStrong = function (s) {
    var ls = 0;
    if (s.length < 6) 
	{   //太短
    }
    else 
	{
        if (/[a-z]/ig.test(s)) {//包含字母
            ls++;
        }
        if (/[0-9]/ig.test(s)) {//包含数字
            ls++;
        }
        if (/[^a-z0-9]/ig.test(s)) {//包含特殊字符
            ls++;
        }
    }
	window.status = ls;
    return ls;
};
