var $$ = function (id) {
	return "string" == typeof id ? document.getElementById(id) : id;
};
var Tween = {
	Quart: {
		easeOut: function(t,b,c,d){
			return -c * ((t=t/d-1)*t*t*t - 1) + b;
		}
	},
	Back: {
		easeOut: function(t,b,c,d,s){
			if (s == undefined) s = 1.70158;
			return c*((t=t/d-1)*t*((s+1)*t + s) + 1) + b;
		}
	},
	Bounce: {
		easeOut: function(t,b,c,d){
			if ((t/=d) < (1/2.75)) {
				return c*(7.5625*t*t) + b;
			} else if (t < (2/2.75)) {
				return c*(7.5625*(t-=(1.5/2.75))*t + .75) + b;
			} else if (t < (2.5/2.75)) {
				return c*(7.5625*(t-=(2.25/2.75))*t + .9375) + b;
			} else {
				return c*(7.5625*(t-=(2.625/2.75))*t + .984375) + b;
			}
		}
	}
}
function PicScroll(){
    this.index.apply(this,arguments)
}
PicScroll.prototype = {
    index: function (container, slider, count, options){
        this.panel = $$(container);
        this.picBox = $$(slider);
        this.panel.style.position = 'relative';
        this.numBar = $$('js_idNum');
        this.numBar.style.zIndex = 999;
        this.auto = options ? options.auto : false;
        this.auto = 3000;
    },
    _load: function (){
        this.pics = Yobj.get('a', this.picBox);
        this.btns = Yobj.get('li', this.numBar);
        var T = this, ishover;
        this.btns.each(function (o, i){
            o.onmouseover = function (){
                T.focus(i)
            }
            if (i==0) {
                o.className = 'on';
            }
        });
        this.pics.each(function (pic, i){
            pic.style.cssText = 'position:absolute;left:'+(i==0?0:-9999)+'px;top:0;z-index:'+(100-i);
        });
        this.current = 0;
        this.endFade = true;
        this.zIndex = 99;
        this.panel.onmouseover = function (){
            ishover = true
        }
        this.panel.onmouseout = function (){
            ishover = false
        }
        if (this.auto) {
            setInterval(function() {
                if (!ishover) {
                    T.focus(T.current+1)
                }
            }, this.auto);
        }
    },
    focus: function (n){
        if (n == this.current || !this.endFade) {
            return;
        }else if (n > this.pics.length-1) {
            n = 0
        }else if(n < 0){
            n = this.pics.length-1
        }
        this.endFade = false;
        var pdown = this.pics[this.current], pup = this.pics[n],T=this;
        this.btns[this.current].className = '';
        this.btns[n].className = 'on';
        this.current = n;
        var T = this;
        Yobj.fade(pup, 0);
        Yobj.fade(pdown, 1);
        pup.style.zIndex = this.zIndex++;
        pup.style.left = 0;
        Yobj.fx(function (f){
            Yobj.fade(pup, f(0, 1, false, true))
        },{           
            end: function (){
                pdown.style.left = '-9999px';
                T.endFade = true
            }
        })
    },
    Run: function(){
        this._load();
        this.Run = function(){}
   }
}