using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using System.IO;
using System.Drawing;
using System.Drawing.Imaging;

namespace ATL.Picture
{
    public class Images
    {
        /// <summary>
        /// ͼƬˮӡ
        /// </summary>
        /// <param name="path">ҪˮӡͼƬ··</param>
        /// <param name="waterpath">ˮӡͼƬ·</param>
        /// <param name="location">ˮӡλãȷĴ룩</param>
        /// <returns></returns>
        public string ImageWatermark(string path,string waterpath,string location)
        {
            //ȡļչ
            string kz_name = Path.GetExtension(path);
            //ʱָֻ֧.JPG,.BMP,.JPEGʽˮӡ
            if (kz_name == ".jpg" || kz_name == ".bmp" || kz_name == ".jpeg")
            {
                //µļ
                DateTime time = DateTime.Now;
                string filename = "" + time.Year.ToString() + time.Month.ToString() + time.Day.ToString() + time.Hour.ToString() + time.Minute.ToString() + time.Second.ToString() + time.Millisecond.ToString();
                //ҪˮӡͼƬ
                Image img = Bitmap.FromFile(path);
                //ˮӡͼƬ
                Image waterimg = Image.FromFile(waterpath);

                //ˮӡ
                Graphics g = Graphics.FromImage(img);
                //ȡˮӡλ
                ArrayList loca = GetLocation(location, img, waterimg);
                g.DrawImage(waterimg,new Rectangle(int.Parse(loca[0].ToString()),int.Parse(loca[1].ToString()),waterimg.Width,waterimg.Height));
                //ͷԴ
                waterimg.Dispose();
                g.Dispose();
                //ˮӡͼƬ
                string newpath = Path.GetDirectoryName(path) + filename + kz_name;
                img.Save(newpath);
                img.Dispose();
                //ˮӡƵԭͼƬ
                //ˮӡͼƬ滻ԭͼƬ
                File.Copy(newpath, path, true);
                //ɾˮӡ
                if (File.Exists(newpath))
                {
                    File.Delete(newpath);
                }
            }
            return path;
        }
       /// <summary>
       /// ͼƬˮӡλô
       /// </summary>
       /// <param name="location">ˮӡλ</param>
       /// <param name="img">ҪˮӡͼƬ</param>
       /// <param name="waterimg">ˮӡͼƬ</param>
       /// <returns></returns>
        private ArrayList GetLocation(string location, Image img, Image waterimg)
        {
            //洢λ
            ArrayList loca = new ArrayList();
            int x = 0;
            int y = 0;

            if (location == "LT")
            {
                x = 10;
                y = 10;
            }
            else if (location == "T")
            {
                x = img.Width / 2 - waterimg.Width / 2;
                y = img.Height - waterimg.Height;
            }
            else if (location == "RT")
            {
                x = img.Width - waterimg.Width;
                y = 10;

            }
            else if (location == "LC")
            {

                x = 10;
                y = img.Height / 2 - waterimg.Height / 2;

            }
            else if (location == "C")
            {
                x = img.Width / 2 - waterimg.Width / 2;
                y = img.Height / 2 - waterimg.Height / 2;
            }
            else if (location == "RC")
            {
                x = img.Width - waterimg.Width;
                y = img.Height / 2-waterimg.Height/2;
            }
            else if (location == "LB")
            {
                x = 10;
                y = img.Height - waterimg.Height;
            }
            else if (location == "B")
            {
                x = img.Width / 2 - waterimg.Width / 2;
                y = img.Height - waterimg.Height;
            }
            else
            {
                x = img.Width - waterimg.Width;
                y = img.Height - waterimg.Height;
            }
            loca.Add(x);
            loca.Add(y);
            return loca;
        }
        /// <summary>
        /// ˮӡ
        /// </summary>
        /// <param name="path">ͼƬ··</param>
        /// <param name="size">С</param>
        /// <param name="letter">ˮӡ</param>
        /// <param name="color">ɫ</param>
        /// <param name="location">ˮӡλ</param>
        /// <returns></returns>
        public string LetterWatermark(string path, int size,string letter,Color color,string location)
        {

            //ȡļչ
            string kz_name = Path.GetExtension(path);
            if (kz_name == ".jpg" || kz_name == ".bmp" || kz_name == ".jpeg")
            {
                //µļ
                DateTime time = DateTime.Now;
                string filename = "" + time.Year.ToString() + time.Month.ToString() + time.Day.ToString() + time.Hour.ToString() + time.Minute.ToString() + time.Second.ToString() + time.Millisecond.ToString();
                //ˮӡ

                Image img = Bitmap.FromFile(path);


                Graphics gs = Graphics.FromImage(img);
                //ȡX,Y
                ArrayList loca = GetLocation(location, img,size,letter.Length);
                //gs.DrawImage(img, new Rectangle(loca[0], loca[1], 150, 150));
                Font font = new Font("", size);
                Brush br = new SolidBrush(color);
                gs.DrawString(letter, font, br,float.Parse(loca[0].ToString()),float.Parse(loca[1].ToString()));
                gs.Dispose();
                //ˮӡͼƬ

                string newpath = Path.GetDirectoryName(path) + filename + kz_name;
                img.Save(newpath);
                img.Dispose();
                //ˮӡͼƬ滻ԭͼƬ
                File.Copy(newpath, path, true);
                //ɾˮӡ
                if (File.Exists(newpath))
                {
                    File.Delete(newpath);
                }
            }
            return path;
        }
        /// <summary>
        /// ˮӡλõķ
        /// </summary>
        /// <param name="location">λô</param>
        /// <param name="img">ͼƬ</param>
        /// <param name="width">(ˮӡΪʱ,ľĴС)</param>
        /// <param name="height">(ˮӡΪʱ,ľַĳ)</param>
        /// <returns></returns>
        private ArrayList GetLocation(string location,Image img,int width,int height)
        {
            //洢λ
            ArrayList loca = new ArrayList();
            float x = 10;
            float y = 10;

            if (location == "LT")
            {
                loca.Add(x);
                loca.Add(y);
            }
            else if (location == "T")
            {
                x = img.Width / 2 - (width * height) / 2;
                loca.Add(x);
                loca.Add(y);
            }
            else if (location == "RT")
            {
                x = img.Width - width * height;
            }
            else if (location == "LC")
            {
                y = img.Height / 2;
            }
            else if (location == "C")
            {
                x = img.Width / 2 - (width * height) / 2;
                y = img.Height / 2;               
            }
            else if (location == "RC")
            {
                x = img.Width - height;
                y = img.Height / 2;
            }
            else if (location == "LB")
            {
                y = img.Height - width-5;
            }
            else if (location == "B")
            {
                x = img.Width / 2 - (width * height) / 2;
                y = img.Height - width-5;
            }
            else 
            {
                x = img.Width - width * height;
                y = img.Height - width-5;
            }         
            loca.Add(x);
            loca.Add(y);
            return loca;
        }
        /// <summary>
        /// ͼ
        /// </summary>
        /// <param name="path"></param>
        /// <param name="width"></param>
        /// <param name="height"></param>
        /// <returns></returns>
        public string Thumbnail(string path,int width,int height)
        {
            //ȡļչ
            string kz_name = Path.GetExtension(path).ToLower();
            //µļ ԭļ
            string filename = Path.GetFileName(path);
            //ʼͼ
            Image.GetThumbnailImageAbort call = null;
            Image flagimg = Image.FromFile(path);
            Image small = flagimg.GetThumbnailImage(width, height, call, new System.IntPtr());

            string ph = path.Replace(filename, "");
            //ȡµĴ·
            string file = DateTime.Now.ToShortDateString().Replace("-", "") + DateTime.Now.ToShortTimeString().Replace(":", "");
            string thum_path = ph + "thumbnail_" + file + kz_name;
            //ͼ
            small.Save(thum_path);
            //ͷԴ
            flagimg.Dispose();
            small.Dispose();
            return thum_path;
        }

    }
}
