using System;
using System.Collections.Generic;
using System.Text;
using System.Data;

//ȫռ
using Lucene.Net.Index;
using Lucene.Net.Documents;
using Lucene.Net.Analysis.Standard;
using Lucene.Net.Search;
using Lucene.Net.QueryParsers;
using Lucene.Net.Analysis;
using Lucene.Net.Analysis.PanGu;

namespace ATL.Search
{
    public class IndexWriter
    {
        //·
        private string _path;

        public string Path
        {
            get { return _path; }
            set { _path = value; }
        }
      

        public void CreateIndex(string id, string title, string content, string kw, string url, string time)
        {
            //ִ
            PanGuAnalyzer Analyzer = new PanGuAnalyzer();
            Lucene.Net.Index.IndexWriter writer = new Lucene.Net.Index.IndexWriter(Path, Analyzer, true);

            IndexString(writer,id, title, content, kw, url, time);
            //Ż
            writer.Optimize();
            //ر
            writer.Close();
            
        }
        private void IndexString(Lucene.Net.Index.IndexWriter writer,string id,string title,string content,string kw,string url,string time)
        {
            try
            {
                Document doc = new Document();
 
                doc.Add(new Field("id", id, Field.Store.YES, Field.Index.NO));
          
                doc.Add(new Field("url", url, Field.Store.YES, Field.Index.NO));
            
                doc.Add(new Field("time", time, Field.Store.YES, Field.Index.NO));
             
                doc.Add(new Field("title", title, Field.Store.YES, Field.Index.TOKENIZED));
            
                doc.Add(new Field("content", content, Field.Store.YES, Field.Index.TOKENIZED));

                doc.Add(new Field("kw", kw, Field.Store.YES, Field.Index.TOKENIZED));

                //д
                writer.AddDocument(doc);
            }
            catch(Exception ex)
            { }

          
        }
    }
}
