﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using Fm.Bussiness;

public partial class Admin_art_class_list : BasePage
{
  
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            //创建DataTable来存储需要绑定的数据
            DataTable dt = new DataTable();
            DataColumn dc = new DataColumn();
            dc.ColumnName = "cl_id";
            dt.Columns.Add(dc);
            DataColumn dc1 = new DataColumn();
            dc1.ColumnName = "cl_name";
            dt.Columns.Add(dc1);
            DataColumn dc2 = new DataColumn();
            dc2.ColumnName = "cl_px";
            dt.Columns.Add(dc2);
            DataColumn dc3 = new DataColumn();
            dc3.ColumnName = "cl_attribute";
            dt.Columns.Add(dc3); 
            
            ColumnBind(dt);

            Rep_column.DataSource = dt;
            Rep_column.DataBind();
        }
       
    }
    //一级栏目绑定
    void ColumnBind(DataTable dt)
    {
        public_select ps = new public_select();
        DataView dv = ps.Getps("Fm_column", "cl_id,cl_name,cl_px,cl_parent,cl_attribute", "cl_id<>0 order by cl_px asc");

        foreach (DataRow row in dv.Table.Rows)
        {
            if (row["cl_parent"].ToString().Length == 2)
            {
                DataRow rows = dt.NewRow();
                rows["cl_id"] = row["cl_id"].ToString();
                rows["cl_name"] = row["cl_name"].ToString();
                rows["cl_px"] = row["cl_px"].ToString();
                rows["cl_attribute"] = row["cl_attribute"].ToString();
                dt.Rows.Add(rows);
                SubColumnBind(row["cl_parent"].ToString(),dt,dv);
            }
        }
    }
    //子栏目的绑定
    void SubColumnBind(string parent,DataTable dt,DataView dv)
    {
        foreach (DataRow row in dv.Table.Rows)
        {
            if (row["cl_parent"].ToString().Length == parent.Length + 2 && row["cl_parent"].ToString().Substring(0, parent.Length) == parent)
            {
                //空格实现栏目分类效果
                string nbsp = "";
                for (int i = 1; i <= row["cl_parent"].ToString().Length / 2; i++)
                {
                    nbsp += "&nbsp;&nbsp;";
                }
                DataRow rows = dt.NewRow();
                rows["cl_id"] = row["cl_id"].ToString();
                rows["cl_name"] = nbsp + "├" + row["cl_name"].ToString();
                rows["cl_px"] = row["cl_px"].ToString();
                rows["cl_attribute"] = row["cl_attribute"].ToString();

                dt.Rows.Add(rows);
                SubColumnBind(row["cl_parent"].ToString(), dt, dv);

            }
        } 
    }
    //删除指定的栏目
    protected void Link_Del_Click(object sender, EventArgs e)
    {
        
        //获取删除链接按钮类
        LinkButton link = sender as LinkButton;

        Column col = new Column();
        col.Delete(int.Parse(link.ToolTip));

        Response.Redirect("Erro.aspx?eid=该栏目以及其子栏目删除成功!&url=art_column_list.aspx", true);
            
    }
    //保存排序的修改
    protected void ImageButton1_Click1(object sender, ImageClickEventArgs e)
    {
        sys_column col = new sys_column();

        Fm.EntityClass.Column cn = new Fm.EntityClass.Column();

        foreach (RepeaterItem item in Rep_column.Items)
        {
            //找存储栏目ID的控件
            Label lab = item.FindControl("Label1") as Label;
            //获取存储栏目排序值的控件
            TextBox txt = item.FindControl("TextBox1") as TextBox;

            cn.cl_id = int.Parse(lab.Text);
            cn.cl_px =int.Parse(txt.Text);

            col.Column_Px_Update(cn);
        }

        Response.Redirect("Erro.aspx?eid=栏目排序修改成功!&url=art_column_list.aspx", true);
    }
    protected void Rep_column_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        Label attribute = e.Item.FindControl("Lab_attribute") as Label;
        if (attribute.Text == "0")
        {
            attribute.Text = "列表栏目";
        }
        else if (attribute.Text == "1")
        {
            attribute.Text = "封面栏目";
        }
        else
        {
            attribute.Text = "外部链接";
        }
    }
}
