﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Fm.Bussiness;

public partial class admin_art_column_tree : Fm.Bussiness.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            TreeNode root = new TreeNode();
            root.Value = "0";
            root.Text = "查看栏目";
            root.Expanded = false;
            TreeRootNode(root);
            ColumnTree.Nodes.Add(root);
        }
            
     
    }

    //绑定根节点
    void TreeRootNode(TreeNode root)
    {
           //获取栏目信息
            public_select ps = new public_select();
            DataView dv = ps.Getps("Fm_column", "cl_id,cl_name,cl_parent,cl_attribute,cl_options", "");
            //循环一级栏目
            foreach (DataRow row in dv.Table.Rows)
            {
                if (row["cl_parent"].ToString().Length == 2)
                {
                    TreeNode node = new TreeNode();
                    node.Text = row["cl_name"].ToString();
                    node.Value = row["cl_id"].ToString();
                    node.Expanded = false;
                    TreeChildNode(dv, row["cl_parent"].ToString(), node);
                    root.ChildNodes.Add(node);
                }
            }
    }
    //子节点
    void TreeChildNode(DataView dv,string parent,TreeNode node)
    {
        foreach (DataRow row in dv.Table.Rows)
        {
            if (row["cl_parent"].ToString().Length == parent.Length + 2 && row["cl_parent"].ToString().Substring(0, parent.Length) == parent)
            {
                TreeNode child = new TreeNode();
                child.Expanded = false;
                child.Text = row["cl_name"].ToString();
                child.Value = row["cl_id"].ToString();
                node.ChildNodes.Add(child);
                //递归调用
                TreeChildNode(dv, row["cl_parent"].ToString(), child);
            }
        }
    }
    //选定节点时进行相应的操作
    protected void ColumnTree_SelectedNodeChanged(object sender, EventArgs e)
    {
        TreeView tv = sender as TreeView;
        
        int cid = int.Parse(tv.SelectedNode.Value);
        if (cid != 0)
        {
            int type = int.Parse(RadioSelect.SelectedValue);
            if (type == 0)
            {
                Response.Redirect("art_column_add.aspx?cl_id=" + cid + "");
            }
            else if (type == 1)
            {
                Response.Redirect("art_column_edit.aspx?cl_id=" + cid + "");
            }
            else if (type == 2)
            {

                Column col = new Column();
                Response.Write(tv.SelectedNode.Value);
                col.Delete(cid);

                Response.Redirect("Erro.aspx?eid=该栏目以及其子栏目删除成功!&url=art_column_tree.aspx", true);
            }
            else
            {
                Response.Redirect("model_article_add.aspx?cl_id=" + cid + "");
            }
        }
     
    }

   
}
