﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Fm.Bussiness;
using System.Xml;

public partial class Admin_art_set : BasePage
{
  
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            GetConfig();
        }
    }
    //读取配置文件中的数据
    void GetConfig()
    {
        //实例化XML操作类
        Xml_work xml = new Xml_work();
        ////获取XML配置文件路径
        string path = Server.MapPath("../config/art_config.xml");
        //调用XML读取方法
        DataTable dt = xml.Xml_Reader(path, "art_set");
        //把数据绑定到界面
        txt_path.Text = dt.Rows[0]["up_path"].ToString();
        txt_type.Text = dt.Rows[0]["img_type"].ToString();
        txt_size.Text = dt.Rows[0]["up_size"].ToString();
        if (dt.Rows[0]["tr_fs"].ToString() == Radio8.Value)
        {
            Radio8.Checked = true;
        }
        else
        {
            Radio9.Checked = true;
        }
        txt_height.Text = dt.Rows[0]["img_height"].ToString();
        txt_width.Text = dt.Rows[0]["img_width"].ToString();
        if (dt.Rows[0]["wz_tp"].ToString() == Radio6.Value)
        {
            Radio6.Checked = true;
        }
        else
        {
            Radio7.Checked = true;
        }
        txt_wenzi.Text = dt.Rows[0]["sy_wenzi"].ToString();
        txt_img.Text = dt.Rows[0]["img_path"].ToString();
        txtcolor.Text = dt.Rows[0]["color"].ToString();
        txtfontsize.Text = dt.Rows[0]["fontsize"].ToString();
        string wz=dt.Rows[0]["weizhi"].ToString();

        foreach (ListItem item in RadioWz.Items)
        {
            if (item.Value == wz)
            {
                item.Selected = true;
            }
        }
        //绑定系统颜色
        DataTable color = xml.Xml_Reader(Server.MapPath("../")+"config/Color.xml","items");
        //实例化颜色对象
        foreach (DataRow row in color.Rows)
        {
            foreach (DataColumn column in color.Columns)
            {
                ListItem items = new ListItem();
                items.Value = row[column.ColumnName].ToString();
                items.Text = row[column.ColumnName].ToString();
                DropColor.Items.Add(items);
            }
        }
        ListItem li = new ListItem();
        li.Text = "选择颜色";
        li.Value = "Null";
        DropColor.Items.Insert(0,li);  
     
    }
    //保存数据
    protected void ImageButton1_Click(object sender, ImageClickEventArgs e)
    {
        //实例化XML操作类
        Xml_work xml = new Xml_work();
        //获取XML配置文件路径
        string path = Server.MapPath("../config/art_config.xml");
        //调用创建DT列的方法
        DataTable dt = xml.Table_Create(path, "art_set");
        //创建新行
        DataRow row = dt.NewRow();
        row["up_path"] = txt_path.Text;
        row["img_type"] = txt_type.Text;
        row["up_size"] = txt_size.Text;
        if (Radio8.Checked == true)
        {
            row["tr_fs"] = Radio8.Value;
        }
        else
        {
            row["tr_fs"] = Radio9.Value;
        }
        row["img_height"] = txt_height.Text;
        row["img_width"] = txt_width.Text;
        if (Radio6.Checked == true)
        {
            row["wz_tp"] = Radio6.Value;
        }
        else
        {
            row["wz_tp"] = Radio7.Value;
        }
        row["sy_wenzi"] = txt_wenzi.Text;
        row["img_path"] = txt_img.Text;

        row["weizhi"] = RadioWz.SelectedValue;

        row["fontsize"] = txtfontsize.Text;
        row["color"] = txtcolor.Text;
        dt.Rows.Add(row);
        //调用 XML更新方法
        xml.Xml_Update(path,"art_set",dt);
        Response.Redirect("Erro.aspx?eid=附件上传设置成功!&url=art_set.aspx", true);
    }
}
