﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text.RegularExpressions;
using System.Text;
using Fm.Bussiness;
using Fm.Tags;


public partial class admin_htm_list : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        
        if (!IsPostBack)
        {
            ColumnBind();
        }
    }
    //绑定栏目的方法
    void ColumnBind()
    {
        //绑定栏目信息
        Column cn = new Column();
        cn.GetColumns(Column_List);
        
        //添加第一个栏目
        ListItem item = new ListItem();
        item.Text = "所有栏目";
        item.Value = "0";

        Column_List.Items.Insert(0, item);
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        public_select ps = new public_select();//公用查询类
        //查询栏目信息
        DataView dv = ps.Getps("Fm_column", "*", "");

        bool bo = false;//用来判断是否选择了所有栏目
        foreach (ListItem item in Column_List.Items)
        {
            if (item.Selected)
            {
                if (item.Value == "0")
                {
                    bo = true;
                }
            }
        }
        if (bo)
        {
            foreach (DataRow row in dv.Table.Rows)
            {
                WriteFile(row);
            }
        }
        else
        {
            foreach (ListItem item in Column_List.Items)
            {
                //如果是选择项才更新静态栏目
                if (item.Selected)
                {
                    foreach (DataRow row in dv.Table.Rows)
                    {
                        if (row["cl_id"].ToString() == item.Value)
                        {
                            //判断是否连子栏目一起生成
                            if (Radio_Parent.SelectedValue == "0")
                            {
                                WriteFile(row);
                            }
                            else
                            {
                                //获取所选栏目parent
                                string parent = row["cl_parent"].ToString();
                                //循环生成子栏目静态文档
                                foreach (DataRow dr in dv.Table.Rows)
                                {
                                    if (dr["cl_parent"].ToString().Length >= parent.Length)
                                    {
                                        if (dr["cl_parent"].ToString().Substring(0, parent.Length) == parent)
                                        {
                                            WriteFile(dr);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Lab_info.Text = "系统提示:列表页生成成功!";
        //生成后重新绑定栏目
        Column_List.Items.Clear();
        ColumnBind();

    }
    void WriteFile(DataRow row)
    {
        ATL.IO.IOStream stream = new ATL.IO.IOStream();//文件读取类
        //获取栏目ID
        int cid=int.Parse(row["cl_id"].ToString());
        Temp_List list = new Temp_List();//列表页内容获取类
       
      
        //获取模版服务器存放路径
        string temp = Server.MapPath("../templates/");
        //获取栏目存放路径
        string path = Server.MapPath("../");
       //判断栏目属性,并且根据栏目属性设置生成相关的静态页面
        if (row["cl_attribute"].ToString() == "0")
        {
            //判断是不是动态栏目,如果不是动态栏目才进行静态生成
            if (row["cl_options"].ToString() != "2")
            {
                //分页数据获取类
                Formpage page = new Formpage();

                int count = GetPage(row);
                //Response.Write(count.ToString());
                string where = "colid="+row["cl_id"].ToString();
                DataView dw = page.PageRow("Fm_model_article_view", "docid", count, 1, where) as DataView;
                //获取数据条数
                int RowNum = int.Parse(dw[0]["total"].ToString());
                //获取分页页数

                int RowCount = 0;
                if (RowNum % count == 0)
                {
                    RowCount = RowNum / count;
                }
                else
                {
                    RowCount = RowNum / count + 1;
                }
                if (RowCount == 0)
                {
                    RowCount = 1;
                }
                int htmcount = int.Parse(txtcount.Text);
                string content="";
                //循环生成静态文档
                for (int p = 1; p <= RowCount; p++)
                {
                    if (p <= htmcount)
                    {
                        content = list.Get_List(temp, cid, p,htmcount);
                        //生成列表页第一页的封页
                        if (p == 1)
                        {
                            stream.WriteFile(path + row["cl_path"].ToString() + row["cl_default"].ToString(), content);
                            //Response.Write(path+row["cl_path"].ToString()+row["cl_default"].ToString()+"<br>");
                        }
                        //替换列表页命名规则中的栏目ID和页码
                        string listname = row["cl_list"].ToString().Replace("{cid}", cid.ToString()).Replace("{page}", p.ToString());
                        //生成静态文档
                        // Response.Write(path+row["cl_path"].ToString()+listname+"<br>");
                        stream.WriteFile(path + row["cl_path"].ToString() + listname, content);
                    }
                }
            }
        }
        else if (row["cl_attribute"].ToString() == "1")
        {
            // 生成封面页栏目
            //替换列表页命名规则中的栏目ID和页码
            string listname = row["cl_path"].ToString() + row["cl_default"].ToString();
            //写入文件
            string content = list.Get_List(temp, cid, 1,0);
            stream.WriteFile(path + listname, content);
        }
        else
        { }
     
    }
    //获取页码数
    int GetPage(DataRow row)
    {

        ATL.IO.IOStream stream = new ATL.IO.IOStream();//文件读取类
        string content = stream.ReadFile(Server.MapPath("../templates/")+row["cl_temp_list"].ToString());
        //正则获取标签信息
        Regex r = new Regex(@"(\{fm:page\s+(?<attributes>[^\]]*?)\}(?<text>[\s\S]*?)\{/fm:page\})", RegexOptions.Compiled | RegexOptions.IgnoreCase);
        //标签解析开始---
        string Attributes = "";//存储属性
        string count = null;
        foreach (Match m in r.Matches(content))
        {
            //获取属性值和标签
            Attributes = m.Groups["attributes"].ToString(); 
            count = TagVal(Attributes, "count");

            if (count == null)
            {
                count = "20";
            }
        }
        return int.Parse(count);
    }
    //获取标签参数
    private string TagVal(string tag, string tagName)
    {
        Regex r = new Regex(@"(?<key>\w+)\s*=\s*(?<value>" + "\"" + "[^\"]*\")", RegexOptions.Compiled | RegexOptions.IgnoreCase);
        foreach (Match m in r.Matches(tag))
        {
            if (m.Groups["key"].ToString().Trim().ToLower() == tagName.ToLower())
            {
                return m.Groups["value"].ToString().ToLower().Replace("\"", "");
            }
        }
        return null;
    }
}
