﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Fm.Bussiness;

public partial class admin_tupian_upload : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        Label1.Text = "原图预览:";
     
    }
    DataTable GetXml()
    {
        //实例化XML文件操作类
        Xml_work xml = new Xml_work();
        //获取XML配置文件路径
        string path = Server.MapPath("../config/art_config.xml");
        //调用读取类
        DataTable dt=xml.Xml_Reader(path,"art_set");
        return dt;

    }
    //图片上传操作
    protected void Button1_Click(object sender, EventArgs e)
    {
        DataTable dt = GetXml();
        //获取设置的有效图片格式
        string[] type = dt.Rows[0]["img_type"].ToString().Split('|');
        //获取扩展名
        string kzm = FileUpload1.FileName.Substring(FileUpload1.FileName.LastIndexOf("."),FileUpload1.FileName.Length-FileUpload1.FileName.LastIndexOf("."));
        
        //循环判断上传的图片格式是否有效
        bool bo = false;
        for (int i = 0; i < type.Length; i++)
        {
            if (kzm =="."+type[i].ToString())
            {
                bo = true;
            }
        }

        //判断上传图片是不是符合设置
        if (FileUpload1.PostedFile.ContentLength / 1024 > int.Parse(dt.Rows[0]["up_size"].ToString()))
        {
            Response.Write("<script>alert('请选择小于 " + dt.Rows[0]["up_size"].ToString() + "KB 的图片');</script>");
        }
        else if (bo == false)
        {
            Response.Write("<script>alert('请选择有效的图片格式');</script>");
        }
        else
        {
            string path = Server.MapPath("~/") + dt.Rows[0]["up_path"].ToString();
            //上传图片前创建新文件夹
            string year = DateTime.Now.Year.ToString();
            string month = DateTime.Now.Month.ToString();
            if (month.Length == 1)
            {
                month = "0" + month;
            }
            string data = DateTime.Now.Day.ToString();
            if (data.Length == 1)
            {
                data = "0" + data;
            }
            path = path + "/images/" + year + "/" + month + "/" + data;
            ATL.IO. IOStream stream = new ATL.IO.IOStream();
            if (!System.IO.File.Exists(path))
            {
                stream.CreateFolder(path);
            }
            //上传所选择的图片
            string ph=path+"/"+FileUpload1.FileName;
            FileUpload1.SaveAs(ph);
            //获取缩略图的大小
            int width = 120;
            int height = 120;
            if (Radio_Set.Checked == true)
            {
                 width = int.Parse(dt.Rows[0]["img_width"].ToString());
                 height = int.Parse(dt.Rows[0]["img_height"].ToString());
            }
            if (Radio_Customize.Checked == true)
            {
                width = int.Parse(txt_width.Value);
                height = int.Parse(txt_height.Value);
            }
            if(Radio_cause.Checked==true) 
            {
                System.Drawing.Image image=System.Drawing.Image.FromFile(ph);
                width = image.Width;
                height = image.Height;
                //释放资源
                image.Dispose();
            }
            //生成缩略图
            ATL.Picture.Images img = new ATL.Picture.Images();

            string src=img.Thumbnail(ph,width ,height );
            //处理缩略图路径
            src ="/"+ src.Replace(Server.MapPath("../"),"");
            Image1.Src = src; 
            Image1.Width = width;
            Image1.Height = height;
            Hidden1.Value = src;
            //删除原有图片
            if (System.IO.File.Exists(ph))
            {
                System.IO.File.Delete(ph);
            }
        
        }
    }
}
