﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Fm.Bussiness;
using System.Text.RegularExpressions;

public partial class Controls_FormPaging : System.Web.UI.UserControl
{
    Formpage page = new Formpage();
    //分页所需传过来的参数
    private string _tableName;

    public string TableName
    {
        get { return _tableName; }
        set { _tableName = value; }
    }

    private string _colName;

    public string ColName
    {
        get { return _colName; }
        set { _colName = value; }
    }

    private GridView _gv;

    public GridView Gv
    {
        get { return _gv; }
        set { _gv = value; }
    }

    private string _where;

    public string Where
    {
        get { return _where; }
        set { _where = value; }
    }


    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            BindPage(1);
        }
        
    }
    //绑定到控件上
    void BindView(int PageSize, int PageIndex)
    {
       
        if (Where == "")
        {
            Gv.DataSource = page.PageView(TableName, ColName, PageSize, PageIndex);
            Gv.DataBind();
        }
        else
        {

            Gv.DataSource = page.PageView_Bywhere(TableName, ColName, PageSize, PageIndex, Where);
            Gv.DataBind();
        }
    }
    //绑定相关数据
    public void BindPage(int PageIndex)
    {
        //取得分页设置里面的值

        int PageSize = 20;
        //得到指定表的记录数量
        string where = "";
        if (Where != "")
        {
            where = Where;
        }
        DataView dv1 = page.PageRow(TableName, ColName, PageSize, 1, where) as DataView;

        int RowNum = int.Parse(dv1[0]["total"].ToString());

   
         RowCount.Text= RowNum.ToString();
        int PageCount = 0;
        //取得一共有多少页
        if (RowNum % PageSize == 0)
        {
            PageCount = RowNum / PageSize;
        }
        else
        {
            PageCount = RowNum / PageSize + 1;
        }

    

        //判断上一页是否超出范围
        if (PageIndex == 1)
        {
             Index.Enabled = false;
             OnIndex.Enabled = false;
        }
        else
        {
            Index.Enabled = true;
            OnIndex.Enabled = true;
        }
        //判断下一页是否超出范围
        if (PageIndex == PageCount)
        {
            FinallyIndex.Enabled = false;
            UnderIndex.Enabled = false;
        }
        else
        {
            FinallyIndex.Enabled = true;
            UnderIndex.Enabled = true;
        }
        ViewState["pagecount"] = PageCount.ToString();
        if (PageCount != 0)
        {
            PeIndex.Text = PageIndex.ToString();
        }
        else
        {
            PeIndex.Text = "0";
        }
            PageRowCount.Text = PageCount.ToString();

            BindView(PageSize, PageIndex);
    

    }
    //首页
    protected void Index_Click(object sender, EventArgs e)
    {
        BindPage(1);
    }
    //上一页
    protected void OnIndex_Click(object sender, EventArgs e)
    {
        BindPage(int.Parse(PeIndex.Text)-1);
    }
    //下一页
    protected void UnderIndex_Click(object sender, EventArgs e)
    {
        BindPage(int.Parse(PeIndex.Text)+1);
    }
    //最后一页
    protected void FinallyIndex_Click(object sender, EventArgs e)
    {
        BindPage(int.Parse(PageRowCount.Text));
    }
    //跳转
    protected void Button1_Click(object sender, EventArgs e)
    {
        Regex reg = new Regex("^[1-9]");
        Match ma = reg.Match(TurnIndex.Text);
        int PageCount= int.Parse(ViewState["pagecount"].ToString());
        if (ma.Success)
        {
            int PageIndex = int.Parse(TurnIndex.Text);
            if (PageIndex < 1 || PageIndex > PageCount)
            {
                Response.Write("<script>alert('你输入的页码超出范围');</script>");
            }
            else
            {
                BindPage(int.Parse(TurnIndex.Text));
            }
        }
        else
        {
            Response.Write("<script>alert('请输入正确的页码');</script>");
        }
    }
}
