using System;
using System.Web;
using System.Web.UI;
using System.Xml;
using System.Xml.Serialization;
using System.IO;
using System.Collections; 
using Meta.Web; 
using Meta.Web.Security; 

namespace MetaSite.Components
{
	/// <summary>
	/// AdminSettings
	/// </summary>
	public class AdminSettings
	{
		static string _fileLocation;
		public static string FileLocation
		{
			get 
			{
				if(_fileLocation == null)
					_fileLocation = "~/admin.config";

				return _fileLocation; 
			}
			set {  _fileLocation = value; }
		}

		public static ToolItemCollection GetTools()
		{
			string path = ContextData.Current.Context.Request.MapPath(FileLocation);

			ToolItemCollection tc = CacheData.Get(path) as ToolItemCollection;
			if(tc == null)
			{                
				tc = (ToolItemCollection)ConvertFileToObject(path,typeof(ToolItemCollection));
				CacheData.Max(path,tc,new System.Web.Caching.CacheDependency(path));
			}
			return tc;
		}

		public static object ConvertFileToObject(string path, Type objectType)
		{
			object convertedObject = null;

			if(path != null && path.Length > 0)
			{
				using(FileStream fs = new FileStream(path,FileMode.Open,FileAccess.Read))
				{
					XmlSerializer ser = new XmlSerializer(objectType);
					convertedObject = ser.Deserialize(fs);
					fs.Close();
				}
			}
			return convertedObject;
		}

		public static bool InAdminRoles()
		{
			User user = ContextData.Current.User;
  
			return InAdminRoles(user,null);
		}

		public static bool InAdminRoles(string tool)
		{
			User user = ContextData.Current.User;
  
			return InAdminRoles(user,tool);
		}

		/*public static bool InAdminRoles(User user)
		{
            ToolItemCollection tc = GetTools();
			string roles = string.Empty; 

			foreach ( ToolItem t in tc.ToolItems)
			{
				if ( t.HasRoles )
				{
					roles += "," + t.Roles; 
				}
			}

			if ( roles == string.Empty)
				return false;

			roles = roles.Substring(1);
			string[] ars = roles.Split(',');
			string[] urs = Roles.GetRolesForUser(user.UserName);  
  
			foreach( string ur in urs)
			{
				foreach( string ar in ars)
				{
					if ( ur.ToLower() == ar.ToLower())
						return true;
				}
			}
            
			return false;
		}*/
		
		public static bool InAdminRoles(User user,string tool)
		{
			ToolItemCollection tc = GetTools();
			string roles = string.Empty; 

			foreach ( ToolItem t in tc.ToolItems)
			{
				if ( tool != null && tool != string.Empty)
				{
					if ( t.Name.ToLower() == tool.ToLower() && t.HasRoles )
					{
						roles += "," + t.Roles; 
					}
				}
				else
				{
					if ( t.HasRoles )
					{
						roles += "," + t.Roles; 
					}
				}
			}

			if ( roles == string.Empty)
				return false;

			roles = roles.Substring(1);
			string[] ars = roles.Split(',');
			string[] urs = Roles.GetRolesForUser(user.UserName);  
  
			foreach( string ur in urs)
			{
				foreach( string ar in ars)
				{
					if ( ur.ToLower() == ar.ToLower())
						return true;
				}
			}
            
			return false;
		}
	}
}
