using System;
using System.Xml; 
using System.Configuration;
using Meta.Web.Security;
using MetaSite.Components.Providers; 

namespace MetaSite.Components.Configuration
{
	/// <summary>
	/// UsersConfigHandler
	/// </summary>
	public class UsersConfigHandler : IConfigurationSectionHandler
	{
		
		public object Create(object parent, object configContext, System.Xml.XmlNode section)
		{
			UsersProvider up = new UsersProvider();

			foreach (XmlAttribute attrib in section.Attributes)
			{				
				if ( attrib.Name == "MinRequiredPasswordLength")
					up.MinRequiredPasswordLength  = int.Parse(attrib.Value);
				else 	if ( attrib.Name == "UserIsOnlineTimeWindow")
					up.UserIsOnlineTimeWindow  = int.Parse(attrib.Value);				
			} 
			return up; 
		}
	}
}

#region"ck"
		/*
		using System;
		using System.Collections;
		using System.Text;
		using System.Configuration;
		using System.Xml;

		namespace MyConfigSectionHandler
		{
			public class MyHandler : IConfigurationSectionHandler
			{
				#region IConfigurationSectionHandler Members

				object IConfigurationSectionHandler.Create(	object parent, object configContext, XmlNode section)
				{
			
					Hashtable myConfigObject = new Hashtable();

				
					Hashtable myAttribs = new Hashtable();
					foreach (XmlAttribute attrib in section.Attributes)
					{
						if (XmlNodeType.Attribute == attrib.NodeType)
						myAttribs.Add(attrib.Name, attrib.Value);
					}

					
					myConfigObject.Add(section.Name, myAttribs);

				
					foreach (XmlNode child in section.ChildNodes)
					{
						if (XmlNodeType.Element == child.NodeType)
						{
						Hashtable myChildAttribs = new Hashtable();

						foreach (XmlAttribute childAttrib in child.Attributes)
						{
							if (XmlNodeType.Attribute == childAttrib.NodeType)
							myChildAttribs.Add(childAttrib.Name, childAttrib.Value);
						}
						myConfigObject.Add(child.Name, myChildAttribs);
						}
					}

					return (myConfigObject);
		    	}
		    	#endregion
			}
		}
		
		//***************************************************************
		
		<configuration>
		<configSections>
			<sectionGroup name="Security">
				<section name="UsersProvider"type=MetaSite.Components.UsersConfigHandler" allowLocation="false"/>
				<section name="RolesProvider"type=MetaSite.Components.RolesConfigHandler" allowLocation="false"/>
			</sectionGroup>
		</configSections>   
		<Security>
			<UsersProvider></UsersProvider>
			<RolesProvider></RolesProvider>
		</Security> 
		</configuration>
 */

#endregion
		

