using System;
using Meta.Web;
using System.Collections.Specialized;
//51a/s/px./com

namespace MetaSite.Components.Controls
{
	/// <summary>
    /// MapPath 
	/// </summary>
	public class MapPath : Meta.Web.Controls.MapPathbar    
	{
		public MapPath()
		{
            this.BorderColor = System.Drawing.Color.Sienna;
  			this.BorderStyle = System.Web.UI.WebControls.BorderStyle.Dotted;
			this.BorderWidth = 1;
			this.Text = "&nbspڵλ:&nbsp";
			this.CssClass = "default";
		}

        protected override void OnInit(EventArgs e)
        {
            base.OnInit(e);
            ContextData context = ContextData.Current;
            int forumId = context.GetIntFromQueryString("forumid", -1);
            int parent = context.GetIntFromQueryString("parent", -1);
            int postId = context.GetIntFromQueryString("postid", -1);

            if (forumId == -1 && postId > -1)
                forumId = Posts.GetPost(postId).ForumId;

            if (forumId + parent > -1)
            {
                Forum forum = (forumId > -1) ? Forums.GetForum(forumId) : Forums.GetForum(parent);

                Nodes.Clear();
               
                if (TopNode == 0)
                    Nodes.Add("ҳ", Globals.UrlBase + "/default.aspx");
                else
                    Nodes.Add("̳", Globals.UrlBase + "/forum/default.aspx");                

                NameValueCollection list = new NameValueCollection();

                if (postId > -1)
                {
                    if (TopNode == 0)
                        list.Add(forum.Name, Globals.UrlBase + "/showlist.aspx?forumid=" + forum.ForumId);
                    else
                        list.Add(forum.Name, Globals.UrlBase + "/forum/showforum.aspx?forumid=" + forum.ForumId);
                }
                else
                    list.Add(forum.Name, "");
               
                Forum f = forum;
                while (f.ParentId > -1)
                {
                    f = Forums.GetForum(f.ParentId);
                    if (TopNode == 0)
                        list.Add(f.Name, Globals.UrlBase + "/showgrouplist.aspx?parent=" + f.ForumId);
                    else
                         list.Add(f.Name, Globals.UrlBase + "/forum/default.aspx?parent=" + f.ForumId);
                }

                for (int i = list.Keys.Count - 1; i > -1; i--)
                {
                    Nodes.Add(list.Keys[i], list[list.Keys[i]]);
                }
            }
        }

        public int TopNode
        {
            get {
                object o = ViewState["TopNode"];
                return o == null ? 0 : (int)o;
            }
            set { ViewState["TopNode"] = value; }
        }

		protected override void Render(System.Web.UI.HtmlTextWriter writer)
		{
			writer.Write("<br>");
			base.Render (writer);
			writer.Write("<br>");
		}
	}
}
